########################################################################
#
#    Vision Node - Python source code - file generated by vision
#    Monday 26 November 2007 10:07:32 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/VisionLibraries/scipylib/signal/linearChirp.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#
# $Id: linearChirp.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#

# import node's base class node
from NetworkEditor.items import NetworkNode
from scipy.signal import chirp
class linearChirp(NetworkNode):
    mRequiredTypes = {}
    mRequiredSynonyms = [
    ]
    def __init__(self, constrkw = {},  name='linearChirp', **kw):
        kw['constrkw'] = constrkw
        kw['name'] = name
        apply( NetworkNode.__init__, (self,), kw)
        code = """def doit(self, time, chirpSlope, f0):
        t1=time[-1]
        f1 = chirpSlope*(time[-1]-time[0]) + f0
        data=chirp(time,f0,t1,f1,method='linear')
        self.outputData(y=data)
"""
        self.configure(function=code)
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'time', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'chirpSlope', 'cast': True, 'datatype': 'float', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green', 'originalDatatype': 'None'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'f0', 'cast': True, 'datatype': 'float', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green', 'originalDatatype': 'None'})
        self.outputPortsDescr.append(
            {'name': 'y', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.widgetDescr['chirpSlope'] = {
            'initialValue': 1.0, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'left', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'increment':5, 'height': 20, 'labelGridCfg': {'rowspan': 1, 'column': 0, 'sticky': 'w', 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'width': 60, 'master': 'node', 'wheelPad': 1, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 0}, 'labelCfg': {'text': 'chirpSlope'}, 'class': 'NEThumbWheel', 'oneTurn': 50.0}
        self.widgetDescr['f0'] = {
            'initialValue': 1.0, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'left', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 1}, 'increment':5, 'height': 20, 'labelGridCfg': {'rowspan': 1, 'column': 0, 'sticky': 'w', 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 1}, 'width': 60, 'master': 'node', 'wheelPad': 1, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 0}, 'labelCfg': {'text': 'f0'}, 'class': 'NEThumbWheel', 'oneTurn': 50.0}


    def beforeAddingToNetwork(self, net):
        try:
            ed = net.getEditor()
        except:
            import traceback; traceback.print_exc()
            print 'Warning! Could not import widgets'

