#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Tuesday 15 February 2011 10:50:53 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/CADD/workflows/virtualScreening/VinaVSlocal_0.1_net.py,v 1.1 2011/04/15 16:19:40 nadya Exp $
#
# $Id: VinaVSlocal_0.1_net.py,v 1.1 2011/04/15 16:19:40 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from AutoDockTools.VisionInterface.Adt import Adt
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(Adt,"AutoDockTools.VisionInterface.Adt", "Adt")

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://ws.nbcr.net/opal2", replace=False)
except:
    pass
try:
    addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
except:
    pass
try:
    ## saving node StructureBrowser ##
    from Adt.Input.StructureBrowser import StructureBrowser
    StructureBrowser_0 = StructureBrowser(constrkw={}, name='StructureBrowser', library=Adt)
    masterNet.addNode(StructureBrowser_0,32,37)
    StructureBrowser_0.inputPortByName['receptor_file'].widget.set(r"VinaVSlocal_0.1_input/2HTY_A-2HTY_A.pdb", run=False)
    apply(StructureBrowser_0.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore StructureBrowser named StructureBrowser in network masterNet"
    print_exc()
    StructureBrowser_0=None

try:
    ## saving node Vina Config File Browser ##
    from Vision.StandardNodes import FileBrowserNE
    Vina_Config_File_Browser_1 = FileBrowserNE(constrkw={}, name='Vina Config File Browser', library=stdlib)
    masterNet.addNode(Vina_Config_File_Browser_1,849,41)
    Vina_Config_File_Browser_1.inputPortByName['filename'].widget.set(r"VinaVSlocal_0.1_input/test.config", run=False)
    apply(Vina_Config_File_Browser_1.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named Vina Config File Browser in network masterNet"
    print_exc()
    Vina_Config_File_Browser_1=None

try:
    ## saving node PrepareReceptor ##
    from Adt.Macro.PrepareReceptor import PrepareReceptor
    PrepareReceptor_2 = PrepareReceptor(constrkw={}, name='PrepareReceptor', library=Adt)
    masterNet.addNode(PrepareReceptor_2,151,197)
    apply(PrepareReceptor_2.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    Pdb2pqrWS_5 = PrepareReceptor_2.macroNetwork.nodes[2]
    Pdb2pqrOpalService_ws_nbcr_net_9 = Pdb2pqrWS_5.macroNetwork.nodes[3]
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['noopt'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['phi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['psi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['verbose'].widget.set(1, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['chain'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['nodebump'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['chi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['ligand'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['hbond'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['with_ph'].widget.set(r"", run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['forcefield'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['forcefield'].widget.set(r"AMBER", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['clean'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['inId'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['apbs_input'].widget.set(0, run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['ffout'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['ffout'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['localRun'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['rama'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['execPath'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_9.inputPortByName['assign_only'].widget.set(0, run=False)
    GetURLFromList_10 = Pdb2pqrWS_5.macroNetwork.nodes[4]
    GetURLFromList_10.inputPortByName['ext'].widget.set(r"pqr", run=False)

    ## saving connections for network Pdb2pqrWS ##
    Pdb2pqrWS_5.macroNetwork.freeze()
    Pdb2pqrWS_5.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_6 = Pdb2pqrWS_5.macroNetwork.ipNode
    input_Ports_6.outputPorts[1].configure(name='CheckFileFormat_value')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_7 = Pdb2pqrWS_5.macroNetwork.opNode
    output_Ports_7.inputPorts[1].configure(singleConnection='auto')
    output_Ports_7.inputPorts[2].configure(singleConnection='auto')
    output_Ports_7.inputPorts[1].configure(name='UpdateReceptor_receptor_obj')
    output_Ports_7.inputPorts[2].configure(name='UpdateReceptor_pdb2pqr_result')
    Pdb2pqrWS_5.inputPorts[0].configure(name='CheckFileFormat_value')
    Pdb2pqrWS_5.inputPorts[0].configure(datatype='receptor')
    ## configure MacroNode input ports
    Pdb2pqrWS_5.outputPorts[0].configure(name='UpdateReceptor_receptor_obj')
    Pdb2pqrWS_5.outputPorts[0].configure(datatype='receptor')
    Pdb2pqrWS_5.outputPorts[1].configure(name='UpdateReceptor_pdb2pqr_result')
    Pdb2pqrWS_5.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    Pdb2pqrWS_5.shrink()
    PrepareReceptorWS_12 = PrepareReceptor_2.macroNetwork.nodes[3]
    PrepareReceptorOpalService_ws_nbcr_net_16 = PrepareReceptorWS_12.macroNetwork.nodes[3]
    PrepareReceptorOpalService_ws_nbcr_net_16.inputPortByName['o'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_16.inputPortByName['v'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_16.inputPortByName['localRun'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_16.inputPortByName['execPath'].widget.set(r"", run=False)
    GetURLFromList_17 = PrepareReceptorWS_12.macroNetwork.nodes[4]
    GetURLFromList_17.inputPortByName['ext'].widget.set(r"pdbqt", run=False)
    DownloadToFile_18 = PrepareReceptorWS_12.macroNetwork.nodes[5]
    DownloadToFile_18.inputPortByName['overwrite'].widget.set(1, run=False)

    ## saving connections for network PrepareReceptorWS ##
    PrepareReceptorWS_12.macroNetwork.freeze()
    PrepareReceptorWS_12.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_13 = PrepareReceptorWS_12.macroNetwork.ipNode
    input_Ports_13.outputPorts[1].configure(name='CheckFileFormat_value')
    input_Ports_13.outputPorts[2].configure(name='PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_14 = PrepareReceptorWS_12.macroNetwork.opNode
    output_Ports_14.inputPorts[1].configure(singleConnection='auto')
    output_Ports_14.inputPorts[2].configure(singleConnection='auto')
    output_Ports_14.inputPorts[1].configure(name='UpdateReceptor_receptor_prepared_obj')
    output_Ports_14.inputPorts[2].configure(name='UpdateReceptor_receptor_result')
    PrepareReceptorWS_12.inputPorts[0].configure(name='CheckFileFormat_value')
    PrepareReceptorWS_12.inputPorts[0].configure(datatype='receptor')
    PrepareReceptorWS_12.inputPorts[1].configure(name='PrepareReceptorOpalService_ws_nbcr_net_C')
    PrepareReceptorWS_12.inputPorts[1].configure(datatype='boolean')
    ## configure MacroNode input ports
    PrepareReceptorWS_12.outputPorts[0].configure(name='UpdateReceptor_receptor_prepared_obj')
    PrepareReceptorWS_12.outputPorts[0].configure(datatype='receptor_prepared')
    PrepareReceptorWS_12.outputPorts[1].configure(name='UpdateReceptor_receptor_result')
    PrepareReceptorWS_12.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    PrepareReceptorWS_12.shrink()

    ## saving connections for network PrepareReceptor ##
    PrepareReceptor_2.macroNetwork.freeze()
    PrepareReceptor_2.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_3 = PrepareReceptor_2.macroNetwork.ipNode
    input_Ports_3.outputPorts[1].configure(name='Pdb2pqrWS_CheckFileFormat_value')
    input_Ports_3.outputPorts[2].configure(name='PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_4 = PrepareReceptor_2.macroNetwork.opNode
    output_Ports_4.inputPorts[1].configure(singleConnection='auto')
    output_Ports_4.inputPorts[2].configure(singleConnection='auto')
    output_Ports_4.inputPorts[1].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj')
    output_Ports_4.inputPorts[2].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_result')
    PrepareReceptor_2.inputPorts[0].configure(name='Pdb2pqrWS_CheckFileFormat_value')
    PrepareReceptor_2.inputPorts[0].configure(datatype='receptor')
    PrepareReceptor_2.inputPorts[1].configure(name='PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')
    PrepareReceptor_2.inputPorts[1].configure(datatype='boolean')
    ## configure MacroNode input ports
    PrepareReceptor_2.outputPorts[0].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj')
    PrepareReceptor_2.outputPorts[0].configure(datatype='receptor_prepared')
    PrepareReceptor_2.outputPorts[1].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_result')
    PrepareReceptor_2.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    PrepareReceptor_2.shrink()
    apply(PrepareReceptor_2.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore PrepareReceptor named PrepareReceptor in network masterNet"
    print_exc()
    PrepareReceptor_2=None

try:
    ## saving node Vina ##
    from NetworkEditor.macros import MacroNode
    Vina_20 = MacroNode(name='Vina')
    masterNet.addNode(Vina_20, 350, 259)
    output_Ports_22 = Vina_20.macroNetwork.opNode
    apply(output_Ports_22.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from NetworkEditor.items import FunctionNode
    AutodockVina_Screening_kryptonite_nbcr_net_23 = FunctionNode(functionOrString='AutodockVina_Screening_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", namedArgs={'num_modes': '', 'energy_range': '', 'seed': '', 'receptor': '', 'size_y': '', 'size_z': '', 'out': '', 'log': '', 'urllib': '', 'exhaustiveness': '', 'localRun': False, 'flex': '', 'center_z': '', 'center_x': '', 'center_y': '', 'userlib': '', 'size_x': '', 'config': '', 'filter': '', 'ligand_db': '', 'cpu': '', 'execPath': ''}, constrkw={'functionOrString': "'AutodockVina_Screening_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'namedArgs': {'num_modes': '', 'energy_range': '', 'seed': '', 'receptor': '', 'size_y': '', 'size_z': '', 'out': '', 'log': '', 'urllib': '', 'exhaustiveness': '', 'localRun': False, 'flex': '', 'center_z': '', 'center_x': '', 'center_y': '', 'userlib': '', 'size_x': '', 'config': '', 'filter': '', 'ligand_db': '', 'cpu': '', 'execPath': ''}}, name='AutodockVina_Screening_kryptonite_nbcr_net', library=wslib)
    Vina_20.macroNetwork.addNode(AutodockVina_Screening_kryptonite_nbcr_net_23,217,185)
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['receptor'].configure, (), {'defaultValue': None})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['urllib'].configure, (), {'defaultValue': None})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['userlib'].configure, (), {'defaultValue': None})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['config'].configure, (), {'defaultValue': None, 'required': True})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['filter'].configure, (), {'defaultValue': None})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['num_modes'].widget.configure, (), {'choices': ('1', '2', '3', '4', '5', '6', '7', '8', '9', '10')})
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['num_modes'].widget.set(r"", run=False)
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['energy_range'].widget.configure, (), {'choices': ('1', '2', '3')})
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['energy_range'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['seed'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['receptor'].rebindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['receptor'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['receptor'].unbindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['size_y'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['size_z'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['out'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['log'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['urllib'].rebindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['urllib'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['urllib'].unbindWidget()
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['exhaustiveness'].widget.configure, (), {'choices': ('1', '2', '3', '4', '5', '6', '7', '8')})
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['exhaustiveness'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['localRun'].widget.set(0, run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['flex'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['center_z'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['center_x'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['center_y'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['userlib'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['size_x'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['config'].rebindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['config'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['config'].unbindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['filter'].rebindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['filter'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['filter'].unbindWidget()
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['ligand_db'].widget.configure, (), {'choices': ('sample', 'NCIDS_SC', 'NCI_DS1', 'NCI_DS2', 'human_metabolome', 'chembridge_building_blocks', 'drugbank_nutraceutics', 'drugbank_smallmol', 'asinex', 'fda_approved', 'otava', 'zinc_natural_products')})
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['ligand_db'].widget.set(r"", run=False)
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['cpu'].widget.configure, (), {'choices': ('1', '2')})
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['cpu'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_23.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(AutodockVina_Screening_kryptonite_nbcr_net_23.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    PrepareVinaInputs_24 = Generic(constrkw={}, name='PrepareVinaInputs', library=stdlib)
    Vina_20.macroNetwork.addNode(PrepareVinaInputs_24,140,107)
    apply(PrepareVinaInputs_24.addInputPort, (), {'singleConnection': True, 'name': 'receptor_obj', 'cast': True, 'datatype': 'receptor_prepared', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'triangle', 'color': '#009900', 'originalDatatype': 'None'})
    apply(PrepareVinaInputs_24.addInputPort, (), {'singleConnection': True, 'name': 'ligand_obj', 'cast': True, 'datatype': 'LigandDB', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'rect', 'color': '#FFCCFF', 'originalDatatype': 'None'})
    apply(PrepareVinaInputs_24.addOutputPort, (), {'name': 'receptor_file', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(PrepareVinaInputs_24.addOutputPort, (), {'name': 'ligand_lib', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(PrepareVinaInputs_24.addOutputPort, (), {'name': 'filter_file', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, receptor_obj, ligand_obj):
        receptor_file = receptor_obj.path
        filter_file = ligand_obj.filter_file
        ligand_lib = ligand_obj.loc

        if receptor_obj.type == "local":
            if not(os.path.exists(receptor_file)):
                print "ERROR: receptor_file " + receptor_file + " does not exist"
                return '''stop'''
        
	pass
        self.outputData(receptor_file=receptor_file, ligand_lib=ligand_lib, filter_file=filter_file)
## to ouput data on port receptor_file use
## self.outputData(receptor_file=data)
## to ouput data on port ligand_lib use
## self.outputData(ligand_lib=data)
## to ouput data on port filter_file use
## self.outputData(filter_file=data)






"""
    PrepareVinaInputs_24.configure(function=code)
    apply(PrepareVinaInputs_24.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
    GetMainURLFromList_25 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
    Vina_20.macroNetwork.addNode(GetMainURLFromList_25,217,248)
    apply(GetMainURLFromList_25.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network Vina ##
    Vina_20.macroNetwork.freeze()
    if PrepareVinaInputs_24 is not None and AutodockVina_Screening_kryptonite_nbcr_net_23 is not None:
        try:
            Vina_20.macroNetwork.connectNodes(
                PrepareVinaInputs_24, AutodockVina_Screening_kryptonite_nbcr_net_23, "receptor_file", "receptor", blocking=True
                , splitratio=[0.48630431331124768, 0.72717758735716731])
        except:
            print "WARNING: failed to restore connection between PrepareVinaInputs_24 and AutodockVina_Screening_kryptonite_nbcr_net_23 in network Vina_20.macroNetwork"
    if PrepareVinaInputs_24 is not None and AutodockVina_Screening_kryptonite_nbcr_net_23 is not None:
        try:
            Vina_20.macroNetwork.connectNodes(
                PrepareVinaInputs_24, AutodockVina_Screening_kryptonite_nbcr_net_23, "ligand_lib", "urllib", blocking=True
                , splitratio=[0.61963739449043087, 0.74955133389937689])
        except:
            print "WARNING: failed to restore connection between PrepareVinaInputs_24 and AutodockVina_Screening_kryptonite_nbcr_net_23 in network Vina_20.macroNetwork"
    if PrepareVinaInputs_24 is not None and AutodockVina_Screening_kryptonite_nbcr_net_23 is not None:
        try:
            Vina_20.macroNetwork.connectNodes(
                PrepareVinaInputs_24, AutodockVina_Screening_kryptonite_nbcr_net_23, "filter_file", "filter", blocking=True
                , splitratio=[0.32670226336274166, 0.25123642944789149])
        except:
            print "WARNING: failed to restore connection between PrepareVinaInputs_24 and AutodockVina_Screening_kryptonite_nbcr_net_23 in network Vina_20.macroNetwork"
    if AutodockVina_Screening_kryptonite_nbcr_net_23 is not None and GetMainURLFromList_25 is not None:
        try:
            Vina_20.macroNetwork.connectNodes(
                AutodockVina_Screening_kryptonite_nbcr_net_23, GetMainURLFromList_25, "result", "urls", blocking=True
                , splitratio=[0.23401196873379349, 0.68593608346615742])
        except:
            print "WARNING: failed to restore connection between AutodockVina_Screening_kryptonite_nbcr_net_23 and GetMainURLFromList_25 in network Vina_20.macroNetwork"
    output_Ports_22 = Vina_20.macroNetwork.opNode
    if GetMainURLFromList_25 is not None and output_Ports_22 is not None:
        try:
            Vina_20.macroNetwork.connectNodes(
                GetMainURLFromList_25, output_Ports_22, "newurl", "new", blocking=True
                , splitratio=[0.26588001265563421, 0.34355863787969732])
        except:
            print "WARNING: failed to restore connection between GetMainURLFromList_25 and output_Ports_22 in network Vina_20.macroNetwork"
    input_Ports_21 = Vina_20.macroNetwork.ipNode
    if input_Ports_21 is not None and PrepareVinaInputs_24 is not None:
        try:
            Vina_20.macroNetwork.connectNodes(
                input_Ports_21, PrepareVinaInputs_24, "new", "receptor_obj", blocking=True
                , splitratio=[0.59193136382656331, 0.41134942510734418])
        except:
            print "WARNING: failed to restore connection between input_Ports_21 and PrepareVinaInputs_24 in network Vina_20.macroNetwork"
    if input_Ports_21 is not None and PrepareVinaInputs_24 is not None:
        try:
            Vina_20.macroNetwork.connectNodes(
                input_Ports_21, PrepareVinaInputs_24, "new", "ligand_obj", blocking=True
                , splitratio=[0.29092159940560591, 0.60619808825531374])
        except:
            print "WARNING: failed to restore connection between input_Ports_21 and PrepareVinaInputs_24 in network Vina_20.macroNetwork"
    if input_Ports_21 is not None and AutodockVina_Screening_kryptonite_nbcr_net_23 is not None:
        try:
            Vina_20.macroNetwork.connectNodes(
                input_Ports_21, AutodockVina_Screening_kryptonite_nbcr_net_23, "new", "config", blocking=True
                , splitratio=[0.24239548372031838, 0.55842775396640953])
        except:
            print "WARNING: failed to restore connection between input_Ports_21 and AutodockVina_Screening_kryptonite_nbcr_net_23 in network Vina_20.macroNetwork"
    Vina_20.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_21.outputPorts[1].configure(name='PrepareVinaInputs_receptor_obj')
    input_Ports_21.outputPorts[2].configure(name='PrepareVinaInputs_ligand_obj')
    input_Ports_21.outputPorts[3].configure(name='AutodockVina_Screening_kryptonite_nbcr_net_config')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_22.inputPorts[1].configure(singleConnection='auto')
    output_Ports_22.inputPorts[1].configure(name='GetMainURLFromList_newurl')
    Vina_20.inputPorts[0].configure(name='PrepareVinaInputs_receptor_obj')
    Vina_20.inputPorts[0].configure(datatype='receptor_prepared')
    Vina_20.inputPorts[1].configure(name='PrepareVinaInputs_ligand_obj')
    Vina_20.inputPorts[1].configure(datatype='LigandDB')
    Vina_20.inputPorts[2].configure(name='AutodockVina_Screening_kryptonite_nbcr_net_config')
    Vina_20.inputPorts[2].configure(datatype='string')
    ## configure MacroNode input ports
    Vina_20.outputPorts[0].configure(name='GetMainURLFromList_newurl')
    Vina_20.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    Vina_20.shrink()
    apply(Vina_20.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named Vina in network masterNet"
    print_exc()
    Vina_20=None

try:
    ## saving node DownloadSaveDir ##
    from WebServices.VisionInterface.WSNodes import DownloadSaveDirNode
    DownloadSaveDir_26 = DownloadSaveDirNode(constrkw={}, name='DownloadSaveDir', library=wslib)
    masterNet.addNode(DownloadSaveDir_26,350,411)
    apply(DownloadSaveDir_26.inputPortByName['url'].configure, (), {'defaultValue': None})
    DownloadSaveDir_26.inputPortByName['url'].rebindWidget()
    DownloadSaveDir_26.inputPortByName['url'].widget.set(r"", run=False)
    DownloadSaveDir_26.inputPortByName['url'].unbindWidget()
    apply(DownloadSaveDir_26.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DownloadSaveDirNode named DownloadSaveDir in network masterNet"
    print_exc()
    DownloadSaveDir_26=None

try:
    ## saving node Output_Directory ##
    from Vision.StandardNodes import DirBrowserNE
    Output_Directory_27 = DirBrowserNE(constrkw={}, name='Output_Directory', library=stdlib)
    masterNet.addNode(Output_Directory_27,495,256)
    Output_Directory_27.inputPortByName['directory'].widget.set(r"VinaVSlocal_0.1_output", run=False)
    apply(Output_Directory_27.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Output_Directory in network masterNet"
    print_exc()
    Output_Directory_27=None

try:
    ## saving node LocalLigandDirectory ##
    from Adt.Input.LocalLigandDirectory import LocalLigandDirectory
    LocalLigandDirectory_28 = LocalLigandDirectory(constrkw={}, name='LocalLigandDirectory', library=Adt)
    masterNet.addNode(LocalLigandDirectory_28,446,177)
    apply(LocalLigandDirectory_28.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    Entry_32 = LocalLigandDirectory_28.macroNetwork.nodes[3]
    Entry_32.inputPortByName['entry'].widget.set(r"my_ligands.zip", run=False)
    LigandDBUpload_kryptonite_nbcr_net_33 = LocalLigandDirectory_28.macroNetwork.nodes[4]
    LigandDBUpload_kryptonite_nbcr_net_33.inputPortByName['username'].widget.set(r"", run=False)
    LigandDBUpload_kryptonite_nbcr_net_33.inputPortByName['password'].widget.set(r"", run=False)
    LigandDBUpload_kryptonite_nbcr_net_33.inputPortByName['localRun'].widget.set(0, run=False)
    LigandDBUpload_kryptonite_nbcr_net_33.inputPortByName['execPath'].widget.set(r"", run=False)
    LigandDBUpload_kryptonite_nbcr_net_33.inputPortByName['desc'].widget.set(r"", run=False)
    Index_34 = LocalLigandDirectory_28.macroNetwork.nodes[5]
    apply(Index_34.inputPortByName['index'].widget.configure, (), {'max': 7, 'min': -8})
    Index_34.inputPortByName['index'].widget.set(0, run=False)

    ## saving connections for network LocalLigandDirectory ##
    LocalLigandDirectory_28.macroNetwork.freeze()
    LocalLigandDirectory_28.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_29 = LocalLigandDirectory_28.macroNetwork.ipNode
    input_Ports_29.outputPorts[1].configure(name='Make_Zip_File_input_directory')
    input_Ports_29.outputPorts[2].configure(name='CreateLigandDBObj_log_file')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_30 = LocalLigandDirectory_28.macroNetwork.opNode
    output_Ports_30.inputPorts[1].configure(singleConnection='auto')
    output_Ports_30.inputPorts[2].configure(singleConnection='auto')
    output_Ports_30.inputPorts[1].configure(name='CreateLigandDBObj_ligand_db_obj')
    output_Ports_30.inputPorts[2].configure(name='ReplaceURL_newurl')
    LocalLigandDirectory_28.inputPorts[0].configure(name='Make_Zip_File_input_directory')
    LocalLigandDirectory_28.inputPorts[0].configure(datatype='string')
    LocalLigandDirectory_28.inputPorts[1].configure(name='CreateLigandDBObj_log_file')
    LocalLigandDirectory_28.inputPorts[1].configure(datatype='string')
    ## configure MacroNode input ports
    LocalLigandDirectory_28.outputPorts[0].configure(name='CreateLigandDBObj_ligand_db_obj')
    LocalLigandDirectory_28.outputPorts[0].configure(datatype='LigandDB')
    LocalLigandDirectory_28.outputPorts[1].configure(name='ReplaceURL_newurl')
    LocalLigandDirectory_28.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    LocalLigandDirectory_28.shrink()
    apply(LocalLigandDirectory_28.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore LocalLigandDirectory named LocalLigandDirectory in network masterNet"
    print_exc()
    LocalLigandDirectory_28=None

try:
    ## saving node Local Ligand Directory ##
    from Vision.StandardNodes import DirBrowserNE
    Local_Ligand_Directory_38 = DirBrowserNE(constrkw={}, name='Local Ligand Directory', library=stdlib)
    masterNet.addNode(Local_Ligand_Directory_38,446,40)
    Local_Ligand_Directory_38.inputPortByName['directory'].widget.set(r"VinaVSlocal_0.1_input/ligands", run=False)
    apply(Local_Ligand_Directory_38.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Local Ligand Directory in network masterNet"
    print_exc()
    Local_Ligand_Directory_38=None

#masterNet.run()
masterNet.freeze()

## saving connections for network VinaVSlocal-0.1 ##
if StructureBrowser_0 is not None and PrepareReceptor_2 is not None:
    try:
        masterNet.connectNodes(
            StructureBrowser_0, PrepareReceptor_2, "receptor_obj", "Pdb2pqrWS_CheckFileFormat_value", blocking=True
            , splitratio=[0.2411512852991527, 0.43763306853849476])
    except:
        print "WARNING: failed to restore connection between StructureBrowser_0 and PrepareReceptor_2 in network masterNet"
Vina_20 = masterNet.nodes[3]
if PrepareReceptor_2 is not None and Vina_20 is not None:
    try:
        masterNet.connectNodes(
            PrepareReceptor_2, Vina_20, "PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj", "PrepareVinaInputs_receptor_obj", blocking=True
            , splitratio=[0.7480148250853722, 0.53664021522471628])
    except:
        print "WARNING: failed to restore connection between PrepareReceptor_2 and Vina_20 in network masterNet"
if Vina_Config_File_Browser_1 is not None and Vina_20 is not None:
    try:
        masterNet.connectNodes(
            Vina_Config_File_Browser_1, Vina_20, "filename", "AutodockVina_Screening_kryptonite_nbcr_net_config", blocking=True
            , splitratio=[0.42914417254931403, 0.35140226817657205])
    except:
        print "WARNING: failed to restore connection between Vina_Config_File_Browser_1 and Vina_20 in network masterNet"
if Vina_20 is not None and DownloadSaveDir_26 is not None:
    try:
        masterNet.connectNodes(
            Vina_20, DownloadSaveDir_26, "GetMainURLFromList_newurl", "url", blocking=True
            , splitratio=[0.53439000181688434, 0.44697983643728223])
    except:
        print "WARNING: failed to restore connection between Vina_20 and DownloadSaveDir_26 in network masterNet"
if Output_Directory_27 is not None and DownloadSaveDir_26 is not None:
    try:
        masterNet.connectNodes(
            Output_Directory_27, DownloadSaveDir_26, "directory", "path", blocking=True
            , splitratio=[0.63352013077913427, 0.21502474638435864])
    except:
        print "WARNING: failed to restore connection between Output_Directory_27 and DownloadSaveDir_26 in network masterNet"
if LocalLigandDirectory_28 is not None and Vina_20 is not None:
    try:
        masterNet.connectNodes(
            LocalLigandDirectory_28, Vina_20, "CreateLigandDBObj_ligand_db_obj", "PrepareVinaInputs_ligand_obj", blocking=True
            , splitratio=[0.62666175669746282, 0.7294752449744224])
    except:
        print "WARNING: failed to restore connection between LocalLigandDirectory_28 and Vina_20 in network masterNet"
if Local_Ligand_Directory_38 is not None and LocalLigandDirectory_28 is not None:
    try:
        masterNet.connectNodes(
            Local_Ligand_Directory_38, LocalLigandDirectory_28, "directory", "Make_Zip_File_input_directory", blocking=True
            , splitratio=[0.51335208335408544, 0.32425737586098446])
    except:
        print "WARNING: failed to restore connection between Local_Ligand_Directory_38 and LocalLigandDirectory_28 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

