########################################################################
#
#    Vision Macro - Python source code - file generated by vision
#    Thursday 01 June 2006 15:52:40 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/python/packages/share1.5/AutoDockTools/VisionInterface/AD3Dpf.py,v 1.1 2006/06/05 22:45:41 rhuey Exp $
#
# $Id: AD3Dpf.py,v 1.1 2006/06/05 22:45:41 rhuey Exp $
#

from NetworkEditor.macros import MacroNode
class AD3Dpf(MacroNode):

    def __init__(self, constrkw={}, name='AD3Dpf', **kw):
        kw['name'] = name
        apply( MacroNode.__init__, (self,), kw)

    def beforeAddingToNetwork(self, net):
        MacroNode.beforeAddingToNetwork(self, net)
        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        net.editor.addLibraryInstance(adtlib,"AutoDockTools.VisionInterface.AdtNodes", "adtlib")

        from MolKit.VisionInterface.MolKitNodes import molkitlib
        net.editor.addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

        from Vision.StandardNodes import stdlib
        net.editor.addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")


    def afterAddingToNetwork(self):
        from NetworkEditor.macros import MacroNode
        MacroNode.afterAddingToNetwork(self)
        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        from MolKit.VisionInterface.MolKitNodes import molkitlib
        from Vision.StandardNodes import stdlib
        ## building macro network ##
        AD3Dpf_6 = self
        from traceback import print_exc

        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        self.macroNetwork.getEditor().addLibraryInstance(adtlib,"AutoDockTools.VisionInterface.AdtNodes", "adtlib")

        from MolKit.VisionInterface.MolKitNodes import molkitlib
        self.macroNetwork.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

        from Vision.StandardNodes import stdlib
        self.macroNetwork.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

        try:
            ## saving node input Ports ##
            input_Ports_7 = self.macroNetwork.ipNode
            input_Ports_7.move(158, 4)
        except:
            print "WARNING: failed to restore MacroInputNode named input Ports in network self.macroNetwork"
            print_exc()
            input_Ports_7=None

        try:
            ## saving node output Ports ##
            output_Ports_8 = self.macroNetwork.opNode
            output_Ports_8.move(172, 322)
        except:
            print "WARNING: failed to restore MacroOutputNode named output Ports in network self.macroNetwork"
            print_exc()
            output_Ports_8=None

        try:
            ## saving node Docking Parameter File Browser ##
            from AutoDockTools.VisionInterface.AdtNodes import DockingParameterFileBrowserNE
            Docking_Parameter_File_Browser_9 = DockingParameterFileBrowserNE(constrkw = {}, name='Docking Parameter File Browser', library=adtlib)
            self.macroNetwork.addNode(Docking_Parameter_File_Browser_9,204,93)
            apply(Docking_Parameter_File_Browser_9.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Docking_Parameter_File_Browser_9.outputPortByName['filename'].configure, (), {'color': 'white', 'shape': 'oval'})
            Docking_Parameter_File_Browser_9.inputPortByName['filename'].widget.set("/mgl/work4/rhuey/dev23/NEWTEST.dpf", run=False)
        except:
            print "WARNING: failed to restore DockingParameterFileBrowserNE named Docking Parameter File Browser in network self.macroNetwork"
            print_exc()
            Docking_Parameter_File_Browser_9=None

        try:
            ## saving node Prepare AD3Dpf ##
            from AutoDockTools.VisionInterface.AdtNodes import AdtPrepareDpf3
            Prepare_AD3Dpf_10 = AdtPrepareDpf3(constrkw = {}, name='Prepare AD3Dpf', library=adtlib)
            self.macroNetwork.addNode(Prepare_AD3Dpf_10,170,266)
            apply(Prepare_AD3Dpf_10.inputPortByName['ligand_filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Dpf_10.inputPortByName['receptor_filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Dpf_10.inputPortByName['dpf_filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Dpf_10.inputPortByName['parameters'].configure, (), {'color': 'cyan', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Dpf_10.inputPortByName['outputfilename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Dpf_10.outputPortByName['ad3_parameter_file'].configure, (), {'color': 'white', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore AdtPrepareDpf3 named Prepare AD3Dpf in network self.macroNetwork"
            print_exc()
            Prepare_AD3Dpf_10=None

        try:
            ## saving node Read Molecule ##
            from MolKit.VisionInterface.MolKitNodes import ReadMolecule
            Read_Molecule_11 = ReadMolecule(constrkw = {}, name='Read Molecule', library=molkitlib)
            self.macroNetwork.addNode(Read_Molecule_11,94,51)
            apply(Read_Molecule_11.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Read_Molecule_11.outputPortByName['MolSets'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore ReadMolecule named Read Molecule in network self.macroNetwork"
            print_exc()
            Read_Molecule_11=None

        try:
            ## saving node Read Molecule ##
            from MolKit.VisionInterface.MolKitNodes import ReadMolecule
            Read_Molecule_12 = ReadMolecule(constrkw = {}, name='Read Molecule', library=molkitlib)
            self.macroNetwork.addNode(Read_Molecule_12,187,47)
            apply(Read_Molecule_12.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Read_Molecule_12.outputPortByName['MolSets'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore ReadMolecule named Read Molecule in network self.macroNetwork"
            print_exc()
            Read_Molecule_12=None

        try:
            ## saving node File Browser ##
            from Vision.StandardNodes import FileBrowserNE
            File_Browser_13 = FileBrowserNE(constrkw = {}, name='File Browser', library=stdlib)
            self.macroNetwork.addNode(File_Browser_13,286,143)
            apply(File_Browser_13.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(File_Browser_13.outputPortByName['filename'].configure, (), {'color': 'white', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore FileBrowserNE named File Browser in network self.macroNetwork"
            print_exc()
            File_Browser_13=None

        self.macroNetwork.freeze()

        ## saving connections for network AD3Dpf ##
        if Docking_Parameter_File_Browser_9 is not None and Prepare_AD3Dpf_10 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Docking_Parameter_File_Browser_9, Prepare_AD3Dpf_10, "filename", "dpf_filename", blocking=True)
            except:
                print "WARNING: failed to restore connection between Docking_Parameter_File_Browser_9 and Prepare_AD3Dpf_10 in network self.macroNetwork"
        if Read_Molecule_11 is not None and Prepare_AD3Dpf_10 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Read_Molecule_11, Prepare_AD3Dpf_10, "MolSets", "ligand_filename", blocking=True)
            except:
                print "WARNING: failed to restore connection between Read_Molecule_11 and Prepare_AD3Dpf_10 in network self.macroNetwork"
        if Read_Molecule_12 is not None and Prepare_AD3Dpf_10 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Read_Molecule_12, Prepare_AD3Dpf_10, "MolSets", "receptor_filename", blocking=True)
            except:
                print "WARNING: failed to restore connection between Read_Molecule_12 and Prepare_AD3Dpf_10 in network self.macroNetwork"
        if File_Browser_13 is not None and Prepare_AD3Dpf_10 is not None:
            try:
                self.macroNetwork.connectNodes(
                    File_Browser_13, Prepare_AD3Dpf_10, "filename", "outputfilename", blocking=True)
            except:
                print "WARNING: failed to restore connection between File_Browser_13 and Prepare_AD3Dpf_10 in network self.macroNetwork"
        output_Ports_8 = self.macroNetwork.opNode
        if Prepare_AD3Dpf_10 is not None and output_Ports_8 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Prepare_AD3Dpf_10, output_Ports_8, "ad3_parameter_file", "new", blocking=True)
            except:
                print "WARNING: failed to restore connection between Prepare_AD3Dpf_10 and output_Ports_8 in network self.macroNetwork"
        self.macroNetwork.unfreeze()

        AD3Dpf_6.shrink()

        ## reset modifications ##
        AD3Dpf_6.resetTags()
        AD3Dpf_6.buildOriginalList()
