########################################################################
#
#    Vision Macro - Python source code - file generated by vision
#    Tuesday 25 July 2006 11:59:24 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/python/packages/share1.5/AutoDockTools/VisionInterface/recluster.py,v 1.1 2006/07/25 23:35:30 rhuey Exp $
#
# $Id: recluster.py,v 1.1 2006/07/25 23:35:30 rhuey Exp $
#

from NetworkEditor.macros import MacroNode
class recluster(MacroNode):

    def __init__(self, constrkw={}, name='recluster', **kw):
        kw['name'] = name
        apply( MacroNode.__init__, (self,), kw)

    def beforeAddingToNetwork(self, net):
        MacroNode.beforeAddingToNetwork(self, net)
        ## loading libraries ##
        from MolKit.VisionInterface.MolKitNodes import molkitlib
        net.editor.addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

        from Vision.StandardNodes import stdlib
        net.editor.addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")


    def afterAddingToNetwork(self):
        from NetworkEditor.macros import MacroNode
        MacroNode.afterAddingToNetwork(self)
        ## loading libraries ##
        from MolKit.VisionInterface.MolKitNodes import molkitlib
        from Vision.StandardNodes import stdlib
        ## building macro network ##
        recluster_11 = self
        from traceback import print_exc

        ## loading libraries ##
        from MolKit.VisionInterface.MolKitNodes import molkitlib
        self.macroNetwork.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

        from Vision.StandardNodes import stdlib
        self.macroNetwork.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

        try:
            ## saving node input Ports ##
            input_Ports_12 = self.macroNetwork.ipNode
            input_Ports_12.move(172, 137)
        except:
            print "WARNING: failed to restore MacroInputNode named input Ports in network self.macroNetwork"
            print_exc()
            input_Ports_12=None

        try:
            ## saving node output Ports ##
            output_Ports_13 = self.macroNetwork.opNode
            output_Ports_13.move(172, 479)
        except:
            print "WARNING: failed to restore MacroOutputNode named output Ports in network self.macroNetwork"
            print_exc()
            output_Ports_13=None

        try:
            ## saving node Docking ##
            from Vision.StandardNodes import Generic
            Docking_16 = Generic(constrkw = {}, name='Docking', library=stdlib)
            self.macroNetwork.addNode(Docking_16,189,250)
            apply(Docking_16.addInputPort, (), {'name': 'docking_logs', 'cast': True, 'datatype': 'list', 'balloon': 'list of docking log files to be read into as a single Docking', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
            apply(Docking_16.addInputPort, (), {'name': 'rmsTool', 'cast': True, 'datatype': 'None', 'balloon': 'rmsTool to be used for clustering', 'required': False, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
            apply(Docking_16.addOutputPort, (), {'name': 'docking', 'datatype': 'None', 'balloon': 'docking instance', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
            code = """def doit(self, docking_logs, rmsTool):
        from AutoDockTools.Docking import Docking
        d = Docking()
        for f in docking_logs:
                d.readDlg(f)
        d.clusterer.rmsTool = rmsTool
        self.outputData(docking = d)           
                    
        
## to ouput data on port docking use
## self.outputData(docking=data)


"""
            Docking_16.configure(function=code)
        except:
            print "WARNING: failed to restore Generic named Docking in network self.macroNetwork"
            print_exc()
            Docking_16=None

        try:
            ## saving node rmsTool ##
            from Vision.StandardNodes import Generic
            rmsTool_17 = Generic(constrkw = {}, name='rmsTool', library=stdlib)
            self.macroNetwork.addNode(rmsTool_17,206,197)
            apply(rmsTool_17.addInputPort, (), {'name': 'crds', 'cast': True, 'datatype': 'coordinates3D', 'balloon': 'coordinates to use as reference for rms calculation.', 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'green'})
            apply(rmsTool_17.addOutputPort, (), {'name': 'rmsTool', 'datatype': 'None', 'balloon': 'rmsTool created using crds as reference', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
            code = """def doit(self, crds):
	from  mglutil.math.rmsd  import RMSDCalculator
	rmsTool = RMSDCalculator(crds)
	self.outputData(rmsTool = rmsTool)
	
"""
            rmsTool_17.configure(function=code)
        except:
            print "WARNING: failed to restore Generic named rmsTool in network self.macroNetwork"
            print_exc()
            rmsTool_17=None

        try:
            ## saving node Read Molecule ##
            from MolKit.VisionInterface.MolKitNodes import ReadMolecule
            Read_Molecule_18 = ReadMolecule(constrkw = {}, name='Read Molecule', library=molkitlib)
            self.macroNetwork.addNode(Read_Molecule_18,243,16)
            apply(Read_Molecule_18.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Read_Molecule_18.outputPortByName['MolSets'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
            Read_Molecule_18.inputPortByName['filename'].widget.set("ind.pdbqt", run=False)
        except:
            print "WARNING: failed to restore ReadMolecule named Read Molecule in network self.macroNetwork"
            print_exc()
            Read_Molecule_18=None

        try:
            ## saving node Index ##
            from Vision.StandardNodes import Index
            Index_19 = Index(constrkw = {}, name='Index', library=stdlib)
            self.macroNetwork.addNode(Index_19,243,66)
            apply(Index_19.inputPortByName['data'].configure, (), {'datatype': 'MoleculeSet', 'cast': True, 'shape': 'oval', 'color': '#c64e70'})
            apply(Index_19.inputPortByName['index'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(Index_19.outputPortByName['data'].configure, (), {'color': 'white', 'shape': 'diamond'})
        except:
            print "WARNING: failed to restore Index named Index in network self.macroNetwork"
            print_exc()
            Index_19=None

        try:
            ## saving node Get allAtoms.coords ##
            from Vision.StandardNodes import GetAttr
            Get_allAtoms_coords_20 = GetAttr(constrkw = {}, name='Get allAtoms.coords', library=stdlib)
            self.macroNetwork.addNode(Get_allAtoms_coords_20,243,115)
            apply(Get_allAtoms_coords_20.inputPortByName['objects'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(Get_allAtoms_coords_20.inputPortByName['attr'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Get_allAtoms_coords_20.outputPortByName['attrs'].configure, (), {'color': 'cyan', 'shape': 'oval'})
            apply(Get_allAtoms_coords_20.inputPortByName['attr'].widget.configure, (), {'choices': ('AAradii', 'AtomRadiiPatterns', 'NodesFromName', 'ROOT', 'TORSDOF', '_MarkTree', '__cmp__', '__doc__', '__eq__', '__hash__', '__init__', '__module__', '__ne__', '__repr__', '__str__', '_atomRadius', '_copyNode', '_copy_atom_attr', '_fit_atom_into_tree', '_numberOfDeletedNodes', 'addBond', 'adopt', 'allAtoms', 'assignUniqIndex', 'atmNum', 'attach_nonbonded_fragments', 'bonds', 'bondsflag', 'buildBondsBhtree', 'buildBondsByDistance', 'buildBondsByDistanceOnAtoms', 'buildBrokenBonds', 'chains', 'childByName', 'children', 'childrenName', 'childrenSetClass', 'closerThan', 'compare', 'compiled_patterns', 'configureProgressBar', 'copy', 'defaultRadii', 'deleteSubTree', 'dump', 'elementType', 'findLevels', 'findType', 'full_name', 'get', 'getAtoms', 'getCenter', 'getNext', 'getParentOfType', 'getPrevious', 'getRoot', 'getTypeList', 'hasBonds', 'hasSS', 'isAbove', 'isBelow', 'levels', 'makeNameUniq', 'merge', 'mergeNPH', 'name', 'ndihe', 'p', 'parent', 'parser', 'read', 'remove', 'removeAllHydrogens', 'removeBond', 'secondaryStructure', 'secondaryStructureFromFile', 'secondaryStructureFromStride', 'setClass', 'split', 'subTree', 'top', 'torTree', 'updateProgressBar', 'write')})
            Get_allAtoms_coords_20.inputPortByName['attr'].widget.set("allAtoms.coords", run=False)
            apply(Get_allAtoms_coords_20.configure, (), {'expanded': True})
        except:
            print "WARNING: failed to restore GetAttr named Get allAtoms.coords in network self.macroNetwork"
            print_exc()
            Get_allAtoms_coords_20=None

        try:
            ## saving node Get clusterer ##
            from Vision.StandardNodes import GetAttr
            Get_clusterer_21 = GetAttr(constrkw = {}, name='Get clusterer', library=stdlib)
            self.macroNetwork.addNode(Get_clusterer_21,189,306)
            apply(Get_clusterer_21.inputPortByName['objects'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(Get_clusterer_21.inputPortByName['attr'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Get_clusterer_21.outputPortByName['attrs'].configure, (), {'color': 'cyan', 'shape': 'oval'})
            apply(Get_clusterer_21.inputPortByName['attr'].widget.configure, (), {'choices': ('__doc__', '__init__', '__module__', 'addConformations', 'ch', 'clusterer', 'clusterer_dict', 'defaultParser', 'dlo_list', 'flex_res', 'ligMol', 'parser', 'readDlg', 'readEntropiaResults', 'readXMLResults', 'set_ligand', 'version', 'warnings', 'writeConformation', 'write_current_conformation')})
            Get_clusterer_21.inputPortByName['attr'].widget.set("clusterer", run=False)
            apply(Get_clusterer_21.configure, (), {'expanded': True})
        except:
            print "WARNING: failed to restore GetAttr named Get clusterer in network self.macroNetwork"
            print_exc()
            Get_clusterer_21=None

        try:
            ## saving node Index ##
            from Vision.StandardNodes import Index
            Index_22 = Index(constrkw = {}, name='Index', library=stdlib)
            self.macroNetwork.addNode(Index_22,188,383)
            apply(Index_22.inputPortByName['data'].configure, (), {'datatype': 'list', 'cast': True, 'shape': 'oval', 'color': 'cyan'})
            apply(Index_22.inputPortByName['index'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(Index_22.outputPortByName['data'].configure, (), {'color': 'white', 'shape': 'diamond'})
        except:
            print "WARNING: failed to restore Index named Index in network self.macroNetwork"
            print_exc()
            Index_22=None

        try:
            ## saving node make clustering ##
            from Vision.StandardNodes import Generic
            make_clustering_23 = Generic(constrkw = {}, name='make clustering', library=stdlib)
            self.macroNetwork.addNode(make_clustering_23,189,432)
            apply(make_clustering_23.addInputPort, (), {'name': 'clusterer', 'cast': True, 'datatype': 'None', 'balloon': 'clusterer which will make the new clustering', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
            apply(make_clustering_23.addInputPort, (), {'name': 'tolerance', 'cast': True, 'datatype': 'float', 'balloon': 'rms tolerance for the new clustering', 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
            apply(make_clustering_23.addOutputPort, (), {'name': 'clustering', 'datatype': 'None', 'balloon': 'clustering at newest rms', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
            code = """def doit(self, clusterer, tolerance):
	clusterer.make_clustering(tolerance)
	self.outputData(clustering = clusterer.clustering_dict[tolerance])
"""
            make_clustering_23.configure(function=code)
        except:
            print "WARNING: failed to restore Generic named make clustering in network self.macroNetwork"
            print_exc()
            make_clustering_23=None

        try:
            ## saving node Dial ##
            from Vision.StandardNodes import DialNE
            Dial_24 = DialNE(constrkw = {}, name='Dial', library=stdlib)
            self.macroNetwork.addNode(Dial_24,233,380)
            apply(Dial_24.inputPortByName['dial'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Dial_24.inputPortByName['mini'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Dial_24.inputPortByName['maxi'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Dial_24.outputPortByName['value'].configure, (), {'color': 'green', 'shape': 'circle'})
            Dial_24.inputPortByName['dial'].widget.set(3.0, run=False)
            apply(Dial_24.configure, (), {'expanded': False})
        except:
            print "WARNING: failed to restore DialNE named Dial in network self.macroNetwork"
            print_exc()
            Dial_24=None

        self.macroNetwork.freeze()

        ## saving connections for network recluster ##
        if rmsTool_17 is not None and Docking_16 is not None:
            try:
                self.macroNetwork.connectNodes(
                    rmsTool_17, Docking_16, "rmsTool", "rmsTool", blocking=True)
            except:
                print "WARNING: failed to restore connection between rmsTool_17 and Docking_16 in network self.macroNetwork"
        if Read_Molecule_18 is not None and Index_19 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Read_Molecule_18, Index_19, "MolSets", "data", blocking=True)
            except:
                print "WARNING: failed to restore connection between Read_Molecule_18 and Index_19 in network self.macroNetwork"
        if Index_19 is not None and Get_allAtoms_coords_20 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Index_19, Get_allAtoms_coords_20, "data", "objects", blocking=True)
            except:
                print "WARNING: failed to restore connection between Index_19 and Get_allAtoms_coords_20 in network self.macroNetwork"
        if Get_allAtoms_coords_20 is not None and rmsTool_17 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Get_allAtoms_coords_20, rmsTool_17, "attrs", "crds", blocking=True)
            except:
                print "WARNING: failed to restore connection between Get_allAtoms_coords_20 and rmsTool_17 in network self.macroNetwork"
        if Docking_16 is not None and Get_clusterer_21 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Docking_16, Get_clusterer_21, "docking", "objects", blocking=True)
            except:
                print "WARNING: failed to restore connection between Docking_16 and Get_clusterer_21 in network self.macroNetwork"
        if Get_clusterer_21 is not None and Index_22 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Get_clusterer_21, Index_22, "attrs", "data", blocking=True)
            except:
                print "WARNING: failed to restore connection between Get_clusterer_21 and Index_22 in network self.macroNetwork"
        if Index_22 is not None and make_clustering_23 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Index_22, make_clustering_23, "data", "clusterer", blocking=True)
            except:
                print "WARNING: failed to restore connection between Index_22 and make_clustering_23 in network self.macroNetwork"
        if Dial_24 is not None and make_clustering_23 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Dial_24, make_clustering_23, "value", "tolerance", blocking=True)
            except:
                print "WARNING: failed to restore connection between Dial_24 and make_clustering_23 in network self.macroNetwork"
        output_Ports_13 = self.macroNetwork.opNode
        if make_clustering_23 is not None and output_Ports_13 is not None:
            try:
                self.macroNetwork.connectNodes(
                    make_clustering_23, output_Ports_13, "clustering", "new", blocking=True)
            except:
                print "WARNING: failed to restore connection between make_clustering_23 and output_Ports_13 in network self.macroNetwork"
        input_Ports_12 = self.macroNetwork.ipNode
        if input_Ports_12 is not None and Docking_16 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_12, Docking_16, "new", "docking_logs", blocking=True)
            except:
                print "WARNING: failed to restore connection between input_Ports_12 and Docking_16 in network self.macroNetwork"
        self.macroNetwork.unfreeze()

        recluster_11.shrink()

        ## reset modifications ##
        recluster_11.resetTags()
        recluster_11.buildOriginalList()
