#############################################################################
#
# Author: Ruth HUEY, Michel F. SANNER
#
# Copyright: M. Sanner TSRI 2000
#
#############################################################################

# $Header: /mnt/raid/services/cvs/python/packages/share1.5/AutoDockTools/autogpf3Commands.py,v 1.1 2008/06/02 23:55:17 rhuey Exp $
#
# $Id: autogpf3Commands.py,v 1.1 2008/06/02 23:55:17 rhuey Exp $
#
#
#
#
#

"""
This Module facilitates producing a grid parameter file for AutoGrid. The steps in this process are:

    * 'Macromolecule': Selecting the macromolecule: 
        The user can select the macromolecule for autogpf in two ways: 
           - it can be chosen from molecules previously added to the moleculeViewer  
           - it can be read in from a file:

        o Choose Macromol...

        o Read Macromolecule 


    * 'Set Map Types': Setting the types of maps to generate: 

        o Set Map Types Directly

        o By Choosing Ligand

        o By Reading Formatted File

The user can change the types of maps to be calculated.
He decides which types of possible hydrogen bonding he wishes to model. 
For instance, IF hydrogens are present  AND nitrogens, oxygens and /or sulfurs, 
the user can decide to model N-H bonds, O-H bonds and/or S-H bonds.  
He sets which type of dielectric to use:
    -distance-dependent dielectric  
    -constant dielectric  
(Other ligand-related commands allow the user to set energy parameters for new 
atom types or to set up a specialized 'covalent' grid-map.)


    * 'Set Grid': The user positions the grid and sets its dimensions by:

        o Setting the center of the grid maps: 

            - by picking an atom or

            - by entering the full-name of an atom or 

            - by entering the desired coordinates in entries 'x center', 'y center', 
'z center' (NB: ALL entries must be 'activated' by a 'Return')

            - by choosing  the 'Center on Macromolecule' option which sets the 
center of the grid to the geometric center of the macromolecule (obtained by 
averaging all its coordinates)

            - by choosing  the 'Center on Ligand' option which sets the center of 
the grid to the geometric center of the ligand (obtained by averaging all its 
coordinates)

        o Setting the number of grid points in each direction (which has to be an 
even number) and the spacing between the points. This is done by using the 
corresponding scale widgets.

        o Adjusting the position of the grid using scales for x-offset, y-offset 
and z-offset.  These scales allow the user to move the grid box up to 10 angstroms 
in any direction along any of the three axes. 
(NOTE that the units of these scales are tenths of Angstroms and the new coordinates 
of the center are reflected in the x-center, y-center, z-center entries)

    * 'Set Other Options': The user adjusts these additional parameters: 
    
        o the smoothing factor can be changed from its default 0.5Angstrom value.  
This changes the radius of the area within which the minimum energy is stored.
        o  electrostatic potential map may or may not be generated by AutoGrid

        o floating point potential map may or may not be generated 

        o the user may decide whether or not to use the default distance dependent 
dielectric constant.  If not, he can enter his desired dielectric constant or use 
the default value, 40. It should be noted that this entered value is multiplied 
by 0.1146 by the program for input to AutoGrid.

    * 'Write GPF': The results of the previous steps are written to a file. 
The user selects a filename via a filebrowser.  By convention, the file should 
have a .gpf extension. If no macromolecule has been selected, it is not possible 
to write a grid parameter file and the user gets a warning message to that effect. 
Likewise, the types of the maps to be calculated must be set before the grid 
parameter file is written and a warning message to this effect appears if the 
types have not been set.

    * 'Edit GPF': Allows user to edit a grid parameter file.  If one has been
written, it is automatically loaded. Otherwise, the user can select any *.gpf
file to edit from a file browser.
    
"""
from ViewerFramework.VFCommand import CommandGUI

from AutoDockTools.autogpfCommands import GpfSetGpo,\
GpfLoadDefaults, GpfMacroInit, CheckMacroAtomTypes,\
GpfMacroReader, GpfMacroChooser, GpfAddSol, GpfInitLigand,\
GpfLigandChooser, GpfLigReader, GpfEditor, GpfWriter,\
SelectCenter, SetMapTypes, SetUpCovalentMap,\
DefineNewAtomParms, SetBoxParameters, SetOtherOptions,\
GpfMergeNonPolarHs, menuText, gridOpts,\
messages, checkHasGpo, box, cenSph, cenCross, autodockElementDict,\
setAutoDockElements, getSideLengths, checkFile

GpfLoadDefaultsGUI = CommandGUI()
GpfLoadDefaultsGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'],\
menuText['ReadGpfMB'])


GpfMacroReaderGUI = CommandGUI()
GpfMacroReaderGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'],\
    menuText['ReadMacro'], cascadeName = menuText['MacromoleculeMB'])


GpfMacroChooserGUI = CommandGUI()
GpfMacroChooserGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'], menuText['ChooseMacro'], cascadeName = menuText['MacromoleculeMB'])


GpfAddSolGUI= CommandGUI()
GpfAddSolGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'], menuText['AddSol'], cascadeName = menuText['MacromoleculeMB'])


GpfLigandChooserGUI= CommandGUI()
GpfLigandChooserGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'],\
    menuText['ByChoosingLigand'], cascadeName = menuText['SetMapTypesMB'])


GpfLigReaderGUI= CommandGUI()
GpfLigReaderGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'], \
    menuText['ByReadingFile'], cascadeName = menuText['SetMapTypesMB'])


GpfEditorGUI= CommandGUI()
GpfEditorGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'],\
        menuText['EditGpfMB'])


GpfWriterGUI= CommandGUI()
GpfWriterGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'], \
    menuText['WriteGpfMB'], cascadeName=menuText['WriteMB'])


SetMapTypesGUI= CommandGUI()
SetMapTypesGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'],\
    menuText['SetMapDirectly'], cascadeName = menuText['SetMapTypesMB'])


SetUpCovalentMapGUI = CommandGUI()
SetUpCovalentMapGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'], \
    menuText['SetUpCovalentMap'], cascadeName = menuText['SetMapTypesMB'])


DefineNewAtomParmsGUI= CommandGUI()
DefineNewAtomParmsGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'],\
    menuText['SetNewTypeParms'], cascadeName = menuText['SetMapTypesMB'])


SetBoxParametersGUI= CommandGUI()
SetBoxParametersGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'], \
    menuText['SetGridMB'])



SetOtherOptionsGUI= CommandGUI()
SetOtherOptionsGUI.addMenuCommand('AutoTools3Bar', menuText['AutoGpfMB'], \
    menuText['SetOtherOptionsMB_AG3'], cascadeName = menuText['SetOtherOptionsMB'])


commandList = [
    {'name':'AD3gpf_readGPF','cmd':GpfLoadDefaults(),'gui':GpfLoadDefaultsGUI},
    #set grid
    {'name':'AD3gpf_setGrid','cmd':SetBoxParameters(),'gui':SetBoxParametersGUI},
    #AutoGrid3
    {'name':'AD3gpf_readMacromolecule','cmd':GpfMacroReader(),'gui':GpfMacroReaderGUI},
    {'name':'AD3gpf_chooseMacromolecule','cmd':GpfMacroChooser(),'gui':GpfMacroChooserGUI},
    {'name':'ADgpf_addSolvationParameters','cmd':GpfAddSol(),'gui':GpfAddSolGUI},
    {'name':'AD3gpf_setMapTypes','cmd':SetMapTypes(),'gui':SetMapTypesGUI},
    {'name':'AD3gpf_chooseFormattedLigand','cmd':GpfLigandChooser(),'gui':GpfLigandChooserGUI},
    {'name':'AD3gpf_readFormattedLigand','cmd':GpfLigReader(),'gui':GpfLigReaderGUI},
    {'name':'AD3gpf_defineAtomParameters','cmd':DefineNewAtomParms(),'gui':DefineNewAtomParmsGUI},
    {'name':'AD3gpf_setUpCovalentMap','cmd':SetUpCovalentMap(),'gui':SetUpCovalentMapGUI},
    {'name':'AD3gpf_setOtherOptions','cmd':SetOtherOptions(),'gui':SetOtherOptionsGUI},
    {'name':'AD3gpf_writeGPF','cmd':GpfWriter(),'gui':GpfWriterGUI},
    {'name':'AD3gpf_editGPF','cmd':GpfEditor(),'gui':GpfEditorGUI},
    ]


def initModule(vf):

    for dict in commandList:
        vf.addCommand(dict['cmd'],dict['name'],dict['gui'])
    #add commands with no gui:
    if not hasattr(vf, 'ADgpf_initLigand'):
        vf.addCommand(GpfInitLigand(),'ADgpf_initLigand',None)
    if not hasattr(vf, 'ADgpf_initMacro'):
        vf.addCommand(GpfMacroInit(),'ADgpf_initMacro',None)
    if not hasattr(vf, 'ADgpf_checkMacroTypes'):
        vf.addCommand(CheckMacroAtomTypes(),'ADgpf_checkMacroTypes',None)
    if not hasattr(vf, 'ADgpf_setGpo'):
        vf.addCommand(GpfSetGpo(),'ADgpf_setGpo',None)
    if not hasattr(vf, 'ADgpf_selectCenter'):
        vf.addCommand(SelectCenter(),'ADgpf_selectCenter',None)
    if not hasattr(vf, 'ADgpf_mergeNonPolarHydrogens'):
        vf.addCommand(GpfMergeNonPolarHs(),'ADgpf_mergeNonPolarHydrogens',None)



    if hasattr(vf, 'GUI'):
        for item in vf.GUI.menuBars['AutoTools3Bar'].menubuttons.values():
            item.configure(background = 'tan')
            item.configure(underline = '-1')
        if not hasattr(vf.GUI, 'adtBar'):
            vf.GUI.adtBar = vf.GUI.menuBars['AutoTools3Bar']
            vf.GUI.adtFrame = vf.GUI.adtBar.menubuttons.values()[0].master
        

    #{'name':'ADgpf_initMacro','cmd':GpfMacroInit(),'gui':None},


