#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 23 February 2011 18:17:33 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/CADD/workflows/MDanalysis/NAMDNBCR_0.1_net.py,v 1.1 2011/04/15 16:03:51 nadya Exp $
#
# $Id: NAMDNBCR_0.1_net.py,v 1.1 2011/04/15 16:03:51 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://oolite.calit2.optiputer.net/opal2", replace=False)
except:
    pass
try:
    ## saving node FileWithCommandOrdering ##
    from Vision.StandardNodes import FileBrowserNE
    FileWithCommandOrdering_87 = FileBrowserNE(constrkw={}, name='FileWithCommandOrdering', library=stdlib)
    masterNet.addNode(FileWithCommandOrdering_87,30,10)
    FileWithCommandOrdering_87.inputPortByName['filename'].widget.set(r"NAMDNBCR_0.1_input/order.txt", run=False)
    apply(FileWithCommandOrdering_87.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named FileWithCommandOrdering in network masterNet"
    print_exc()
    FileWithCommandOrdering_87=None

try:
    ## saving node GetOrdering ##
    from Vision.StandardNodes import Generic
    GetOrdering_88 = Generic(constrkw={}, name='GetOrdering', library=stdlib)
    masterNet.addNode(GetOrdering_88,30,107)
    apply(GetOrdering_88.addInputPort, (), {'singleConnection': True, 'name': 'order_file', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetOrdering_88.addOutputPort, (), {'name': 'order_list', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    code = """def doit(self, order_file):
        olist = []
        f = open(order_file, "r")

        while 1:
            line = f.readline()
            if not line: break
            line = line.strip()

            if line != "":
                olist.append(line)

        f.close()

        c = 0
        print "The following ordering will be used"
        for i in olist:
            c = c + 1
            print str(c) + ". " + i + " "
        
	pass
## to ouput data on port order_list use
        self.outputData(order_list=olist)







"""
    GetOrdering_88.configure(function=code)
    apply(GetOrdering_88.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named GetOrdering in network masterNet"
    print_exc()
    GetOrdering_88=None

try:
    ## saving node Input Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Input_Directory_Browser_89 = DirBrowserNE(constrkw={}, name='Input Directory Browser', library=stdlib)
    masterNet.addNode(Input_Directory_Browser_89,375,8)
    Input_Directory_Browser_89.inputPortByName['directory'].widget.set(r"NAMDNBCR_0.1_input", run=False)
    apply(Input_Directory_Browser_89.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Input Directory Browser in network masterNet"
    print_exc()
    Input_Directory_Browser_89=None

try:
    ## saving node NumProcessors ##
    from Vision.StandardNodes import EntryNE
    NumProcessors_90 = EntryNE(constrkw={}, name='NumProcessors', library=stdlib)
    masterNet.addNode(NumProcessors_90,1043,12)
    NumProcessors_90.inputPortByName['entry'].widget.set(r"32", run=False)
    code = """def doit(self, entry):
    if len(str(entry))!=0:
        self.outputData(string=entry)

"""
    NumProcessors_90.configure(function=code)
    apply(NumProcessors_90.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore EntryNE named NumProcessors in network masterNet"
    print_exc()
    NumProcessors_90=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_91 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_91,30,169)
    iterate_91.inputPortByName['stopOnFailure'].widget.set(1, run=False)
    apply(iterate_91.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_91=None

try:
    ## saving node SaveNAMDResults ##
    from NetworkEditor.macros import MacroNode
    SaveNAMDResults_92 = MacroNode(name='SaveNAMDResults')
    masterNet.addNode(SaveNAMDResults_92, 455, 366)
    output_Ports_94 = SaveNAMDResults_92.macroNetwork.opNode
    apply(output_Ports_94.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_94.move(130, 477)
    from Vision.StandardNodes import Generic
    GetOutURLs_95 = Generic(constrkw={}, name='GetOutURLs', library=stdlib)
    SaveNAMDResults_92.macroNetwork.addNode(GetOutURLs_95,118,98)
    apply(GetOutURLs_95.addInputPort, (), {'singleConnection': True, 'name': 'filename', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetOutURLs_95.addInputPort, (), {'singleConnection': True, 'name': 'url', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetOutURLs_95.addOutputPort, (), {'name': 'outfile_list', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    apply(GetOutURLs_95.addOutputPort, (), {'name': 'run_name', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, filename, url):
        import urllib
        ofilelist = []
        ofw = []

        # Find outname string
        f = open(filename, "r")

        outname = ""
        restartname = None
        
        for line in f.readlines():
            
            line = line.strip('''
''')

            if line.find("set outname") >= 0 and (not (line.startswith('''#'''))) and outname == "":
                #outname = line.strip("set outname")
                outname = line.split("set outname")[1]
                outname = outname.lstrip("	")
                outname = outname.lstrip(" ")
            elif line.find("outputname") >= 0 and (not (line.startswith('''#'''))) and outname == "":
                #outname = line.strip("outputname")
                outname = line.split("outputname")[1]
                outname = outname.lstrip("	")
                outname = outname.lstrip(" ")

            if line.find("restartname") >= 0 and (not (line.startswith('''#'''))):
                #restartname = line.strip("restartname")
                restartname = line.split("restartname")[1]
                restartname = restartname.lstrip("	")
                restartname = restartname.lstrip(" ")            
                
        f.close()

        if (outname == None):
            print "ERROR: Please set outputname in your NAMD conf file"
            return '''stop'''

        opener = urllib.FancyURLopener({})
        f = opener.open(url)

        for line in f.readlines():
            if (line.startswith("<a href=")):
                poss = line.find("<tt>") + 4;
                pose = line.find("</tt>")
                line = line[poss:pose]
                if line.startswith(outname+'''.'''):
                    ofw.append(line)
                if restartname != None and line.startswith(restartname+'''.'''):
                    ofw.append(line)
    
        f.close()

        extc = [".vel", ".xsc", ".xst", ".coor"]

        for i in extc:
            n = outname + i
            ofw.append(n)

        ofw.append("stdout.txt")

        for i in ofw:
            ofilelist.append(url + i)    

        run_name = os.path.basename(filename)
        
	pass
## to ouput data on port outfile_list use
        self.outputData(outfile_list=ofilelist, run_name=run_name)








































"""
    GetOutURLs_95.configure(function=code)
    apply(GetOutURLs_95.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Iterate
    iterate_96 = Iterate(constrkw={}, name='iterate', library=stdlib)
    SaveNAMDResults_92.macroNetwork.addNode(iterate_96,43,152)
    iterate_96.inputPortByName['stopOnFailure'].widget.set(1, run=False)
    apply(iterate_96.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import DownloadNode
    Download_97 = DownloadNode(constrkw={}, name='Download', library=wslib)
    SaveNAMDResults_92.macroNetwork.addNode(Download_97,118,221)
    apply(Download_97.inputPortByName['url'].configure, (), {'defaultValue': None})
    Download_97.inputPortByName['url'].rebindWidget()
    Download_97.inputPortByName['url'].widget.set(r"", run=False)
    Download_97.inputPortByName['url'].unbindWidget()
    code = """def doit(self, url):
    if checkURL(url):
        opener = urllib.FancyURLopener({})
        in_file = opener.open(url)
        self.outputData(output=in_file.read())
    else:
        print "ERROR: expect output " + url + " missing"
        self.editor.stopCurrentNet_cb()








"""
    Download_97.configure(function=code)
    apply(Download_97.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import SaveLines
    Save_Lines_98 = SaveLines(constrkw={}, name='Save Lines', library=stdlib)
    SaveNAMDResults_92.macroNetwork.addNode(Save_Lines_98,217,281)
    apply(Save_Lines_98.inputPortByName['filename'].configure, (), {'defaultValue': None})
    Save_Lines_98.inputPortByName['filename'].rebindWidget()
    Save_Lines_98.inputPortByName['filename'].widget.set(r"", run=False)
    Save_Lines_98.inputPortByName['filename'].unbindWidget()
    apply(Save_Lines_98.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    dirname_99 = Eval(constrkw={}, name='dirname', library=stdlib)
    SaveNAMDResults_92.macroNetwork.addNode(dirname_99,234,220)
    apply(dirname_99.addInputPort, (), {'singleConnection': True, 'name': 'in2', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    dirname_99.inputPortByName['command'].widget.set(r"os.path.dirname(in1)+os.sep+os.path.basename(in2)", run=False)
    dirname_99.inputPortByName['importString'].widget.set(r"", run=False)
    apply(dirname_99.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    rename_stdout_100 = Generic(constrkw={}, name='rename_stdout', library=stdlib)
    SaveNAMDResults_92.macroNetwork.addNode(rename_stdout_100,118,431)
    apply(rename_stdout_100.addInputPort, (), {'singleConnection': True, 'name': 'in_name', 'cast': True, 'datatype': 'None', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(rename_stdout_100.addInputPort, (), {'singleConnection': True, 'name': 'run_name', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(rename_stdout_100.addOutputPort, (), {'name': 'out_name', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, in_name, run_name):
        file_basename = os.path.basename(in_name)
        file_basedir = os.path.dirname(in_name)
        out_name = file_basedir + os.sep + file_basename + '''.''' + run_name

        os.rename(in_name, out_name)
        
	pass
## to ouput data on port out_name use
        self.outputData(out_name=out_name)



"""
    rename_stdout_100.configure(function=code)
    apply(rename_stdout_100.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import IfNode
    if_101 = IfNode(constrkw={}, name='if', library=stdlib)
    SaveNAMDResults_92.macroNetwork.addNode(if_101,217,338)
    if_101.inputPortByName['condition'].widget.set(r"os.path.basename(value) == 'stdout.txt'", run=False)
    apply(if_101.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network SaveNAMDResults ##
    SaveNAMDResults_92.macroNetwork.freeze()
    input_Ports_93 = SaveNAMDResults_92.macroNetwork.ipNode
    if input_Ports_93 is not None and GetOutURLs_95 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                input_Ports_93, GetOutURLs_95, "new", "url", blocking=True
                , splitratio=[0.6832953128822854, 0.33142188038532305])
        except:
            print "WARNING: failed to restore connection between input_Ports_93 and GetOutURLs_95 in network SaveNAMDResults_92.macroNetwork"
    if input_Ports_93 is not None and GetOutURLs_95 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                input_Ports_93, GetOutURLs_95, "new", "filename", blocking=True
                , splitratio=[1.0, 0.74456555351349663])
        except:
            print "WARNING: failed to restore connection between input_Ports_93 and GetOutURLs_95 in network SaveNAMDResults_92.macroNetwork"
    if GetOutURLs_95 is not None and iterate_96 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                GetOutURLs_95, iterate_96, "outfile_list", "listToLoopOver", blocking=True
                , splitratio=[0.59999347192282126, 0.52156842800693504])
        except:
            print "WARNING: failed to restore connection between GetOutURLs_95 and iterate_96 in network SaveNAMDResults_92.macroNetwork"
    if iterate_96 is not None and Download_97 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                iterate_96, Download_97, "oneItem", "url", blocking=True
                , splitratio=[0.38678440315499851, 0.31715485223841539])
        except:
            print "WARNING: failed to restore connection between iterate_96 and Download_97 in network SaveNAMDResults_92.macroNetwork"
    if Download_97 is not None and Save_Lines_98 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                Download_97, Save_Lines_98, "output", "data", blocking=True
                , splitratio=[0.50035280914427516, 0.33329907884695203])
        except:
            print "WARNING: failed to restore connection between Download_97 and Save_Lines_98 in network SaveNAMDResults_92.macroNetwork"
    if input_Ports_93 is not None and dirname_99 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                input_Ports_93, dirname_99, "GetOutURLs_filename", "in1", blocking=True
                , splitratio=[0.52496368582082942, 0.55400275601783233])
        except:
            print "WARNING: failed to restore connection between input_Ports_93 and dirname_99 in network SaveNAMDResults_92.macroNetwork"
    if dirname_99 is not None and Save_Lines_98 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                dirname_99, Save_Lines_98, "result", "filename", blocking=True
                , splitratio=[0.4514169086513527, 0.4798872090720519])
        except:
            print "WARNING: failed to restore connection between dirname_99 and Save_Lines_98 in network SaveNAMDResults_92.macroNetwork"
    if iterate_96 is not None and dirname_99 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                iterate_96, dirname_99, "oneItem", "in2", blocking=True
                , splitratio=[0.20568373387453295, 0.51957862045500858])
        except:
            print "WARNING: failed to restore connection between iterate_96 and dirname_99 in network SaveNAMDResults_92.macroNetwork"
    if GetOutURLs_95 is not None and rename_stdout_100 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                GetOutURLs_95, rename_stdout_100, "run_name", "run_name", blocking=True
                , splitratio=[0.26300655746895119, 0.65993207770562967])
        except:
            print "WARNING: failed to restore connection between GetOutURLs_95 and rename_stdout_100 in network SaveNAMDResults_92.macroNetwork"
    if Save_Lines_98 is not None and if_101 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                Save_Lines_98, if_101, "filename", "value", blocking=True
                , splitratio=[0.6136702937173395, 0.37955912902958122])
        except:
            print "WARNING: failed to restore connection between Save_Lines_98 and if_101 in network SaveNAMDResults_92.macroNetwork"
    if if_101 is not None and rename_stdout_100 is not None:
        try:
            SaveNAMDResults_92.macroNetwork.connectNodes(
                if_101, rename_stdout_100, "_if", "in_name", blocking=True
                , splitratio=[0.42861758851787812, 0.59732773543810935])
        except:
            print "WARNING: failed to restore connection between if_101 and rename_stdout_100 in network SaveNAMDResults_92.macroNetwork"
    SaveNAMDResults_92.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_93.outputPorts[1].configure(name='GetOutURLs_url')
    input_Ports_93.outputPorts[2].configure(name='GetOutURLs_filename')
    SaveNAMDResults_92.inputPorts[0].configure(name='GetOutURLs_url')
    SaveNAMDResults_92.inputPorts[0].configure(datatype='string')
    SaveNAMDResults_92.inputPorts[1].configure(name='GetOutURLs_filename')
    SaveNAMDResults_92.inputPorts[1].configure(datatype='string')
    ## configure MacroNode input ports
    ## configure MacroNode output ports
    SaveNAMDResults_92.shrink()
    apply(SaveNAMDResults_92.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named SaveNAMDResults in network masterNet"
    print_exc()
    SaveNAMDResults_92=None

try:
    ## saving node NamdWS ##
    from NetworkEditor.macros import MacroNode
    NamdWS_102 = MacroNode(name='NamdWS')
    masterNet.addNode(NamdWS_102, 455, 294)
    output_Ports_104 = NamdWS_102.macroNetwork.opNode
    apply(output_Ports_104.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_104.move(211, 381)
    from NetworkEditor.items import FunctionNode
    NAMD_oolite_calit2_optiputer_net_105 = FunctionNode(functionOrString='NAMD_oolite_calit2_optiputer_net', host="http://oolite.calit2.optiputer.net/opal2", namedArgs={'tarball': '', 'namdarg': '', 'localRun': False, 'execPath': '', 'procs': ''}, constrkw={'functionOrString': "'NAMD_oolite_calit2_optiputer_net'", 'host': '"http://oolite.calit2.optiputer.net/opal2"', 'namedArgs': {'tarball': '', 'namdarg': '', 'localRun': False, 'execPath': '', 'procs': ''}}, name='NAMD_oolite_calit2_optiputer_net', library=wslib)
    NamdWS_102.macroNetwork.addNode(NAMD_oolite_calit2_optiputer_net_105,200,233)
    apply(NAMD_oolite_calit2_optiputer_net_105.inputPortByName['tarball'].configure, (), {'defaultValue': None, 'required': True})
    apply(NAMD_oolite_calit2_optiputer_net_105.inputPortByName['namdarg'].configure, (), {'defaultValue': None, 'required': True})
    apply(NAMD_oolite_calit2_optiputer_net_105.inputPortByName['localRun'].configure, (), {'defaultValue': None})
    apply(NAMD_oolite_calit2_optiputer_net_105.inputPortByName['execPath'].configure, (), {'defaultValue': None})
    apply(NAMD_oolite_calit2_optiputer_net_105.inputPortByName['procs'].configure, (), {'defaultValue': None, 'required': True})
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['tarball'].rebindWidget()
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['tarball'].widget.set(r"", run=False)
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['tarball'].unbindWidget()
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['namdarg'].rebindWidget()
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['namdarg'].widget.set(r"", run=False)
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['namdarg'].unbindWidget()
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['localRun'].widget.set(0, run=False)
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['execPath'].widget.set(r"", run=False)
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['procs'].rebindWidget()
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['procs'].widget.set(r"", run=False)
    NAMD_oolite_calit2_optiputer_net_105.inputPortByName['procs'].unbindWidget()
    apply(NAMD_oolite_calit2_optiputer_net_105.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    GetInputFiles_106 = Generic(constrkw={}, name='GetInputFiles', library=stdlib)
    NamdWS_102.macroNetwork.addNode(GetInputFiles_106,120,104)
    apply(GetInputFiles_106.addInputPort, (), {'singleConnection': True, 'name': 'namd_config', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetInputFiles_106.addInputPort, (), {'singleConnection': True, 'name': 'workdir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetInputFiles_106.addOutputPort, (), {'name': 'filelist', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    code = """def doit(self, namd_config, workdir):

        bad_status = ".." + os.sep + "bad.status"
        if os.path.exists(bad_status):
            print "ERROR: Missing files"
            os.remove(bad_status)
            return '''stop'''
        filelist=set()
        filelist.add(workdir + os.sep + namd_config)
        
        f = open(workdir + os.sep + namd_config, "r")

        for line in f.readlines():
            line = line.strip('''
''')

            if line.find("set inpname") >= 0 and (not (line.startswith('''#'''))):
                #inpname = line.strip("set inpname")
                inpname = line.split("set inpname")[1]
                inpname = inpname.lstrip("	")
                inpname = inpname.lstrip(" ")

        f.close()

        f = open(workdir + os.sep + namd_config, "r")

        for line in f.readlines():
            line = line.strip('''
''')
            line = line.strip()

            if (not (line.startswith('''#'''))) and (not (line.startswith("set"))) and len(line.split()) == 2:
                filename = line.split()[1]

                if filename.find('''$inpname''') >= 0:
                    dot = filename.find('''.''')
                    filepath = workdir + os.sep + inpname + filename[dot:]
                else:
                    filepath = workdir + os.sep + filename
    
    
                                                                                                                                                                        
                if os.path.exists(filepath):
                    filelist.add(filepath)

        f.close()
    
	pass
## to ouput data on port filelist use
        self.outputData(filelist=filelist)








































"""
    GetInputFiles_106.configure(function=code)
    apply(GetInputFiles_106.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    CreateZipInput_107 = Generic(constrkw={}, name='CreateZipInput', library=stdlib)
    NamdWS_102.macroNetwork.addNode(CreateZipInput_107,120,163)
    apply(CreateZipInput_107.addInputPort, (), {'singleConnection': True, 'name': 'filelist', 'cast': True, 'datatype': 'list', 'defaultValue': None, 'required': True, 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan', 'originalDatatype': 'None'})
    apply(CreateZipInput_107.addOutputPort, (), {'name': 'zipname', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, filelist):
        import zipfile

        firstfile = filelist[0]
        dirname = os.path.dirname(firstfile) 
        zipname = dirname + '''.zip'''
        zout = zipfile.ZipFile(zipname, '''w''')
        for f in filelist:         
            zout.write(f)
            print f
        zout.close()
	pass
## to ouput data on port zipname use
        self.outputData(zipname=zipname)














"""
    CreateZipInput_107.configure(function=code)
    apply(CreateZipInput_107.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Eval
    eval_108 = Eval(constrkw={}, name='eval', library=stdlib)
    NamdWS_102.macroNetwork.addNode(eval_108,461,161)
    apply(eval_108.inputPortByName['command'].configure, (), {'defaultValue': None})
    apply(eval_108.inputPortByName['in1'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(eval_108.addInputPort, (), {'singleConnection': True, 'name': 'in2', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(eval_108.outputPortByName['result'].configure, (), {'datatype': 'string'})
    eval_108.inputPortByName['command'].widget.set(r"in1 + os.sep + in2", run=False)
    eval_108.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval_108.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
    GetMainURLFromList_109 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
    NamdWS_102.macroNetwork.addNode(GetMainURLFromList_109,200,293)
    apply(GetMainURLFromList_109.inputPortByName['urls'].configure, (), {'defaultValue': None})
    apply(GetMainURLFromList_109.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network NamdWS ##
    NamdWS_102.macroNetwork.freeze()
    if GetInputFiles_106 is not None and CreateZipInput_107 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                GetInputFiles_106, CreateZipInput_107, "filelist", "filelist", blocking=True
                , splitratio=[0.72025678385962366, 0.43905388512035359])
        except:
            print "WARNING: failed to restore connection between GetInputFiles_106 and CreateZipInput_107 in network NamdWS_102.macroNetwork"
    if CreateZipInput_107 is not None and NAMD_oolite_calit2_optiputer_net_105 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                CreateZipInput_107, NAMD_oolite_calit2_optiputer_net_105, "zipname", "tarball", blocking=True
                , splitratio=[0.2787702177916046, 0.27893015447536335])
        except:
            print "WARNING: failed to restore connection between CreateZipInput_107 and NAMD_oolite_calit2_optiputer_net_105 in network NamdWS_102.macroNetwork"
    if NAMD_oolite_calit2_optiputer_net_105 is not None and GetMainURLFromList_109 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                NAMD_oolite_calit2_optiputer_net_105, GetMainURLFromList_109, "result", "urls", blocking=True
                , splitratio=[0.37448110120177591, 0.40134453015177213])
        except:
            print "WARNING: failed to restore connection between NAMD_oolite_calit2_optiputer_net_105 and GetMainURLFromList_109 in network NamdWS_102.macroNetwork"
    input_Ports_103 = NamdWS_102.macroNetwork.ipNode
    if input_Ports_103 is not None and GetInputFiles_106 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                input_Ports_103, GetInputFiles_106, "new", "namd_config", blocking=True
                , splitratio=[0.6558756898232545, 0.71567658393251077])
        except:
            print "WARNING: failed to restore connection between input_Ports_103 and GetInputFiles_106 in network NamdWS_102.macroNetwork"
    if input_Ports_103 is not None and eval_108 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                input_Ports_103, eval_108, "GetInputFiles_namd_config", "in2", blocking=True
                , splitratio=[0.59950400032641604, 0.38305934154601218])
        except:
            print "WARNING: failed to restore connection between input_Ports_103 and eval_108 in network NamdWS_102.macroNetwork"
    if input_Ports_103 is not None and GetInputFiles_106 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                input_Ports_103, GetInputFiles_106, "new", "workdir", blocking=True
                , splitratio=[0.69972832464445833, 0.37400097478245709])
        except:
            print "WARNING: failed to restore connection between input_Ports_103 and GetInputFiles_106 in network NamdWS_102.macroNetwork"
    if input_Ports_103 is not None and eval_108 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                input_Ports_103, eval_108, "GetInputFiles_workdir", "in1", blocking=True
                , splitratio=[0.57274138657288809, 0.28217991549979993])
        except:
            print "WARNING: failed to restore connection between input_Ports_103 and eval_108 in network NamdWS_102.macroNetwork"
    if input_Ports_103 is not None and NAMD_oolite_calit2_optiputer_net_105 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                input_Ports_103, NAMD_oolite_calit2_optiputer_net_105, "new", "procs", blocking=True
                , splitratio=[0.40291801404322869, 0.37140383429750162])
        except:
            print "WARNING: failed to restore connection between input_Ports_103 and NAMD_oolite_calit2_optiputer_net_105 in network NamdWS_102.macroNetwork"
    if input_Ports_103 is not None and NAMD_oolite_calit2_optiputer_net_105 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                input_Ports_103, NAMD_oolite_calit2_optiputer_net_105, "GetInputFiles_namd_config", "namdarg", blocking=True
                , splitratio=[0.74392756255027614, 0.39960632423391002])
        except:
            print "WARNING: failed to restore connection between input_Ports_103 and NAMD_oolite_calit2_optiputer_net_105 in network NamdWS_102.macroNetwork"
    output_Ports_104 = NamdWS_102.macroNetwork.opNode
    if GetMainURLFromList_109 is not None and output_Ports_104 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                GetMainURLFromList_109, output_Ports_104, "newurl", "new", blocking=True
                , splitratio=[0.70966285703602727, 0.47332288539054579])
        except:
            print "WARNING: failed to restore connection between GetMainURLFromList_109 and output_Ports_104 in network NamdWS_102.macroNetwork"
    if eval_108 is not None and output_Ports_104 is not None:
        try:
            NamdWS_102.macroNetwork.connectNodes(
                eval_108, output_Ports_104, "result", "new", blocking=True
                , splitratio=[0.6297570824985439, 0.46025704211360657])
        except:
            print "WARNING: failed to restore connection between eval_108 and output_Ports_104 in network NamdWS_102.macroNetwork"
    NamdWS_102.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_103.outputPorts[1].configure(name='GetInputFiles_namd_config')
    input_Ports_103.outputPorts[2].configure(name='GetInputFiles_workdir')
    input_Ports_103.outputPorts[3].configure(name='NAMD_oolite_calit2_optiputer_net_procs')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_104.inputPorts[1].configure(singleConnection='auto')
    output_Ports_104.inputPorts[2].configure(singleConnection='auto')
    output_Ports_104.inputPorts[1].configure(name='GetMainURLFromList_newurl')
    output_Ports_104.inputPorts[2].configure(name='eval_result')
    NamdWS_102.inputPorts[0].configure(name='GetInputFiles_namd_config')
    NamdWS_102.inputPorts[0].configure(datatype='string')
    NamdWS_102.inputPorts[1].configure(name='GetInputFiles_workdir')
    NamdWS_102.inputPorts[1].configure(datatype='string')
    NamdWS_102.inputPorts[2].configure(name='NAMD_oolite_calit2_optiputer_net_procs')
    NamdWS_102.inputPorts[2].configure(datatype='string')
    ## configure MacroNode input ports
    NamdWS_102.outputPorts[0].configure(name='GetMainURLFromList_newurl')
    NamdWS_102.outputPorts[0].configure(datatype='string')
    NamdWS_102.outputPorts[1].configure(name='eval_result')
    NamdWS_102.outputPorts[1].configure(datatype='None')
    ## configure MacroNode output ports
    NamdWS_102.shrink()
    apply(NamdWS_102.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named NamdWS in network masterNet"
    print_exc()
    NamdWS_102=None

try:
    ## saving node Output Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Output_Directory_Browser_110 = DirBrowserNE(constrkw={}, name='Output Directory Browser', library=stdlib)
    masterNet.addNode(Output_Directory_Browser_110,715,9)
    Output_Directory_Browser_110.inputPortByName['directory'].widget.set(r"NAMDNBCR_0.1_output", run=False)
    apply(Output_Directory_Browser_110.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Output Directory Browser in network masterNet"
    print_exc()
    Output_Directory_Browser_110=None

try:
    ## saving node Preprocessing ##
    from Vision.StandardNodes import Generic
    Preprocessing_111 = Generic(constrkw={}, name='Preprocessing', library=stdlib)
    masterNet.addNode(Preprocessing_111,472,167)
    apply(Preprocessing_111.addInputPort, (), {'singleConnection': True, 'name': 'indir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(Preprocessing_111.addInputPort, (), {'singleConnection': True, 'name': 'outdir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(Preprocessing_111.addOutputPort, (), {'name': 'dir', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, indir, outdir):
        import shutil
        for i in os.listdir(indir):
            shutil.copy(os.path.join(indir, i), os.path.join(outdir, i))
	pass
## to ouput data on port dir use
        self.outputData(dir=outdir)








"""
    Preprocessing_111.configure(function=code)
    apply(Preprocessing_111.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named Preprocessing in network masterNet"
    print_exc()
    Preprocessing_111=None

#masterNet.run()
masterNet.freeze()

## saving connections for network NAMDNBCR-0.1-5 ##
if FileWithCommandOrdering_87 is not None and GetOrdering_88 is not None:
    try:
        masterNet.connectNodes(
            FileWithCommandOrdering_87, GetOrdering_88, "filename", "order_file", blocking=True
            , splitratio=[0.32774364011444035, 0.21898842608941335])
    except:
        print "WARNING: failed to restore connection between FileWithCommandOrdering_87 and GetOrdering_88 in network masterNet"
if GetOrdering_88 is not None and iterate_91 is not None:
    try:
        masterNet.connectNodes(
            GetOrdering_88, iterate_91, "order_list", "listToLoopOver", blocking=True
            , splitratio=[0.21494363189457535, 0.44944332027843292])
    except:
        print "WARNING: failed to restore connection between GetOrdering_88 and iterate_91 in network masterNet"
if Input_Directory_Browser_89 is not None and Preprocessing_111 is not None:
    try:
        masterNet.connectNodes(
            Input_Directory_Browser_89, Preprocessing_111, "directory", "indir", blocking=True
            , splitratio=[0.33900100507833142, 0.29351862664334766])
    except:
        print "WARNING: failed to restore connection between Input_Directory_Browser_89 and Preprocessing_111 in network masterNet"
if Output_Directory_Browser_110 is not None and Preprocessing_111 is not None:
    try:
        masterNet.connectNodes(
            Output_Directory_Browser_110, Preprocessing_111, "directory", "outdir", blocking=True
            , splitratio=[0.57933116349993063, 0.56548337519091696])
    except:
        print "WARNING: failed to restore connection between Output_Directory_Browser_110 and Preprocessing_111 in network masterNet"
NamdWS_102 = masterNet.nodes[6]
if iterate_91 is not None and NamdWS_102 is not None:
    try:
        masterNet.connectNodes(
            iterate_91, NamdWS_102, "oneItem", "GetInputFiles_namd_config", blocking=True
            , splitratio=[0.43918291788255659, 0.4190001936330322])
    except:
        print "WARNING: failed to restore connection between iterate_91 and NamdWS_102 in network masterNet"
if Preprocessing_111 is not None and NamdWS_102 is not None:
    try:
        masterNet.connectNodes(
            Preprocessing_111, NamdWS_102, "dir", "GetInputFiles_workdir", blocking=True
            , splitratio=[0.45891450293332692, 0.22556570815244814])
    except:
        print "WARNING: failed to restore connection between Preprocessing_111 and NamdWS_102 in network masterNet"
if NumProcessors_90 is not None and NamdWS_102 is not None:
    try:
        masterNet.connectNodes(
            NumProcessors_90, NamdWS_102, "string", "NAMD_oolite_calit2_optiputer_net_procs", blocking=True
            , splitratio=[0.6131765337028916, 0.61463966387243119])
    except:
        print "WARNING: failed to restore connection between NumProcessors_90 and NamdWS_102 in network masterNet"
SaveNAMDResults_92 = masterNet.nodes[5]
if NamdWS_102 is not None and SaveNAMDResults_92 is not None:
    try:
        masterNet.connectNodes(
            NamdWS_102, SaveNAMDResults_92, "GetMainURLFromList_newurl", "GetOutURLs_url", blocking=True
            , splitratio=[0.70647944960230902, 0.53390159659163894])
    except:
        print "WARNING: failed to restore connection between NamdWS_102 and SaveNAMDResults_92 in network masterNet"
if NamdWS_102 is not None and SaveNAMDResults_92 is not None:
    try:
        masterNet.connectNodes(
            NamdWS_102, SaveNAMDResults_92, "eval_result", "GetOutURLs_filename", blocking=True
            , splitratio=[0.57750788933334174, 0.28596874406537531])
    except:
        print "WARNING: failed to restore connection between NamdWS_102 and SaveNAMDResults_92 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

