#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Tuesday 15 February 2011 10:48:24 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/CADD/workflows/virtualScreening/VinaVSpublic_0.1_net.py,v 1.1 2011/04/15 16:19:41 nadya Exp $
#
# $Id: VinaVSpublic_0.1_net.py,v 1.1 2011/04/15 16:19:41 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from AutoDockTools.VisionInterface.Adt import Adt
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(Adt,"AutoDockTools.VisionInterface.Adt", "Adt")

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://ws.nbcr.net/opal2", replace=False)
except:
    pass
try:
    addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
except:
    pass
try:
    ## saving node StructureBrowser ##
    from Adt.Input.StructureBrowser import StructureBrowser
    StructureBrowser_0 = StructureBrowser(constrkw={}, name='StructureBrowser', library=Adt)
    masterNet.addNode(StructureBrowser_0,32,37)
    StructureBrowser_0.inputPortByName['receptor_file'].widget.set(r"VinaVSpublic_0.1_input/2HTY_A-2HTY_A.pdb", run=False)
    apply(StructureBrowser_0.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore StructureBrowser named StructureBrowser in network masterNet"
    print_exc()
    StructureBrowser_0=None

try:
    ## saving node PublicServerLigandDB ##
    from Adt.Input.PublicServerLigandDB import PublicServerLigandDB
    PublicServerLigandDB_1 = PublicServerLigandDB(constrkw={}, name='PublicServerLigandDB', library=Adt)
    masterNet.addNode(PublicServerLigandDB_1,419,38)
    PublicServerLigandDB_1.inputPortByName['server_lib'].widget.set(r"sample", run=False)
    apply(PublicServerLigandDB_1.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore PublicServerLigandDB named PublicServerLigandDB in network masterNet"
    print_exc()
    PublicServerLigandDB_1=None

try:
    ## saving node Vina Config File Browser ##
    from Vision.StandardNodes import FileBrowserNE
    Vina_Config_File_Browser_2 = FileBrowserNE(constrkw={}, name='Vina Config File Browser', library=stdlib)
    masterNet.addNode(Vina_Config_File_Browser_2,798,32)
    Vina_Config_File_Browser_2.inputPortByName['filename'].widget.set(r"VinaVSpublic_0.1_input/test.config", run=False)
    apply(Vina_Config_File_Browser_2.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named Vina Config File Browser in network masterNet"
    print_exc()
    Vina_Config_File_Browser_2=None

try:
    ## saving node PrepareReceptor ##
    from Adt.Macro.PrepareReceptor import PrepareReceptor
    PrepareReceptor_3 = PrepareReceptor(constrkw={}, name='PrepareReceptor', library=Adt)
    masterNet.addNode(PrepareReceptor_3,151,197)
    apply(PrepareReceptor_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    Pdb2pqrWS_6 = PrepareReceptor_3.macroNetwork.nodes[2]
    Pdb2pqrOpalService_ws_nbcr_net_10 = Pdb2pqrWS_6.macroNetwork.nodes[3]
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['noopt'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['phi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['psi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['verbose'].widget.set(1, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['chain'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['nodebump'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['chi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['ligand'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['hbond'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['with_ph'].widget.set(r"", run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['forcefield'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['forcefield'].widget.set(r"AMBER", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['clean'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['inId'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['apbs_input'].widget.set(0, run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['ffout'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['ffout'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['localRun'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['rama'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['execPath'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_10.inputPortByName['assign_only'].widget.set(0, run=False)
    GetURLFromList_11 = Pdb2pqrWS_6.macroNetwork.nodes[4]
    GetURLFromList_11.inputPortByName['ext'].widget.set(r"pqr", run=False)

    ## saving connections for network Pdb2pqrWS ##
    Pdb2pqrWS_6.macroNetwork.freeze()
    Pdb2pqrWS_6.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_7 = Pdb2pqrWS_6.macroNetwork.ipNode
    input_Ports_7.outputPorts[1].configure(name='CheckFileFormat_value')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_8 = Pdb2pqrWS_6.macroNetwork.opNode
    output_Ports_8.inputPorts[1].configure(singleConnection='auto')
    output_Ports_8.inputPorts[2].configure(singleConnection='auto')
    output_Ports_8.inputPorts[1].configure(name='UpdateReceptor_receptor_obj')
    output_Ports_8.inputPorts[2].configure(name='UpdateReceptor_pdb2pqr_result')
    Pdb2pqrWS_6.inputPorts[0].configure(name='CheckFileFormat_value')
    Pdb2pqrWS_6.inputPorts[0].configure(datatype='receptor')
    ## configure MacroNode input ports
    Pdb2pqrWS_6.outputPorts[0].configure(name='UpdateReceptor_receptor_obj')
    Pdb2pqrWS_6.outputPorts[0].configure(datatype='receptor')
    Pdb2pqrWS_6.outputPorts[1].configure(name='UpdateReceptor_pdb2pqr_result')
    Pdb2pqrWS_6.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    Pdb2pqrWS_6.shrink()
    PrepareReceptorWS_13 = PrepareReceptor_3.macroNetwork.nodes[3]
    PrepareReceptorOpalService_ws_nbcr_net_17 = PrepareReceptorWS_13.macroNetwork.nodes[3]
    PrepareReceptorOpalService_ws_nbcr_net_17.inputPortByName['o'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_17.inputPortByName['v'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_17.inputPortByName['localRun'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_17.inputPortByName['execPath'].widget.set(r"", run=False)
    GetURLFromList_18 = PrepareReceptorWS_13.macroNetwork.nodes[4]
    GetURLFromList_18.inputPortByName['ext'].widget.set(r"pdbqt", run=False)
    DownloadToFile_19 = PrepareReceptorWS_13.macroNetwork.nodes[5]
    DownloadToFile_19.inputPortByName['overwrite'].widget.set(1, run=False)

    ## saving connections for network PrepareReceptorWS ##
    PrepareReceptorWS_13.macroNetwork.freeze()
    PrepareReceptorWS_13.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_14 = PrepareReceptorWS_13.macroNetwork.ipNode
    input_Ports_14.outputPorts[1].configure(name='CheckFileFormat_value')
    input_Ports_14.outputPorts[2].configure(name='PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_15 = PrepareReceptorWS_13.macroNetwork.opNode
    output_Ports_15.inputPorts[1].configure(singleConnection='auto')
    output_Ports_15.inputPorts[2].configure(singleConnection='auto')
    output_Ports_15.inputPorts[1].configure(name='UpdateReceptor_receptor_prepared_obj')
    output_Ports_15.inputPorts[2].configure(name='UpdateReceptor_receptor_result')
    PrepareReceptorWS_13.inputPorts[0].configure(name='CheckFileFormat_value')
    PrepareReceptorWS_13.inputPorts[0].configure(datatype='receptor')
    PrepareReceptorWS_13.inputPorts[1].configure(name='PrepareReceptorOpalService_ws_nbcr_net_C')
    PrepareReceptorWS_13.inputPorts[1].configure(datatype='boolean')
    ## configure MacroNode input ports
    PrepareReceptorWS_13.outputPorts[0].configure(name='UpdateReceptor_receptor_prepared_obj')
    PrepareReceptorWS_13.outputPorts[0].configure(datatype='receptor_prepared')
    PrepareReceptorWS_13.outputPorts[1].configure(name='UpdateReceptor_receptor_result')
    PrepareReceptorWS_13.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    PrepareReceptorWS_13.shrink()

    ## saving connections for network PrepareReceptor ##
    PrepareReceptor_3.macroNetwork.freeze()
    PrepareReceptor_3.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_4 = PrepareReceptor_3.macroNetwork.ipNode
    input_Ports_4.outputPorts[1].configure(name='Pdb2pqrWS_CheckFileFormat_value')
    input_Ports_4.outputPorts[2].configure(name='PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_5 = PrepareReceptor_3.macroNetwork.opNode
    output_Ports_5.inputPorts[1].configure(singleConnection='auto')
    output_Ports_5.inputPorts[2].configure(singleConnection='auto')
    output_Ports_5.inputPorts[1].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj')
    output_Ports_5.inputPorts[2].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_result')
    PrepareReceptor_3.inputPorts[0].configure(name='Pdb2pqrWS_CheckFileFormat_value')
    PrepareReceptor_3.inputPorts[0].configure(datatype='receptor')
    PrepareReceptor_3.inputPorts[1].configure(name='PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')
    PrepareReceptor_3.inputPorts[1].configure(datatype='boolean')
    ## configure MacroNode input ports
    PrepareReceptor_3.outputPorts[0].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj')
    PrepareReceptor_3.outputPorts[0].configure(datatype='receptor_prepared')
    PrepareReceptor_3.outputPorts[1].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_result')
    PrepareReceptor_3.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    PrepareReceptor_3.shrink()
    apply(PrepareReceptor_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore PrepareReceptor named PrepareReceptor in network masterNet"
    print_exc()
    PrepareReceptor_3=None

try:
    ## saving node Vina ##
    from NetworkEditor.macros import MacroNode
    Vina_21 = MacroNode(name='Vina')
    masterNet.addNode(Vina_21, 402, 254)
    output_Ports_23 = Vina_21.macroNetwork.opNode
    apply(output_Ports_23.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from NetworkEditor.items import FunctionNode
    AutodockVina_Screening_kryptonite_nbcr_net_24 = FunctionNode(functionOrString='AutodockVina_Screening_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", namedArgs={'num_modes': '', 'energy_range': '', 'seed': '', 'receptor': '', 'size_y': '', 'size_z': '', 'out': '', 'log': '', 'urllib': '', 'exhaustiveness': '', 'localRun': False, 'flex': '', 'center_z': '', 'center_x': '', 'center_y': '', 'userlib': '', 'size_x': '', 'config': '', 'filter': '', 'ligand_db': '', 'cpu': '', 'execPath': ''}, constrkw={'functionOrString': "'AutodockVina_Screening_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'namedArgs': {'num_modes': '', 'energy_range': '', 'seed': '', 'receptor': '', 'size_y': '', 'size_z': '', 'out': '', 'log': '', 'urllib': '', 'exhaustiveness': '', 'localRun': False, 'flex': '', 'center_z': '', 'center_x': '', 'center_y': '', 'userlib': '', 'size_x': '', 'config': '', 'filter': '', 'ligand_db': '', 'cpu': '', 'execPath': ''}}, name='AutodockVina_Screening_kryptonite_nbcr_net', library=wslib)
    Vina_21.macroNetwork.addNode(AutodockVina_Screening_kryptonite_nbcr_net_24,217,185)
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['receptor'].configure, (), {'defaultValue': None})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['urllib'].configure, (), {'defaultValue': None})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['userlib'].configure, (), {'defaultValue': None})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['config'].configure, (), {'defaultValue': None, 'required': True})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['filter'].configure, (), {'defaultValue': None})
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['num_modes'].widget.configure, (), {'choices': ('1', '2', '3', '4', '5', '6', '7', '8', '9', '10')})
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['num_modes'].widget.set(r"", run=False)
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['energy_range'].widget.configure, (), {'choices': ('1', '2', '3')})
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['energy_range'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['seed'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['receptor'].rebindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['receptor'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['receptor'].unbindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['size_y'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['size_z'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['out'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['log'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['urllib'].rebindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['urllib'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['urllib'].unbindWidget()
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['exhaustiveness'].widget.configure, (), {'choices': ('1', '2', '3', '4', '5', '6', '7', '8')})
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['exhaustiveness'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['localRun'].widget.set(0, run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['flex'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['center_z'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['center_x'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['center_y'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['userlib'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['size_x'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['config'].rebindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['config'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['config'].unbindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['filter'].rebindWidget()
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['filter'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['filter'].unbindWidget()
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['ligand_db'].widget.configure, (), {'choices': ('sample', 'NCIDS_SC', 'NCI_DS1', 'NCI_DS2', 'human_metabolome', 'chembridge_building_blocks', 'drugbank_nutraceutics', 'drugbank_smallmol', 'asinex', 'fda_approved', 'otava', 'zinc_natural_products')})
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['ligand_db'].widget.set(r"", run=False)
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['cpu'].widget.configure, (), {'choices': ('1', '2')})
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['cpu'].widget.set(r"", run=False)
    AutodockVina_Screening_kryptonite_nbcr_net_24.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(AutodockVina_Screening_kryptonite_nbcr_net_24.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    PrepareVinaInputs_25 = Generic(constrkw={}, name='PrepareVinaInputs', library=stdlib)
    Vina_21.macroNetwork.addNode(PrepareVinaInputs_25,140,107)
    apply(PrepareVinaInputs_25.addInputPort, (), {'singleConnection': True, 'name': 'receptor_obj', 'cast': True, 'datatype': 'receptor_prepared', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'triangle', 'color': '#009900', 'originalDatatype': 'None'})
    apply(PrepareVinaInputs_25.addInputPort, (), {'singleConnection': True, 'name': 'ligand_obj', 'cast': True, 'datatype': 'LigandDB', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'rect', 'color': '#FFCCFF', 'originalDatatype': 'None'})
    apply(PrepareVinaInputs_25.addOutputPort, (), {'name': 'receptor_file', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(PrepareVinaInputs_25.addOutputPort, (), {'name': 'ligand_lib', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(PrepareVinaInputs_25.addOutputPort, (), {'name': 'filter_file', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, receptor_obj, ligand_obj):
        receptor_file = receptor_obj.path
        filter_file = ligand_obj.filter_file
        ligand_lib = ligand_obj.loc

        if receptor_obj.type == "local":
            if not(os.path.exists(receptor_file)):
                print "ERROR: receptor_file " + receptor_file + " does not exist"
                return '''stop'''
        
	pass
        self.outputData(receptor_file=receptor_file, ligand_lib=ligand_lib, filter_file=filter_file)
## to ouput data on port receptor_file use
## self.outputData(receptor_file=data)
## to ouput data on port ligand_lib use
## self.outputData(ligand_lib=data)
## to ouput data on port filter_file use
## self.outputData(filter_file=data)






"""
    PrepareVinaInputs_25.configure(function=code)
    apply(PrepareVinaInputs_25.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
    GetMainURLFromList_26 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
    Vina_21.macroNetwork.addNode(GetMainURLFromList_26,217,248)
    apply(GetMainURLFromList_26.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network Vina ##
    Vina_21.macroNetwork.freeze()
    if PrepareVinaInputs_25 is not None and AutodockVina_Screening_kryptonite_nbcr_net_24 is not None:
        try:
            Vina_21.macroNetwork.connectNodes(
                PrepareVinaInputs_25, AutodockVina_Screening_kryptonite_nbcr_net_24, "receptor_file", "receptor", blocking=True
                , splitratio=[0.48630431331124768, 0.72717758735716731])
        except:
            print "WARNING: failed to restore connection between PrepareVinaInputs_25 and AutodockVina_Screening_kryptonite_nbcr_net_24 in network Vina_21.macroNetwork"
    if PrepareVinaInputs_25 is not None and AutodockVina_Screening_kryptonite_nbcr_net_24 is not None:
        try:
            Vina_21.macroNetwork.connectNodes(
                PrepareVinaInputs_25, AutodockVina_Screening_kryptonite_nbcr_net_24, "ligand_lib", "urllib", blocking=True
                , splitratio=[0.61963739449043087, 0.74955133389937689])
        except:
            print "WARNING: failed to restore connection between PrepareVinaInputs_25 and AutodockVina_Screening_kryptonite_nbcr_net_24 in network Vina_21.macroNetwork"
    if PrepareVinaInputs_25 is not None and AutodockVina_Screening_kryptonite_nbcr_net_24 is not None:
        try:
            Vina_21.macroNetwork.connectNodes(
                PrepareVinaInputs_25, AutodockVina_Screening_kryptonite_nbcr_net_24, "filter_file", "filter", blocking=True
                , splitratio=[0.32670226336274166, 0.25123642944789149])
        except:
            print "WARNING: failed to restore connection between PrepareVinaInputs_25 and AutodockVina_Screening_kryptonite_nbcr_net_24 in network Vina_21.macroNetwork"
    if AutodockVina_Screening_kryptonite_nbcr_net_24 is not None and GetMainURLFromList_26 is not None:
        try:
            Vina_21.macroNetwork.connectNodes(
                AutodockVina_Screening_kryptonite_nbcr_net_24, GetMainURLFromList_26, "result", "urls", blocking=True
                , splitratio=[0.23401196873379349, 0.68593608346615742])
        except:
            print "WARNING: failed to restore connection between AutodockVina_Screening_kryptonite_nbcr_net_24 and GetMainURLFromList_26 in network Vina_21.macroNetwork"
    output_Ports_23 = Vina_21.macroNetwork.opNode
    if GetMainURLFromList_26 is not None and output_Ports_23 is not None:
        try:
            Vina_21.macroNetwork.connectNodes(
                GetMainURLFromList_26, output_Ports_23, "newurl", "new", blocking=True
                , splitratio=[0.26588001265563421, 0.34355863787969732])
        except:
            print "WARNING: failed to restore connection between GetMainURLFromList_26 and output_Ports_23 in network Vina_21.macroNetwork"
    input_Ports_22 = Vina_21.macroNetwork.ipNode
    if input_Ports_22 is not None and PrepareVinaInputs_25 is not None:
        try:
            Vina_21.macroNetwork.connectNodes(
                input_Ports_22, PrepareVinaInputs_25, "new", "receptor_obj", blocking=True
                , splitratio=[0.59193136382656331, 0.41134942510734418])
        except:
            print "WARNING: failed to restore connection between input_Ports_22 and PrepareVinaInputs_25 in network Vina_21.macroNetwork"
    if input_Ports_22 is not None and PrepareVinaInputs_25 is not None:
        try:
            Vina_21.macroNetwork.connectNodes(
                input_Ports_22, PrepareVinaInputs_25, "new", "ligand_obj", blocking=True
                , splitratio=[0.29092159940560591, 0.60619808825531374])
        except:
            print "WARNING: failed to restore connection between input_Ports_22 and PrepareVinaInputs_25 in network Vina_21.macroNetwork"
    if input_Ports_22 is not None and AutodockVina_Screening_kryptonite_nbcr_net_24 is not None:
        try:
            Vina_21.macroNetwork.connectNodes(
                input_Ports_22, AutodockVina_Screening_kryptonite_nbcr_net_24, "new", "config", blocking=True
                , splitratio=[0.24239548372031838, 0.55842775396640953])
        except:
            print "WARNING: failed to restore connection between input_Ports_22 and AutodockVina_Screening_kryptonite_nbcr_net_24 in network Vina_21.macroNetwork"
    Vina_21.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_22.outputPorts[1].configure(name='PrepareVinaInputs_receptor_obj')
    input_Ports_22.outputPorts[2].configure(name='PrepareVinaInputs_ligand_obj')
    input_Ports_22.outputPorts[3].configure(name='AutodockVina_Screening_kryptonite_nbcr_net_config')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_23.inputPorts[1].configure(singleConnection='auto')
    output_Ports_23.inputPorts[1].configure(name='GetMainURLFromList_newurl')
    Vina_21.inputPorts[0].configure(name='PrepareVinaInputs_receptor_obj')
    Vina_21.inputPorts[0].configure(datatype='receptor_prepared')
    Vina_21.inputPorts[1].configure(name='PrepareVinaInputs_ligand_obj')
    Vina_21.inputPorts[1].configure(datatype='LigandDB')
    Vina_21.inputPorts[2].configure(name='AutodockVina_Screening_kryptonite_nbcr_net_config')
    Vina_21.inputPorts[2].configure(datatype='string')
    ## configure MacroNode input ports
    Vina_21.outputPorts[0].configure(name='GetMainURLFromList_newurl')
    Vina_21.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    Vina_21.shrink()
    apply(Vina_21.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named Vina in network masterNet"
    print_exc()
    Vina_21=None

try:
    ## saving node DownloadSaveDir ##
    from WebServices.VisionInterface.WSNodes import DownloadSaveDirNode
    DownloadSaveDir_27 = DownloadSaveDirNode(constrkw={}, name='DownloadSaveDir', library=wslib)
    masterNet.addNode(DownloadSaveDir_27,402,366)
    apply(DownloadSaveDir_27.inputPortByName['url'].configure, (), {'defaultValue': None})
    DownloadSaveDir_27.inputPortByName['url'].rebindWidget()
    DownloadSaveDir_27.inputPortByName['url'].widget.set(r"", run=False)
    DownloadSaveDir_27.inputPortByName['url'].unbindWidget()
    apply(DownloadSaveDir_27.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DownloadSaveDirNode named DownloadSaveDir in network masterNet"
    print_exc()
    DownloadSaveDir_27=None

try:
    ## saving node Output_Directory ##
    from Vision.StandardNodes import DirBrowserNE
    Output_Directory_28 = DirBrowserNE(constrkw={}, name='Output_Directory', library=stdlib)
    masterNet.addNode(Output_Directory_28,703,247)
    Output_Directory_28.inputPortByName['directory'].widget.set(r"VinaVSpublic_0.1_output", run=False)
    apply(Output_Directory_28.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Output_Directory in network masterNet"
    print_exc()
    Output_Directory_28=None

#masterNet.run()
masterNet.freeze()

## saving connections for network VinaVSpublic-0.1 ##
if StructureBrowser_0 is not None and PrepareReceptor_3 is not None:
    try:
        masterNet.connectNodes(
            StructureBrowser_0, PrepareReceptor_3, "receptor_obj", "Pdb2pqrWS_CheckFileFormat_value", blocking=True
            , splitratio=[0.2411512852991527, 0.43763306853849476])
    except:
        print "WARNING: failed to restore connection between StructureBrowser_0 and PrepareReceptor_3 in network masterNet"
Vina_21 = masterNet.nodes[4]
if PrepareReceptor_3 is not None and Vina_21 is not None:
    try:
        masterNet.connectNodes(
            PrepareReceptor_3, Vina_21, "PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj", "PrepareVinaInputs_receptor_obj", blocking=True
            , splitratio=[0.7480148250853722, 0.53664021522471628])
    except:
        print "WARNING: failed to restore connection between PrepareReceptor_3 and Vina_21 in network masterNet"
if PublicServerLigandDB_1 is not None and Vina_21 is not None:
    try:
        masterNet.connectNodes(
            PublicServerLigandDB_1, Vina_21, "ligDB", "PrepareVinaInputs_ligand_obj", blocking=True
            , splitratio=[0.43811904743420815, 0.56852438270751171])
    except:
        print "WARNING: failed to restore connection between PublicServerLigandDB_1 and Vina_21 in network masterNet"
if Vina_Config_File_Browser_2 is not None and Vina_21 is not None:
    try:
        masterNet.connectNodes(
            Vina_Config_File_Browser_2, Vina_21, "filename", "AutodockVina_Screening_kryptonite_nbcr_net_config", blocking=True
            , splitratio=[0.42914417254931403, 0.35140226817657205])
    except:
        print "WARNING: failed to restore connection between Vina_Config_File_Browser_2 and Vina_21 in network masterNet"
if Vina_21 is not None and DownloadSaveDir_27 is not None:
    try:
        masterNet.connectNodes(
            Vina_21, DownloadSaveDir_27, "GetMainURLFromList_newurl", "url", blocking=True
            , splitratio=[0.53439000181688434, 0.44697983643728223])
    except:
        print "WARNING: failed to restore connection between Vina_21 and DownloadSaveDir_27 in network masterNet"
if Output_Directory_28 is not None and DownloadSaveDir_27 is not None:
    try:
        masterNet.connectNodes(
            Output_Directory_28, DownloadSaveDir_27, "directory", "path", blocking=True
            , splitratio=[0.63352013077913427, 0.21502474638435864])
    except:
        print "WARNING: failed to restore connection between Output_Directory_28 and DownloadSaveDir_27 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

