########################################################################
#
#    Vision Node - Python source code - file generated by vision
#    Monday 26 November 2007 07:29:01 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/VisionLibraries/scipylib/signal/waveRead.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#
# $Id: waveRead.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#
import wave

# import node's base class node
from NetworkEditor.items import NetworkNode
class waveRead(NetworkNode):
    mRequiredTypes = {}
    mRequiredSynonyms = [
    ]
    def __init__(self, constrkw = {},  name='waveRead', **kw):
        kw['constrkw'] = constrkw
        kw['name'] = name
        apply( NetworkNode.__init__, (self,), kw)
        code = """def doit(self, filename):
    if filename and len(filename):
        f = wave.open(filename,'rb')
        sampleRate= f.getframerate()
        channels= f.getnchannels()
        datastream= f.readframes( 300000 )
        f.close()
        self.outputData(data=datastream)
## to ouput data on port sample_rate use
        self.outputData(sample_rate=sampleRate)
## to ouput data on port num_channels use
        self.outputData(num_channels=channels)


"""
        self.configure(function=code)
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'filename', 'cast': True, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
        self.outputPortsDescr.append(
            {'name': 'data', 'datatype': 'string', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
        self.outputPortsDescr.append(
            {'name': 'sample_rate', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.outputPortsDescr.append(
            {'name': 'num_channels', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.widgetDescr['filename'] = {
            'initialValue': '', 'labelGridCfg': {'column': 0, 'row': 1}, 'width': 16, 'master': 'node', 'widgetGridCfg': {'labelSide': 'left', 'column': 1, 'row': 1}, 'labelCfg': {'text': 'file:'}, 'class': 'NEEntryWithFileBrowser'}


    def beforeAddingToNetwork(self, net):
        try:
            ed = net.getEditor()
        except:
            import traceback; traceback.print_exc()
            print 'Warning! Could not import widgets'

