#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 24 February 2011 00:59:31 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/CADD/workflows/MDanalysis/NAMDTeragrid_0.1_net.py,v 1.1 2011/04/15 16:03:52 nadya Exp $
#
# $Id: NAMDTeragrid_0.1_net.py,v 1.1 2011/04/15 16:03:52 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://oolitevm.calit2.optiputer.net/opal2", replace=False)
except:
    pass
try:
    ## saving node FileWithCommandOrdering ##
    from Vision.StandardNodes import FileBrowserNE
    FileWithCommandOrdering_0 = FileBrowserNE(constrkw={}, name='FileWithCommandOrdering', library=stdlib)
    masterNet.addNode(FileWithCommandOrdering_0,30,10)
    FileWithCommandOrdering_0.inputPortByName['filename'].widget.set(r"NAMDTeragridGPU_0.1_input/order.txt", run=False)
    apply(FileWithCommandOrdering_0.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named FileWithCommandOrdering in network masterNet"
    print_exc()
    FileWithCommandOrdering_0=None

try:
    ## saving node GetOrdering ##
    from Vision.StandardNodes import Generic
    GetOrdering_1 = Generic(constrkw={}, name='GetOrdering', library=stdlib)
    masterNet.addNode(GetOrdering_1,30,107)
    apply(GetOrdering_1.addInputPort, (), {'singleConnection': True, 'name': 'order_file', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetOrdering_1.addOutputPort, (), {'name': 'order_list', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    code = """def doit(self, order_file):
        olist = []
        f = open(order_file, "r")

        while 1:
            line = f.readline()
            if not line: break
            line = line.strip()

            if line != "":
                olist.append(line)

        f.close()

        c = 0
        print "The following ordering will be used"
        for i in olist:
            c = c + 1
            print str(c) + ". " + i + " "
        
	pass
## to ouput data on port order_list use
        self.outputData(order_list=olist)







"""
    GetOrdering_1.configure(function=code)
    apply(GetOrdering_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named GetOrdering in network masterNet"
    print_exc()
    GetOrdering_1=None

try:
    ## saving node Input Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Input_Directory_Browser_2 = DirBrowserNE(constrkw={}, name='Input Directory Browser', library=stdlib)
    masterNet.addNode(Input_Directory_Browser_2,375,8)
    Input_Directory_Browser_2.inputPortByName['directory'].widget.set(r"NAMDTeragridGPU_0.1_input", run=False)
    apply(Input_Directory_Browser_2.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Input Directory Browser in network masterNet"
    print_exc()
    Input_Directory_Browser_2=None

try:
    ## saving node NumProcessors ##
    from Vision.StandardNodes import EntryNE
    NumProcessors_3 = EntryNE(constrkw={}, name='NumProcessors', library=stdlib)
    masterNet.addNode(NumProcessors_3,1043,12)
    NumProcessors_3.inputPortByName['entry'].widget.set(r"32", run=False)
    code = """def doit(self, entry):
    if len(str(entry))!=0:
        self.outputData(string=entry)

"""
    NumProcessors_3.configure(function=code)
    apply(NumProcessors_3.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore EntryNE named NumProcessors in network masterNet"
    print_exc()
    NumProcessors_3=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_4 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_4,30,169)
    iterate_4.inputPortByName['stopOnFailure'].widget.set(1, run=False)
    apply(iterate_4.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_4=None

try:
    ## saving node SaveNAMDResults ##
    from NetworkEditor.macros import MacroNode
    SaveNAMDResults_5 = MacroNode(name='SaveNAMDResults')
    masterNet.addNode(SaveNAMDResults_5, 455, 392)
    output_Ports_7 = SaveNAMDResults_5.macroNetwork.opNode
    apply(output_Ports_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_7.move(130, 477)
    from Vision.StandardNodes import Generic
    GetOutURLs_8 = Generic(constrkw={}, name='GetOutURLs', library=stdlib)
    SaveNAMDResults_5.macroNetwork.addNode(GetOutURLs_8,118,98)
    apply(GetOutURLs_8.addInputPort, (), {'singleConnection': True, 'name': 'filename', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetOutURLs_8.addInputPort, (), {'singleConnection': True, 'name': 'url', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetOutURLs_8.addOutputPort, (), {'name': 'outfile_list', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    apply(GetOutURLs_8.addOutputPort, (), {'name': 'run_name', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, filename, url):
        import urllib
        ofilelist = []
        ofw = []

        # Find outname string
        f = open(filename, "r")

        outname = ""
        restartname = None
        
        for line in f.readlines():
            
            line = line.strip('''
''')

            if line.find("set outname") >= 0 and (not (line.startswith('''#'''))) and outname == "":
                #outname = line.strip("set outname")
                outname = line.split("set outname")[1]
                outname = outname.lstrip("	")
                outname = outname.lstrip(" ")
            elif line.find("outputname") >= 0 and (not (line.startswith('''#'''))) and outname == "":
                #outname = line.strip("outputname")
                outname = line.split("outputname")[1]
                outname = outname.lstrip("	")
                outname = outname.lstrip(" ")

            if line.find("restartname") >= 0 and (not (line.startswith('''#'''))):
                #restartname = line.strip("restartname")
                restartname = line.split("restartment")[1]
                restartname = restartname.lstrip("	")
                restartname = restartname.lstrip(" ")            
                
        f.close()

        if (outname == None):
            print "ERROR: Please set outputname in your NAMD conf file"
            return '''stop'''

        opener = urllib.FancyURLopener({})
        f = opener.open(url)

        for line in f.readlines():
            if (line.startswith("<a href=")):
                poss = line.find("<tt>") + 4;
                pose = line.find("</tt>")
                line = line[poss:pose]
                if line.startswith(outname+'''.'''):
                    ofw.append(line)
                if restartname != None and line.startswith(restartname+'''.'''):
                    ofw.append(line)
    
        f.close()

        extc = [".vel", ".xsc", ".xst", ".coor"]

        for i in extc:
            n = outname + i
            ofw.append(n)

        ofw.append("csf_stdout.txt")

        for i in ofw:
            ofilelist.append(url + i)    

        run_name = os.path.basename(filename)
        
	pass
## to ouput data on port outfile_list use
        self.outputData(outfile_list=ofilelist, run_name=run_name)








































"""
    GetOutURLs_8.configure(function=code)
    apply(GetOutURLs_8.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Iterate
    iterate_9 = Iterate(constrkw={}, name='iterate', library=stdlib)
    SaveNAMDResults_5.macroNetwork.addNode(iterate_9,43,152)
    iterate_9.inputPortByName['stopOnFailure'].widget.set(1, run=False)
    apply(iterate_9.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import DownloadNode
    Download_10 = DownloadNode(constrkw={}, name='Download', library=wslib)
    SaveNAMDResults_5.macroNetwork.addNode(Download_10,118,221)
    apply(Download_10.inputPortByName['url'].configure, (), {'defaultValue': None})
    Download_10.inputPortByName['url'].rebindWidget()
    Download_10.inputPortByName['url'].widget.set(r"", run=False)
    Download_10.inputPortByName['url'].unbindWidget()
    code = """def doit(self, url):
    if checkURL(url):
        opener = urllib.FancyURLopener({})
        in_file = opener.open(url)
        self.outputData(output=in_file.read())
    else:
        print "ERROR: expect output " + url + " missing"
        self.editor.stopCurrentNet_cb()








"""
    Download_10.configure(function=code)
    apply(Download_10.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import SaveLines
    Save_Lines_11 = SaveLines(constrkw={}, name='Save Lines', library=stdlib)
    SaveNAMDResults_5.macroNetwork.addNode(Save_Lines_11,217,281)
    apply(Save_Lines_11.inputPortByName['filename'].configure, (), {'defaultValue': None})
    Save_Lines_11.inputPortByName['filename'].rebindWidget()
    Save_Lines_11.inputPortByName['filename'].widget.set(r"", run=False)
    Save_Lines_11.inputPortByName['filename'].unbindWidget()
    apply(Save_Lines_11.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    dirname_12 = Eval(constrkw={}, name='dirname', library=stdlib)
    SaveNAMDResults_5.macroNetwork.addNode(dirname_12,234,220)
    apply(dirname_12.addInputPort, (), {'singleConnection': True, 'name': 'in2', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    dirname_12.inputPortByName['command'].widget.set(r"os.path.dirname(in1)+os.sep+os.path.basename(in2)", run=False)
    dirname_12.inputPortByName['importString'].widget.set(r"", run=False)
    apply(dirname_12.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    rename_stdout_13 = Generic(constrkw={}, name='rename_stdout', library=stdlib)
    SaveNAMDResults_5.macroNetwork.addNode(rename_stdout_13,118,431)
    apply(rename_stdout_13.addInputPort, (), {'singleConnection': True, 'name': 'in_name', 'cast': True, 'datatype': 'None', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(rename_stdout_13.addInputPort, (), {'singleConnection': True, 'name': 'run_name', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(rename_stdout_13.addOutputPort, (), {'name': 'out_name', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, in_name, run_name):
        file_basename = os.path.basename(in_name)
        file_basedir = os.path.dirname(in_name)
        out_name = file_basedir + os.sep + file_basename + '''.''' + run_name

        os.rename(in_name, out_name)
        
	pass
## to ouput data on port out_name use
        self.outputData(out_name=out_name)



"""
    rename_stdout_13.configure(function=code)
    apply(rename_stdout_13.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import IfNode
    if_14 = IfNode(constrkw={}, name='if', library=stdlib)
    SaveNAMDResults_5.macroNetwork.addNode(if_14,217,338)
    if_14.inputPortByName['condition'].widget.set(r"os.path.basename(value) == 'csf_stdout.txt'", run=False)
    apply(if_14.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network SaveNAMDResults ##
    SaveNAMDResults_5.macroNetwork.freeze()
    input_Ports_6 = SaveNAMDResults_5.macroNetwork.ipNode
    if input_Ports_6 is not None and GetOutURLs_8 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                input_Ports_6, GetOutURLs_8, "new", "url", blocking=True
                , splitratio=[0.6832953128822854, 0.33142188038532305])
        except:
            print "WARNING: failed to restore connection between input_Ports_6 and GetOutURLs_8 in network SaveNAMDResults_5.macroNetwork"
    if input_Ports_6 is not None and GetOutURLs_8 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                input_Ports_6, GetOutURLs_8, "new", "filename", blocking=True
                , splitratio=[1.0, 0.74456555351349663])
        except:
            print "WARNING: failed to restore connection between input_Ports_6 and GetOutURLs_8 in network SaveNAMDResults_5.macroNetwork"
    if GetOutURLs_8 is not None and iterate_9 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                GetOutURLs_8, iterate_9, "outfile_list", "listToLoopOver", blocking=True
                , splitratio=[0.59999347192282126, 0.52156842800693504])
        except:
            print "WARNING: failed to restore connection between GetOutURLs_8 and iterate_9 in network SaveNAMDResults_5.macroNetwork"
    if iterate_9 is not None and Download_10 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                iterate_9, Download_10, "oneItem", "url", blocking=True
                , splitratio=[0.38678440315499851, 0.31715485223841539])
        except:
            print "WARNING: failed to restore connection between iterate_9 and Download_10 in network SaveNAMDResults_5.macroNetwork"
    if Download_10 is not None and Save_Lines_11 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                Download_10, Save_Lines_11, "output", "data", blocking=True
                , splitratio=[0.50035280914427516, 0.33329907884695203])
        except:
            print "WARNING: failed to restore connection between Download_10 and Save_Lines_11 in network SaveNAMDResults_5.macroNetwork"
    if input_Ports_6 is not None and dirname_12 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                input_Ports_6, dirname_12, "GetOutURLs_filename", "in1", blocking=True
                , splitratio=[0.52496368582082942, 0.55400275601783233])
        except:
            print "WARNING: failed to restore connection between input_Ports_6 and dirname_12 in network SaveNAMDResults_5.macroNetwork"
    if dirname_12 is not None and Save_Lines_11 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                dirname_12, Save_Lines_11, "result", "filename", blocking=True
                , splitratio=[0.4514169086513527, 0.4798872090720519])
        except:
            print "WARNING: failed to restore connection between dirname_12 and Save_Lines_11 in network SaveNAMDResults_5.macroNetwork"
    if iterate_9 is not None and dirname_12 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                iterate_9, dirname_12, "oneItem", "in2", blocking=True
                , splitratio=[0.20568373387453295, 0.51957862045500858])
        except:
            print "WARNING: failed to restore connection between iterate_9 and dirname_12 in network SaveNAMDResults_5.macroNetwork"
    if GetOutURLs_8 is not None and rename_stdout_13 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                GetOutURLs_8, rename_stdout_13, "run_name", "run_name", blocking=True
                , splitratio=[0.26300655746895119, 0.65993207770562967])
        except:
            print "WARNING: failed to restore connection between GetOutURLs_8 and rename_stdout_13 in network SaveNAMDResults_5.macroNetwork"
    if Save_Lines_11 is not None and if_14 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                Save_Lines_11, if_14, "filename", "value", blocking=True
                , splitratio=[0.6136702937173395, 0.37955912902958122])
        except:
            print "WARNING: failed to restore connection between Save_Lines_11 and if_14 in network SaveNAMDResults_5.macroNetwork"
    if if_14 is not None and rename_stdout_13 is not None:
        try:
            SaveNAMDResults_5.macroNetwork.connectNodes(
                if_14, rename_stdout_13, "_if", "in_name", blocking=True
                , splitratio=[0.42861758851787812, 0.59732773543810935])
        except:
            print "WARNING: failed to restore connection between if_14 and rename_stdout_13 in network SaveNAMDResults_5.macroNetwork"
    SaveNAMDResults_5.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_6.outputPorts[1].configure(name='GetOutURLs_url')
    input_Ports_6.outputPorts[2].configure(name='GetOutURLs_filename')
    SaveNAMDResults_5.inputPorts[0].configure(name='GetOutURLs_url')
    SaveNAMDResults_5.inputPorts[0].configure(datatype='string')
    SaveNAMDResults_5.inputPorts[1].configure(name='GetOutURLs_filename')
    SaveNAMDResults_5.inputPorts[1].configure(datatype='string')
    ## configure MacroNode input ports
    ## configure MacroNode output ports
    SaveNAMDResults_5.shrink()
    apply(SaveNAMDResults_5.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named SaveNAMDResults in network masterNet"
    print_exc()
    SaveNAMDResults_5=None

try:
    ## saving node NamdWS ##
    from NetworkEditor.macros import MacroNode
    NamdWS_15 = MacroNode(name='NamdWS')
    masterNet.addNode(NamdWS_15, 455, 313)
    output_Ports_17 = NamdWS_15.macroNetwork.opNode
    apply(output_Ports_17.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_17.move(211, 381)
    from NetworkEditor.items import FunctionNode
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 = FunctionNode(functionOrString='NAMD_Teragrid_oolitevm_calit2_optiputer_net', host="http://oolitevm.calit2.optiputer.net/opal2", namedArgs={'tarball': '', 'namdarg': '', 'procs': '', 'gpu': False, 'localRun': False, 'execPath': ''}, constrkw={'functionOrString': "'NAMD_Teragrid_oolitevm_calit2_optiputer_net'", 'host': '"http://oolitevm.calit2.optiputer.net/opal2"', 'namedArgs': {'tarball': '', 'namdarg': '', 'procs': '', 'gpu': False, 'localRun': False, 'execPath': ''}}, name='NAMD_Teragrid_oolitevm_calit2_optiputer_net', library=wslib)
    NamdWS_15.macroNetwork.addNode(NAMD_Teragrid_oolitevm_calit2_optiputer_net_18,200,233)
    apply(NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['tarball'].configure, (), {'defaultValue': None, 'required': True})
    apply(NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['namdarg'].configure, (), {'defaultValue': None, 'required': True})
    apply(NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['procs'].configure, (), {'defaultValue': None, 'required': True})
    apply(NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['gpu'].configure, (), {'defaultValue': None})
    apply(NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['localRun'].configure, (), {'defaultValue': None})
    apply(NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['execPath'].configure, (), {'defaultValue': None})
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['tarball'].rebindWidget()
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['tarball'].widget.set(r"", run=False)
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['tarball'].unbindWidget()
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['namdarg'].rebindWidget()
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['namdarg'].widget.set(r"", run=False)
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['namdarg'].unbindWidget()
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['procs'].rebindWidget()
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['procs'].widget.set(r"", run=False)
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['procs'].unbindWidget()
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['gpu'].rebindWidget()
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['gpu'].widget.set(0, run=False)
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['gpu'].unbindWidget()
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['localRun'].widget.set(0, run=False)
    NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(NAMD_Teragrid_oolitevm_calit2_optiputer_net_18.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    GetInputFiles_19 = Generic(constrkw={}, name='GetInputFiles', library=stdlib)
    NamdWS_15.macroNetwork.addNode(GetInputFiles_19,120,104)
    apply(GetInputFiles_19.addInputPort, (), {'singleConnection': True, 'name': 'namd_config', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetInputFiles_19.addInputPort, (), {'singleConnection': True, 'name': 'workdir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetInputFiles_19.addOutputPort, (), {'name': 'filelist', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    code = """def doit(self, namd_config, workdir):

        bad_status = ".." + os.sep + "bad.status"
        if os.path.exists(bad_status):
            print "ERROR: Missing files"
            os.remove(bad_status)
            return '''stop'''
        filelist=set()
        filelist.add(workdir + os.sep + namd_config)
        
        f = open(workdir + os.sep + namd_config, "r")

        for line in f.readlines():
            line = line.strip('''
''')

            if line.find("set inpname") >= 0 and (not (line.startswith('''#'''))):
                #inpname = line.strip("set inpname")
                inpname = line.split("set inpname")[1] 
                inpname = inpname.lstrip("	")
                inpname = inpname.lstrip(" ")

        f.close()

        f = open(workdir + os.sep + namd_config, "r")

        for line in f.readlines():
            line = line.strip('''
''')
            line = line.strip()

            if (not (line.startswith('''#'''))) and (not (line.startswith("set"))) and len(line.split()) == 2:
                filename = line.split()[1]

                if filename.find('''$inpname''') >= 0:
                    dot = filename.find('''.''')
                    filepath = workdir + os.sep + inpname + filename[dot:]
                else:
                    filepath = workdir + os.sep + filename
    
    
                                                                                                                                                                        
                if os.path.exists(filepath):
                    filelist.add(filepath)

        f.close()
    
	pass
## to ouput data on port filelist use
        self.outputData(filelist=filelist)








































"""
    GetInputFiles_19.configure(function=code)
    apply(GetInputFiles_19.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    CreateZipInput_20 = Generic(constrkw={}, name='CreateZipInput', library=stdlib)
    NamdWS_15.macroNetwork.addNode(CreateZipInput_20,120,163)
    apply(CreateZipInput_20.addInputPort, (), {'singleConnection': True, 'name': 'filelist', 'cast': True, 'datatype': 'list', 'defaultValue': None, 'required': True, 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan', 'originalDatatype': 'None'})
    apply(CreateZipInput_20.addOutputPort, (), {'name': 'zipname', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, filelist):
        import zipfile

        firstfile = filelist[0]
        dirname = os.path.dirname(firstfile) 
        zipname = dirname + '''.zip'''
        zout = zipfile.ZipFile(zipname, '''w''')
        for f in filelist:         
            zout.write(f)
            print f
        zout.close()
	pass
## to ouput data on port zipname use
        self.outputData(zipname=zipname)














"""
    CreateZipInput_20.configure(function=code)
    apply(CreateZipInput_20.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Eval
    eval_21 = Eval(constrkw={}, name='eval', library=stdlib)
    NamdWS_15.macroNetwork.addNode(eval_21,461,161)
    apply(eval_21.inputPortByName['command'].configure, (), {'defaultValue': None})
    apply(eval_21.inputPortByName['in1'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(eval_21.addInputPort, (), {'singleConnection': True, 'name': 'in2', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(eval_21.outputPortByName['result'].configure, (), {'datatype': 'string'})
    eval_21.inputPortByName['command'].widget.set(r"in1 + os.sep + in2", run=False)
    eval_21.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval_21.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
    GetMainURLFromList_22 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
    NamdWS_15.macroNetwork.addNode(GetMainURLFromList_22,200,293)
    apply(GetMainURLFromList_22.inputPortByName['urls'].configure, (), {'defaultValue': None})
    apply(GetMainURLFromList_22.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network NamdWS ##
    NamdWS_15.macroNetwork.freeze()
    if GetInputFiles_19 is not None and CreateZipInput_20 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                GetInputFiles_19, CreateZipInput_20, "filelist", "filelist", blocking=True
                , splitratio=[0.72025678385962366, 0.43905388512035359])
        except:
            print "WARNING: failed to restore connection between GetInputFiles_19 and CreateZipInput_20 in network NamdWS_15.macroNetwork"
    if CreateZipInput_20 is not None and NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                CreateZipInput_20, NAMD_Teragrid_oolitevm_calit2_optiputer_net_18, "zipname", "tarball", blocking=True
                , splitratio=[0.2787702177916046, 0.27893015447536335])
        except:
            print "WARNING: failed to restore connection between CreateZipInput_20 and NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 in network NamdWS_15.macroNetwork"
    if NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 is not None and GetMainURLFromList_22 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                NAMD_Teragrid_oolitevm_calit2_optiputer_net_18, GetMainURLFromList_22, "result", "urls", blocking=True
                , splitratio=[0.37448110120177591, 0.40134453015177213])
        except:
            print "WARNING: failed to restore connection between NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 and GetMainURLFromList_22 in network NamdWS_15.macroNetwork"
    input_Ports_16 = NamdWS_15.macroNetwork.ipNode
    if input_Ports_16 is not None and GetInputFiles_19 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                input_Ports_16, GetInputFiles_19, "new", "namd_config", blocking=True
                , splitratio=[0.6558756898232545, 0.71567658393251077])
        except:
            print "WARNING: failed to restore connection between input_Ports_16 and GetInputFiles_19 in network NamdWS_15.macroNetwork"
    if input_Ports_16 is not None and eval_21 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                input_Ports_16, eval_21, "GetInputFiles_namd_config", "in2", blocking=True
                , splitratio=[0.59950400032641604, 0.38305934154601218])
        except:
            print "WARNING: failed to restore connection between input_Ports_16 and eval_21 in network NamdWS_15.macroNetwork"
    if input_Ports_16 is not None and GetInputFiles_19 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                input_Ports_16, GetInputFiles_19, "new", "workdir", blocking=True
                , splitratio=[0.69972832464445833, 0.37400097478245709])
        except:
            print "WARNING: failed to restore connection between input_Ports_16 and GetInputFiles_19 in network NamdWS_15.macroNetwork"
    if input_Ports_16 is not None and eval_21 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                input_Ports_16, eval_21, "GetInputFiles_workdir", "in1", blocking=True
                , splitratio=[0.57274138657288809, 0.28217991549979993])
        except:
            print "WARNING: failed to restore connection between input_Ports_16 and eval_21 in network NamdWS_15.macroNetwork"
    if input_Ports_16 is not None and NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                input_Ports_16, NAMD_Teragrid_oolitevm_calit2_optiputer_net_18, "new", "procs", blocking=True
                , splitratio=[0.40291801404322869, 0.37140383429750162])
        except:
            print "WARNING: failed to restore connection between input_Ports_16 and NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 in network NamdWS_15.macroNetwork"
    if input_Ports_16 is not None and NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                input_Ports_16, NAMD_Teragrid_oolitevm_calit2_optiputer_net_18, "GetInputFiles_namd_config", "namdarg", blocking=True
                , splitratio=[0.74392756255027614, 0.39960632423391002])
        except:
            print "WARNING: failed to restore connection between input_Ports_16 and NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 in network NamdWS_15.macroNetwork"
    output_Ports_17 = NamdWS_15.macroNetwork.opNode
    if GetMainURLFromList_22 is not None and output_Ports_17 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                GetMainURLFromList_22, output_Ports_17, "newurl", "new", blocking=True
                , splitratio=[0.70966285703602727, 0.47332288539054579])
        except:
            print "WARNING: failed to restore connection between GetMainURLFromList_22 and output_Ports_17 in network NamdWS_15.macroNetwork"
    if eval_21 is not None and output_Ports_17 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                eval_21, output_Ports_17, "result", "new", blocking=True
                , splitratio=[0.6297570824985439, 0.46025704211360657])
        except:
            print "WARNING: failed to restore connection between eval_21 and output_Ports_17 in network NamdWS_15.macroNetwork"
    if input_Ports_16 is not None and NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 is not None:
        try:
            NamdWS_15.macroNetwork.connectNodes(
                input_Ports_16, NAMD_Teragrid_oolitevm_calit2_optiputer_net_18, "new", "gpu", blocking=True
                , splitratio=[0.71789539030081562, 0.55068270384179785])
        except:
            print "WARNING: failed to restore connection between input_Ports_16 and NAMD_Teragrid_oolitevm_calit2_optiputer_net_18 in network NamdWS_15.macroNetwork"
    NamdWS_15.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_16.outputPorts[1].configure(name='GetInputFiles_namd_config')
    input_Ports_16.outputPorts[2].configure(name='GetInputFiles_workdir')
    input_Ports_16.outputPorts[3].configure(name='NAMD_Teragrid_oolitevm_calit2_optiputer_net_procs')
    input_Ports_16.outputPorts[4].configure(name='NAMD_Teragrid_oolitevm_calit2_optiputer_net_gpu')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_17.inputPorts[1].configure(singleConnection='auto')
    output_Ports_17.inputPorts[2].configure(singleConnection='auto')
    output_Ports_17.inputPorts[1].configure(name='GetMainURLFromList_newurl')
    output_Ports_17.inputPorts[2].configure(name='eval_result')
    NamdWS_15.inputPorts[0].configure(name='GetInputFiles_namd_config')
    NamdWS_15.inputPorts[0].configure(datatype='string')
    NamdWS_15.inputPorts[1].configure(name='GetInputFiles_workdir')
    NamdWS_15.inputPorts[1].configure(datatype='string')
    NamdWS_15.inputPorts[2].configure(name='NAMD_Teragrid_oolitevm_calit2_optiputer_net_procs')
    NamdWS_15.inputPorts[2].configure(datatype='string')
    NamdWS_15.inputPorts[3].configure(name='NAMD_Teragrid_oolitevm_calit2_optiputer_net_gpu')
    NamdWS_15.inputPorts[3].configure(datatype='boolean')
    ## configure MacroNode input ports
    NamdWS_15.outputPorts[0].configure(name='GetMainURLFromList_newurl')
    NamdWS_15.outputPorts[0].configure(datatype='string')
    NamdWS_15.outputPorts[1].configure(name='eval_result')
    NamdWS_15.outputPorts[1].configure(datatype='None')
    ## configure MacroNode output ports
    NamdWS_15.shrink()
    apply(NamdWS_15.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named NamdWS in network masterNet"
    print_exc()
    NamdWS_15=None

try:
    ## saving node Output Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Output_Directory_Browser_23 = DirBrowserNE(constrkw={}, name='Output Directory Browser', library=stdlib)
    masterNet.addNode(Output_Directory_Browser_23,715,9)
    Output_Directory_Browser_23.inputPortByName['directory'].widget.set(r"NAMDTeragridGPU_0.1_output", run=False)
    apply(Output_Directory_Browser_23.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Output Directory Browser in network masterNet"
    print_exc()
    Output_Directory_Browser_23=None

try:
    ## saving node Preprocessing ##
    from Vision.StandardNodes import Generic
    Preprocessing_24 = Generic(constrkw={}, name='Preprocessing', library=stdlib)
    masterNet.addNode(Preprocessing_24,472,167)
    apply(Preprocessing_24.addInputPort, (), {'singleConnection': True, 'name': 'indir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(Preprocessing_24.addInputPort, (), {'singleConnection': True, 'name': 'outdir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(Preprocessing_24.addOutputPort, (), {'name': 'dir', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, indir, outdir):
        import shutil
        for i in os.listdir(indir):
            shutil.copy(os.path.join(indir, i), os.path.join(outdir, i))
	pass
## to ouput data on port dir use
        self.outputData(dir=outdir)








"""
    Preprocessing_24.configure(function=code)
    apply(Preprocessing_24.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named Preprocessing in network masterNet"
    print_exc()
    Preprocessing_24=None

try:
    ## saving node GPU? ##
    from Vision.StandardNodes import CheckButtonNE
    GPU__25 = CheckButtonNE(constrkw={}, name='GPU?', library=stdlib)
    masterNet.addNode(GPU__25,1254,10)
    GPU__25.inputPortByName['button'].widget.set(1, run=False)
    apply(GPU__25.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore CheckButtonNE named GPU? in network masterNet"
    print_exc()
    GPU__25=None

#masterNet.run()
masterNet.freeze()

## saving connections for network NAMDTeragrid-0.9 ##
if FileWithCommandOrdering_0 is not None and GetOrdering_1 is not None:
    try:
        masterNet.connectNodes(
            FileWithCommandOrdering_0, GetOrdering_1, "filename", "order_file", blocking=True
            , splitratio=[0.32774364011444035, 0.21898842608941335])
    except:
        print "WARNING: failed to restore connection between FileWithCommandOrdering_0 and GetOrdering_1 in network masterNet"
if GetOrdering_1 is not None and iterate_4 is not None:
    try:
        masterNet.connectNodes(
            GetOrdering_1, iterate_4, "order_list", "listToLoopOver", blocking=True
            , splitratio=[0.21494363189457535, 0.44944332027843292])
    except:
        print "WARNING: failed to restore connection between GetOrdering_1 and iterate_4 in network masterNet"
if Input_Directory_Browser_2 is not None and Preprocessing_24 is not None:
    try:
        masterNet.connectNodes(
            Input_Directory_Browser_2, Preprocessing_24, "directory", "indir", blocking=True
            , splitratio=[0.33900100507833142, 0.29351862664334766])
    except:
        print "WARNING: failed to restore connection between Input_Directory_Browser_2 and Preprocessing_24 in network masterNet"
if Output_Directory_Browser_23 is not None and Preprocessing_24 is not None:
    try:
        masterNet.connectNodes(
            Output_Directory_Browser_23, Preprocessing_24, "directory", "outdir", blocking=True
            , splitratio=[0.57933116349993063, 0.56548337519091696])
    except:
        print "WARNING: failed to restore connection between Output_Directory_Browser_23 and Preprocessing_24 in network masterNet"
NamdWS_15 = masterNet.nodes[6]
if iterate_4 is not None and NamdWS_15 is not None:
    try:
        masterNet.connectNodes(
            iterate_4, NamdWS_15, "oneItem", "GetInputFiles_namd_config", blocking=True
            , splitratio=[0.43918291788255659, 0.4190001936330322])
    except:
        print "WARNING: failed to restore connection between iterate_4 and NamdWS_15 in network masterNet"
if Preprocessing_24 is not None and NamdWS_15 is not None:
    try:
        masterNet.connectNodes(
            Preprocessing_24, NamdWS_15, "dir", "GetInputFiles_workdir", blocking=True
            , splitratio=[0.45891450293332692, 0.22556570815244814])
    except:
        print "WARNING: failed to restore connection between Preprocessing_24 and NamdWS_15 in network masterNet"
if NumProcessors_3 is not None and NamdWS_15 is not None:
    try:
        masterNet.connectNodes(
            NumProcessors_3, NamdWS_15, "string", "NAMD_Teragrid_oolitevm_calit2_optiputer_net_procs", blocking=True
            , splitratio=[0.6131765337028916, 0.61463966387243119])
    except:
        print "WARNING: failed to restore connection between NumProcessors_3 and NamdWS_15 in network masterNet"
SaveNAMDResults_5 = masterNet.nodes[5]
if NamdWS_15 is not None and SaveNAMDResults_5 is not None:
    try:
        masterNet.connectNodes(
            NamdWS_15, SaveNAMDResults_5, "GetMainURLFromList_newurl", "GetOutURLs_url", blocking=True
            , splitratio=[0.70647944960230902, 0.53390159659163894])
    except:
        print "WARNING: failed to restore connection between NamdWS_15 and SaveNAMDResults_5 in network masterNet"
if NamdWS_15 is not None and SaveNAMDResults_5 is not None:
    try:
        masterNet.connectNodes(
            NamdWS_15, SaveNAMDResults_5, "eval_result", "GetOutURLs_filename", blocking=True
            , splitratio=[0.57750788933334174, 0.28596874406537531])
    except:
        print "WARNING: failed to restore connection between NamdWS_15 and SaveNAMDResults_5 in network masterNet"
if GPU__25 is not None and NamdWS_15 is not None:
    try:
        masterNet.connectNodes(
            GPU__25, NamdWS_15, "value_bool", "NAMD_Teragrid_oolitevm_calit2_optiputer_net_gpu", blocking=True
            , splitratio=[0.32915956852710521, 0.67444142738357482])
    except:
        print "WARNING: failed to restore connection between GPU__25 and NamdWS_15 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

