#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 24 February 2011 02:04:38 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/CADD/workflows/virtualScreening/AutoDockVSlocal_0.1_net.py,v 1.1 2011/04/15 16:19:38 nadya Exp $
#
# $Id: AutoDockVSlocal_0.1_net.py,v 1.1 2011/04/15 16:19:38 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from AutoDockTools.VisionInterface.Adt import Adt
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(Adt,"AutoDockTools.VisionInterface.Adt", "Adt")

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://ws.nbcr.net/opal2", replace=False)
except:
    pass
try:
    addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
except:
    pass
try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_0 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_0,16,228)
    iterate_0.inputPortByName['stopOnFailure'].widget.set(0, run=False)
    apply(iterate_0.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_0=None

try:
    ## saving node VirtualScreening ##
    from Adt.Macro.VirtualScreening import VirtualScreening
    VirtualScreening_1 = VirtualScreening(constrkw={}, name='VirtualScreening', library=Adt)
    masterNet.addNode(VirtualScreening_1,216,497)
    apply(VirtualScreening_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    PrepareReceptor_4 = VirtualScreening_1.macroNetwork.nodes[2]
    Pdb2pqrWS_7 = PrepareReceptor_4.macroNetwork.nodes[2]
    Pdb2pqrOpalService_ws_nbcr_net_11 = Pdb2pqrWS_7.macroNetwork.nodes[3]
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['noopt'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['phi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['psi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['verbose'].widget.set(1, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['chain'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['nodebump'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['chi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['ligand'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['hbond'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['with_ph'].widget.set(r"", run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['forcefield'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['forcefield'].widget.set(r"AMBER", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['clean'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['inId'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['apbs_input'].widget.set(0, run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['ffout'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['ffout'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['localRun'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['rama'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['execPath'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_11.inputPortByName['assign_only'].widget.set(0, run=False)
    GetURLFromList_12 = Pdb2pqrWS_7.macroNetwork.nodes[4]
    GetURLFromList_12.inputPortByName['ext'].widget.set(r"pqr", run=False)

    ## saving connections for network Pdb2pqrWS ##
    Pdb2pqrWS_7.macroNetwork.freeze()
    Pdb2pqrWS_7.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_8 = Pdb2pqrWS_7.macroNetwork.ipNode
    input_Ports_8.outputPorts[1].configure(name='CheckFileFormat_value')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_9 = Pdb2pqrWS_7.macroNetwork.opNode
    output_Ports_9.inputPorts[1].configure(singleConnection='auto')
    output_Ports_9.inputPorts[2].configure(singleConnection='auto')
    output_Ports_9.inputPorts[1].configure(name='UpdateReceptor_receptor_obj')
    output_Ports_9.inputPorts[2].configure(name='UpdateReceptor_pdb2pqr_result')
    Pdb2pqrWS_7.inputPorts[0].configure(name='CheckFileFormat_value')
    Pdb2pqrWS_7.inputPorts[0].configure(datatype='receptor')
    ## configure MacroNode input ports
    Pdb2pqrWS_7.outputPorts[0].configure(name='UpdateReceptor_receptor_obj')
    Pdb2pqrWS_7.outputPorts[0].configure(datatype='receptor')
    Pdb2pqrWS_7.outputPorts[1].configure(name='UpdateReceptor_pdb2pqr_result')
    Pdb2pqrWS_7.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    Pdb2pqrWS_7.shrink()
    PrepareReceptorWS_14 = PrepareReceptor_4.macroNetwork.nodes[3]
    PrepareReceptorOpalService_ws_nbcr_net_18 = PrepareReceptorWS_14.macroNetwork.nodes[3]
    PrepareReceptorOpalService_ws_nbcr_net_18.inputPortByName['o'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_18.inputPortByName['v'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_18.inputPortByName['localRun'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_18.inputPortByName['execPath'].widget.set(r"", run=False)
    GetURLFromList_19 = PrepareReceptorWS_14.macroNetwork.nodes[4]
    GetURLFromList_19.inputPortByName['ext'].widget.set(r"pdbqt", run=False)
    DownloadToFile_20 = PrepareReceptorWS_14.macroNetwork.nodes[5]
    DownloadToFile_20.inputPortByName['overwrite'].widget.set(1, run=False)

    ## saving connections for network PrepareReceptorWS ##
    PrepareReceptorWS_14.macroNetwork.freeze()
    PrepareReceptorWS_14.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_15 = PrepareReceptorWS_14.macroNetwork.ipNode
    input_Ports_15.outputPorts[1].configure(name='CheckFileFormat_value')
    input_Ports_15.outputPorts[2].configure(name='PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_16 = PrepareReceptorWS_14.macroNetwork.opNode
    output_Ports_16.inputPorts[1].configure(singleConnection='auto')
    output_Ports_16.inputPorts[2].configure(singleConnection='auto')
    output_Ports_16.inputPorts[1].configure(name='UpdateReceptor_receptor_prepared_obj')
    output_Ports_16.inputPorts[2].configure(name='UpdateReceptor_receptor_result')
    PrepareReceptorWS_14.inputPorts[0].configure(name='CheckFileFormat_value')
    PrepareReceptorWS_14.inputPorts[0].configure(datatype='receptor')
    PrepareReceptorWS_14.inputPorts[1].configure(name='PrepareReceptorOpalService_ws_nbcr_net_C')
    PrepareReceptorWS_14.inputPorts[1].configure(datatype='boolean')
    ## configure MacroNode input ports
    PrepareReceptorWS_14.outputPorts[0].configure(name='UpdateReceptor_receptor_prepared_obj')
    PrepareReceptorWS_14.outputPorts[0].configure(datatype='receptor_prepared')
    PrepareReceptorWS_14.outputPorts[1].configure(name='UpdateReceptor_receptor_result')
    PrepareReceptorWS_14.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    PrepareReceptorWS_14.shrink()

    ## saving connections for network PrepareReceptor ##
    PrepareReceptor_4.macroNetwork.freeze()
    PrepareReceptor_4.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_5 = PrepareReceptor_4.macroNetwork.ipNode
    input_Ports_5.outputPorts[1].configure(name='Pdb2pqrWS_CheckFileFormat_value')
    input_Ports_5.outputPorts[2].configure(name='PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_6 = PrepareReceptor_4.macroNetwork.opNode
    output_Ports_6.inputPorts[1].configure(singleConnection='auto')
    output_Ports_6.inputPorts[2].configure(singleConnection='auto')
    output_Ports_6.inputPorts[1].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj')
    output_Ports_6.inputPorts[2].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_result')
    PrepareReceptor_4.inputPorts[0].configure(name='Pdb2pqrWS_CheckFileFormat_value')
    PrepareReceptor_4.inputPorts[0].configure(datatype='receptor')
    PrepareReceptor_4.inputPorts[1].configure(name='PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')
    PrepareReceptor_4.inputPorts[1].configure(datatype='boolean')
    ## configure MacroNode input ports
    PrepareReceptor_4.outputPorts[0].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj')
    PrepareReceptor_4.outputPorts[0].configure(datatype='receptor_prepared')
    PrepareReceptor_4.outputPorts[1].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_result')
    PrepareReceptor_4.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    PrepareReceptor_4.shrink()
    ComputeGrids_22 = VirtualScreening_1.macroNetwork.nodes[3]
    prepareGPF_kryptonite_nbcr_net_26 = ComputeGrids_22.macroNetwork.nodes[3]
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['singlelib'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['r_url'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['zpoints'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['filter_file_url'].widget.set(r"", run=False)
    apply(prepareGPF_kryptonite_nbcr_net_26.inputPortByName['lib'].widget.configure, (), {'choices': ('sample', 'NCIDS_SC', 'NCI_DS1', 'NCI_DS2', 'oldNCI', 'human_metabolome', 'chembridge_building_blocks', 'drugbank_nutraceutics', 'drugbank_smallmol', 'fda_approved')})
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['lib'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['ypoints'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['xcenter'].widget.set(r"auto", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['p'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['o'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['zcenter'].widget.set(r"auto", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['v'].widget.set(0, run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['userlib'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['xpoints'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['localRun'].widget.set(0, run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['ycenter'].widget.set(r"auto", run=False)
    prepareGPF_kryptonite_nbcr_net_26.inputPortByName['execPath'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_27 = ComputeGrids_22.macroNetwork.nodes[4]
    autogrid_kryptonite_nbcr_net_27.inputPortByName['infile_url'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_27.inputPortByName['l'].widget.set(r"output.glg", run=False)
    autogrid_kryptonite_nbcr_net_27.inputPortByName['o'].widget.set(0, run=False)
    autogrid_kryptonite_nbcr_net_27.inputPortByName['p'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_27.inputPortByName['localRun'].widget.set(0, run=False)
    autogrid_kryptonite_nbcr_net_27.inputPortByName['execPath'].widget.set(r"", run=False)
    GetURLFromList_30 = ComputeGrids_22.macroNetwork.nodes[7]
    GetURLFromList_30.inputPortByName['ext'].widget.set(r"gpf", run=False)

    ## saving connections for network ComputeGrids ##
    ComputeGrids_22.macroNetwork.freeze()
    ComputeGrids_22.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_23 = ComputeGrids_22.macroNetwork.ipNode
    input_Ports_23.outputPorts[1].configure(name='GetComputeGridsInputs_ligands')
    input_Ports_23.outputPorts[2].configure(name='GetComputeGridsInputs_receptor_pdbqt')
    input_Ports_23.outputPorts[3].configure(name='GetComputeGridsInputs_gpf_obj')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_24 = ComputeGrids_22.macroNetwork.opNode
    output_Ports_24.inputPorts[1].configure(singleConnection='auto')
    output_Ports_24.inputPorts[2].configure(singleConnection='auto')
    output_Ports_24.inputPorts[1].configure(name='MakeAutogridResultObj_autogrid_result_obj')
    output_Ports_24.inputPorts[2].configure(name='GetMainURLFromList_newurl')
    ComputeGrids_22.inputPorts[0].configure(name='GetComputeGridsInputs_ligands')
    ComputeGrids_22.inputPorts[0].configure(datatype='LigandDB')
    ComputeGrids_22.inputPorts[1].configure(name='GetComputeGridsInputs_receptor_pdbqt')
    ComputeGrids_22.inputPorts[1].configure(datatype='receptor_prepared')
    ComputeGrids_22.inputPorts[2].configure(name='GetComputeGridsInputs_gpf_obj')
    ComputeGrids_22.inputPorts[2].configure(datatype='gpf_template')
    ## configure MacroNode input ports
    ComputeGrids_22.outputPorts[0].configure(name='MakeAutogridResultObj_autogrid_result_obj')
    ComputeGrids_22.outputPorts[0].configure(datatype='autogrid_results')
    ComputeGrids_22.outputPorts[1].configure(name='GetMainURLFromList_newurl')
    ComputeGrids_22.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    ComputeGrids_22.shrink()
    AutodockVS_31 = VirtualScreening_1.macroNetwork.nodes[4]
    autodock_kryptonite_nbcr_net_35 = AutodockVS_31.macroNetwork.nodes[3]
    autodock_kryptonite_nbcr_net_35.inputPortByName['ga_run'].widget.set(r"", run=False)
    apply(autodock_kryptonite_nbcr_net_35.inputPortByName['lib'].widget.configure, (), {'choices': ('sample', 'NCIDS_SC', 'NCI_DS1', 'NCI_DS2', 'human_metabolome', 'chembridge_building_blocks', 'drugbank_nutraceutics', 'drugbank_smallmol', 'fda_approved')})
    autodock_kryptonite_nbcr_net_35.inputPortByName['lib'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_35.inputPortByName['filter_file_url'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_35.inputPortByName['ga_num_evals'].widget.set(r"", run=False)
    apply(autodock_kryptonite_nbcr_net_35.inputPortByName['sched'].widget.configure, (), {'choices': ('SGE', 'CSF')})
    autodock_kryptonite_nbcr_net_35.inputPortByName['sched'].widget.set(r"SGE", run=False)
    autodock_kryptonite_nbcr_net_35.inputPortByName['ga_num_generations'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_35.inputPortByName['userlib'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_35.inputPortByName['ga_pop_size'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_35.inputPortByName['localRun'].widget.set(0, run=False)
    autodock_kryptonite_nbcr_net_35.inputPortByName['email'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_35.inputPortByName['execPath'].widget.set(r"", run=False)

    ## saving connections for network AutodockVS ##
    AutodockVS_31.macroNetwork.freeze()
    AutodockVS_31.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_32 = AutodockVS_31.macroNetwork.ipNode
    input_Ports_32.outputPorts[1].configure(name='PrepareADVSInputs_ligands')
    input_Ports_32.outputPorts[2].configure(name='PrepareADVSInputs_autogrid_results')
    input_Ports_32.outputPorts[3].configure(name='PrepareADVSInputs_dpf_template_obj')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_33 = AutodockVS_31.macroNetwork.opNode
    output_Ports_33.inputPorts[1].configure(singleConnection='auto')
    output_Ports_33.inputPorts[1].configure(name='GetMainURLFromList_newurl')
    AutodockVS_31.inputPorts[0].configure(name='PrepareADVSInputs_ligands')
    AutodockVS_31.inputPorts[0].configure(datatype='LigandDB')
    AutodockVS_31.inputPorts[1].configure(name='PrepareADVSInputs_autogrid_results')
    AutodockVS_31.inputPorts[1].configure(datatype='autogrid_results')
    AutodockVS_31.inputPorts[2].configure(name='PrepareADVSInputs_dpf_template_obj')
    AutodockVS_31.inputPorts[2].configure(datatype='dpf_template')
    ## configure MacroNode input ports
    AutodockVS_31.outputPorts[0].configure(name='GetMainURLFromList_newurl')
    AutodockVS_31.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    AutodockVS_31.shrink()

    ## saving connections for network VirtualScreening ##
    VirtualScreening_1.macroNetwork.freeze()
    VirtualScreening_1.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_2 = VirtualScreening_1.macroNetwork.ipNode
    input_Ports_2.outputPorts[1].configure(name='PrepareReceptor_Pdb2pqrWS_CheckFileFormat_value')
    input_Ports_2.outputPorts[2].configure(name='ComputeGrids_GetComputeGridsInputs_ligands')
    input_Ports_2.outputPorts[3].configure(name='ComputeGrids_GetComputeGridsInputs_gpf_obj')
    input_Ports_2.outputPorts[4].configure(name='AutodockVS_PrepareADVSInputs_dpf_template_obj')
    input_Ports_2.outputPorts[5].configure(name='PrepareReceptor_PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_3 = VirtualScreening_1.macroNetwork.opNode
    output_Ports_3.inputPorts[1].configure(singleConnection='auto')
    output_Ports_3.inputPorts[1].configure(name='AutodockVS_GetMainURLFromList_newurl')
    VirtualScreening_1.inputPorts[0].configure(name='PrepareReceptor_Pdb2pqrWS_CheckFileFormat_value')
    VirtualScreening_1.inputPorts[0].configure(datatype='receptor')
    VirtualScreening_1.inputPorts[1].configure(name='ComputeGrids_GetComputeGridsInputs_ligands')
    VirtualScreening_1.inputPorts[1].configure(datatype='LigandDB')
    VirtualScreening_1.inputPorts[2].configure(name='ComputeGrids_GetComputeGridsInputs_gpf_obj')
    VirtualScreening_1.inputPorts[2].configure(datatype='gpf_template')
    VirtualScreening_1.inputPorts[3].configure(name='AutodockVS_PrepareADVSInputs_dpf_template_obj')
    VirtualScreening_1.inputPorts[3].configure(datatype='dpf_template')
    VirtualScreening_1.inputPorts[4].configure(name='PrepareReceptor_PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')
    VirtualScreening_1.inputPorts[4].configure(datatype='boolean')
    ## configure MacroNode input ports
    VirtualScreening_1.outputPorts[0].configure(name='AutodockVS_GetMainURLFromList_newurl')
    VirtualScreening_1.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    VirtualScreening_1.shrink()
    apply(VirtualScreening_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore VirtualScreening named VirtualScreening in network masterNet"
    print_exc()
    VirtualScreening_1=None

try:
    ## saving node FilterLigandsNode ##
    from Adt.Filter.filterLigands import FilterLigandsNode
    FilterLigandsNode_37 = FilterLigandsNode(constrkw={}, name='FilterLigandsNode', library=Adt)
    masterNet.addNode(FilterLigandsNode_37,704,203)
    FilterLigandsNode_37.inputPortByName['filterMode'].widget.set(r"default", run=False)
    FilterLigandsNode_37.inputPortByName['hbd_min'].widget.set(0, run=False)
    FilterLigandsNode_37.inputPortByName['hbd_max'].widget.set(99, run=False)
    FilterLigandsNode_37.inputPortByName['hba_min'].widget.set(0, run=False)
    FilterLigandsNode_37.inputPortByName['hba_max'].widget.set(99, run=False)
    FilterLigandsNode_37.inputPortByName['mw_min'].widget.set(0, run=False)
    FilterLigandsNode_37.inputPortByName['mw_max'].widget.set(9999, run=False)
    FilterLigandsNode_37.inputPortByName['nat_min'].widget.set(0, run=False)
    FilterLigandsNode_37.inputPortByName['nat_max'].widget.set(999, run=False)
    FilterLigandsNode_37.inputPortByName['torsdof_min'].widget.set(0, run=False)
    FilterLigandsNode_37.inputPortByName['torsdof_max'].widget.set(32, run=False)
    apply(FilterLigandsNode_37.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FilterLigandsNode named FilterLigandsNode in network masterNet"
    print_exc()
    FilterLigandsNode_37=None

try:
    ## saving node PreserveCharges? ##
    from Vision.StandardNodes import CheckButtonNE
    PreserveCharges__38 = CheckButtonNE(constrkw={}, name='PreserveCharges?', library=stdlib)
    masterNet.addNode(PreserveCharges__38,973,38)
    PreserveCharges__38.inputPortByName['button'].widget.set(1, run=False)
    apply(PreserveCharges__38.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore CheckButtonNE named PreserveCharges? in network masterNet"
    print_exc()
    PreserveCharges__38=None

try:
    ## saving node DownloadSaveDir ##
    from WebServices.VisionInterface.WSNodes import DownloadSaveDirNode
    DownloadSaveDir_39 = DownloadSaveDirNode(constrkw={}, name='DownloadSaveDir', library=wslib)
    masterNet.addNode(DownloadSaveDir_39,170,558)
    apply(DownloadSaveDir_39.inputPortByName['url'].configure, (), {'defaultValue': None})
    DownloadSaveDir_39.inputPortByName['url'].rebindWidget()
    DownloadSaveDir_39.inputPortByName['url'].widget.set(r"", run=False)
    DownloadSaveDir_39.inputPortByName['url'].unbindWidget()
    apply(DownloadSaveDir_39.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DownloadSaveDirNode named DownloadSaveDir in network masterNet"
    print_exc()
    DownloadSaveDir_39=None

try:
    ## saving node GetStructuresFromDir ##
    from Adt.Input.GetStructuresFromDir import GetStructuresFromDir
    GetStructuresFromDir_40 = GetStructuresFromDir(constrkw={}, name='GetStructuresFromDir', library=Adt)
    masterNet.addNode(GetStructuresFromDir_40,16,22)
    GetStructuresFromDir_40.inputPortByName['directory'].widget.set(r"AutoDockVSlocal_0.1_input", run=False)
    apply(GetStructuresFromDir_40.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore GetStructuresFromDir named GetStructuresFromDir in network masterNet"
    print_exc()
    GetStructuresFromDir_40=None

try:
    ## saving node InputValidation ##
    from Adt.Mapper.InputValidation import InputValidation
    InputValidation_41 = InputValidation(constrkw={}, name='InputValidation', library=Adt)
    masterNet.addNode(InputValidation_41,86,318)
    apply(InputValidation_41.addInputPort, (), {'singleConnection': True, 'name': 'outdir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    code = """def doit(self, receptor_obj, outdir):
        import os
        from AutoDockTools.VisionInterface.Adt.receptor import receptor
        from AutoDockTools.VisionInterface.Adt.dpf_template import dpf_template
        from AutoDockTools.VisionInterface.Adt.gpf_template import gpf_template

        receptor_id = receptor_obj.get_id()
        receptor_dir = receptor_obj.get_workdir() 

        gpf_file = receptor_dir + os.sep + receptor_id + '''.gpf'''
        dpf_file = receptor_dir + os.sep + receptor_id + '''.dpf'''
        GPF_template = gpf_template(gpf_file)
        DPF_template = dpf_template(dpf_file)
        #result_dir = os.path.abspath(receptor_dir + os.sep + '''..''' + os.sep + receptor_id)
        result_dir = os.path.join(outdir, receptor_id)

        if not(os.path.exists(gpf_file)):
            print "ERROR: GPF template " + gpf_file + " does not exist!"
            return '''stop'''
        elif not(os.path.exists(dpf_file)):
            print "ERROR: DPF template " + dpf_file + " does not exist!"
            return '''stop'''

        pdbqt_loc = receptor_obj.get_ext_loc('''pdbqt''')
        pqr_loc = receptor_obj.get_ext_loc('''pqr''')
        pdb_loc = receptor_obj.get_ext_loc('''pdb''')
            
        if pdbqt_loc == None and pqr_loc == None and pdb_loc == None:
            print "ERROR: No valid structure file found, none of the following exist"
            print "    " + pdbqt_loc + ", " + pqr_loc + ", " + pdb_loc
            return '''stop'''
        
        print "-------------------------------------------------------"
        print "     INPUTS THAT WILL BE USED FOR VIRTUAL SCREENING    "
        print "GPF Template:                  " + GPF_template.fullpath
        print "DPF Template:                  " + DPF_template.fullpath
        print "Results will be downloaded to: " + result_dir
        print "-------------------------------------------------------"
        
        pass
        self.outputData(GPF_template=GPF_template, DPF_template=DPF_template, result_dir=result_dir)



"""
    InputValidation_41.configure(function=code)
    apply(InputValidation_41.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore InputValidation named InputValidation in network masterNet"
    print_exc()
    InputValidation_41=None

try:
    ## saving node LocalLigandDirectory ##
    from Adt.Input.LocalLigandDirectory import LocalLigandDirectory
    LocalLigandDirectory_42 = LocalLigandDirectory(constrkw={}, name='LocalLigandDirectory', library=Adt)
    masterNet.addNode(LocalLigandDirectory_42,704,142)
    apply(LocalLigandDirectory_42.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    Entry_46 = LocalLigandDirectory_42.macroNetwork.nodes[3]
    Entry_46.inputPortByName['entry'].widget.set(r"my_ligands.zip", run=False)
    LigandDBUpload_kryptonite_nbcr_net_47 = LocalLigandDirectory_42.macroNetwork.nodes[4]
    LigandDBUpload_kryptonite_nbcr_net_47.inputPortByName['username'].widget.set(r"", run=False)
    LigandDBUpload_kryptonite_nbcr_net_47.inputPortByName['password'].widget.set(r"", run=False)
    LigandDBUpload_kryptonite_nbcr_net_47.inputPortByName['localRun'].widget.set(0, run=False)
    LigandDBUpload_kryptonite_nbcr_net_47.inputPortByName['execPath'].widget.set(r"", run=False)
    LigandDBUpload_kryptonite_nbcr_net_47.inputPortByName['desc'].widget.set(r"", run=False)
    Index_48 = LocalLigandDirectory_42.macroNetwork.nodes[5]
    apply(Index_48.inputPortByName['index'].widget.configure, (), {'max': 11, 'min': -12})
    Index_48.inputPortByName['index'].widget.set(0, run=False)

    ## saving connections for network LocalLigandDirectory ##
    LocalLigandDirectory_42.macroNetwork.freeze()
    LocalLigandDirectory_42.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_43 = LocalLigandDirectory_42.macroNetwork.ipNode
    input_Ports_43.outputPorts[1].configure(name='Make_Zip_File_input_directory')
    input_Ports_43.outputPorts[2].configure(name='CreateLigandDBObj_log_file')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_44 = LocalLigandDirectory_42.macroNetwork.opNode
    output_Ports_44.inputPorts[1].configure(singleConnection='auto')
    output_Ports_44.inputPorts[2].configure(singleConnection='auto')
    output_Ports_44.inputPorts[1].configure(name='CreateLigandDBObj_ligand_db_obj')
    output_Ports_44.inputPorts[2].configure(name='ReplaceURL_newurl')
    LocalLigandDirectory_42.inputPorts[0].configure(name='Make_Zip_File_input_directory')
    LocalLigandDirectory_42.inputPorts[0].configure(datatype='string')
    LocalLigandDirectory_42.inputPorts[1].configure(name='CreateLigandDBObj_log_file')
    LocalLigandDirectory_42.inputPorts[1].configure(datatype='string')
    ## configure MacroNode input ports
    LocalLigandDirectory_42.outputPorts[0].configure(name='CreateLigandDBObj_ligand_db_obj')
    LocalLigandDirectory_42.outputPorts[0].configure(datatype='LigandDB')
    LocalLigandDirectory_42.outputPorts[1].configure(name='ReplaceURL_newurl')
    LocalLigandDirectory_42.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    LocalLigandDirectory_42.shrink()
    apply(LocalLigandDirectory_42.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore LocalLigandDirectory named LocalLigandDirectory in network masterNet"
    print_exc()
    LocalLigandDirectory_42=None

try:
    ## saving node Local Ligand Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Local_Ligand_Directory_Browser_52 = DirBrowserNE(constrkw={}, name='Local Ligand Directory Browser', library=stdlib)
    masterNet.addNode(Local_Ligand_Directory_Browser_52,704,28)
    Local_Ligand_Directory_Browser_52.inputPortByName['directory'].widget.set(r"AutoDockVSlocal_0.1_input/ligands", run=False)
    apply(Local_Ligand_Directory_Browser_52.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Local Ligand Directory Browser in network masterNet"
    print_exc()
    Local_Ligand_Directory_Browser_52=None

try:
    ## saving node Output Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Output_Directory_Browser_53 = DirBrowserNE(constrkw={}, name='Output Directory Browser', library=stdlib)
    masterNet.addNode(Output_Directory_Browser_53,412,28)
    Output_Directory_Browser_53.inputPortByName['directory'].widget.set(r"AutoDockVSlocal_0.1_output", run=False)
    apply(Output_Directory_Browser_53.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Output Directory Browser in network masterNet"
    print_exc()
    Output_Directory_Browser_53=None

#masterNet.run()
masterNet.freeze()

## saving connections for network AutoDockVSlocal_0.1 ##
if FilterLigandsNode_37 is not None and VirtualScreening_1 is not None:
    try:
        masterNet.connectNodes(
            FilterLigandsNode_37, VirtualScreening_1, "ligands", "ComputeGrids_GetComputeGridsInputs_ligands", blocking=True
            , splitratio=[0.37455111543238506, 0.32420948165762498])
    except:
        print "WARNING: failed to restore connection between FilterLigandsNode_37 and VirtualScreening_1 in network masterNet"
if PreserveCharges__38 is not None and VirtualScreening_1 is not None:
    try:
        masterNet.connectNodes(
            PreserveCharges__38, VirtualScreening_1, "value_bool", "PrepareReceptor_PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C", blocking=True
            , splitratio=[0.26471965480569831, 0.73857142767746442])
    except:
        print "WARNING: failed to restore connection between PreserveCharges__38 and VirtualScreening_1 in network masterNet"
if VirtualScreening_1 is not None and DownloadSaveDir_39 is not None:
    try:
        masterNet.connectNodes(
            VirtualScreening_1, DownloadSaveDir_39, "AutodockVS_GetMainURLFromList_newurl", "url", blocking=True
            , splitratio=[0.74808619960402778, 0.23329088335740467])
    except:
        print "WARNING: failed to restore connection between VirtualScreening_1 and DownloadSaveDir_39 in network masterNet"
if GetStructuresFromDir_40 is not None and iterate_0 is not None:
    try:
        masterNet.connectNodes(
            GetStructuresFromDir_40, iterate_0, "structure_list_obj", "listToLoopOver", blocking=True
            , splitratio=[0.64404900652669483, 0.66433287135542574])
    except:
        print "WARNING: failed to restore connection between GetStructuresFromDir_40 and iterate_0 in network masterNet"
if iterate_0 is not None and VirtualScreening_1 is not None:
    try:
        masterNet.connectNodes(
            iterate_0, VirtualScreening_1, "oneItem", "PrepareReceptor_Pdb2pqrWS_CheckFileFormat_value", blocking=True
            , splitratio=[0.24975750410316327, 0.47366759074690934])
    except:
        print "WARNING: failed to restore connection between iterate_0 and VirtualScreening_1 in network masterNet"
if iterate_0 is not None and InputValidation_41 is not None:
    try:
        masterNet.connectNodes(
            iterate_0, InputValidation_41, "oneItem", "recpetor_obj", blocking=True
            , splitratio=[0.58378184959869772, 0.29053011237456339])
    except:
        print "WARNING: failed to restore connection between iterate_0 and InputValidation_41 in network masterNet"
if InputValidation_41 is not None and VirtualScreening_1 is not None:
    try:
        masterNet.connectNodes(
            InputValidation_41, VirtualScreening_1, "GPF_template", "ComputeGrids_GetComputeGridsInputs_gpf_obj", blocking=True
            , splitratio=[0.63709387814855534, 0.40809312341502446])
    except:
        print "WARNING: failed to restore connection between InputValidation_41 and VirtualScreening_1 in network masterNet"
if InputValidation_41 is not None and VirtualScreening_1 is not None:
    try:
        masterNet.connectNodes(
            InputValidation_41, VirtualScreening_1, "DPF_template", "AutodockVS_PrepareADVSInputs_dpf_template_obj", blocking=True
            , splitratio=[0.50008775545983264, 0.21584255901641733])
    except:
        print "WARNING: failed to restore connection between InputValidation_41 and VirtualScreening_1 in network masterNet"
if InputValidation_41 is not None and DownloadSaveDir_39 is not None:
    try:
        masterNet.connectNodes(
            InputValidation_41, DownloadSaveDir_39, "result_dir", "path", blocking=True
            , splitratio=[0.32102505593374198, 0.64313754588560501])
    except:
        print "WARNING: failed to restore connection between InputValidation_41 and DownloadSaveDir_39 in network masterNet"
if LocalLigandDirectory_42 is not None and FilterLigandsNode_37 is not None:
    try:
        masterNet.connectNodes(
            LocalLigandDirectory_42, FilterLigandsNode_37, "CreateLigandDBObj_ligand_db_obj", "ligands", blocking=True
            , splitratio=[0.2539752105242804, 0.32318874205898473])
    except:
        print "WARNING: failed to restore connection between LocalLigandDirectory_42 and FilterLigandsNode_37 in network masterNet"
if Local_Ligand_Directory_Browser_52 is not None and LocalLigandDirectory_42 is not None:
    try:
        masterNet.connectNodes(
            Local_Ligand_Directory_Browser_52, LocalLigandDirectory_42, "directory", "Make_Zip_File_input_directory", blocking=True
            , splitratio=[0.44330538430270433, 0.3169004421712448])
    except:
        print "WARNING: failed to restore connection between Local_Ligand_Directory_Browser_52 and LocalLigandDirectory_42 in network masterNet"
if Output_Directory_Browser_53 is not None and InputValidation_41 is not None:
    try:
        masterNet.connectNodes(
            Output_Directory_Browser_53, InputValidation_41, "AbsPath_directory", "outdir", blocking=True
            , splitratio=[0.60294783275493224, 0.44484881377759378])
    except:
        print "WARNING: failed to restore connection between Output_Directory_Browser_53 and InputValidation_41 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

