#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 24 February 2011 03:10:56 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/CADD/workflows/docking/PrepareReceptor_0.1_net.py,v 1.1 2011/04/15 16:16:49 nadya Exp $
#
# $Id: PrepareReceptor_0.1_net.py,v 1.1 2011/04/15 16:16:49 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from AutoDockTools.VisionInterface.Adt import Adt
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(Adt,"AutoDockTools.VisionInterface.Adt", "Adt")

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://ws.nbcr.net/opal2", replace=False)
except:
    pass
try:
    ## saving node PrepareReceptor2 ##
    from Adt.Macro.PrepareReceptor import PrepareReceptor
    PrepareReceptor2_0 = PrepareReceptor(constrkw={}, name='PrepareReceptor2', library=Adt)
    masterNet.addNode(PrepareReceptor2_0,301,206)
    apply(PrepareReceptor2_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    Pdb2pqrWS_3 = PrepareReceptor2_0.macroNetwork.nodes[2]
    Pdb2pqrOpalService_ws_nbcr_net_7 = Pdb2pqrWS_3.macroNetwork.nodes[3]
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['noopt'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['phi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['psi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['verbose'].widget.set(1, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['chain'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['nodebump'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['chi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['ligand'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['hbond'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['with_ph'].widget.set(r"", run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['forcefield'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['forcefield'].widget.set(r"AMBER", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['clean'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['inId'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['apbs_input'].widget.set(0, run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['ffout'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['ffout'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['localRun'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['rama'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['execPath'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_7.inputPortByName['assign_only'].widget.set(0, run=False)
    GetURLFromList_8 = Pdb2pqrWS_3.macroNetwork.nodes[4]
    GetURLFromList_8.inputPortByName['ext'].widget.set(r"pqr", run=False)

    ## saving connections for network Pdb2pqrWS ##
    Pdb2pqrWS_3.macroNetwork.freeze()
    Pdb2pqrWS_3.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_4 = Pdb2pqrWS_3.macroNetwork.ipNode
    input_Ports_4.outputPorts[1].configure(name='CheckFileFormat_value')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_5 = Pdb2pqrWS_3.macroNetwork.opNode
    output_Ports_5.inputPorts[1].configure(singleConnection='auto')
    output_Ports_5.inputPorts[2].configure(singleConnection='auto')
    output_Ports_5.inputPorts[1].configure(name='UpdateReceptor_receptor_obj')
    output_Ports_5.inputPorts[2].configure(name='UpdateReceptor_pdb2pqr_result')
    Pdb2pqrWS_3.inputPorts[0].configure(name='CheckFileFormat_value')
    Pdb2pqrWS_3.inputPorts[0].configure(datatype='receptor')
    ## configure MacroNode input ports
    Pdb2pqrWS_3.outputPorts[0].configure(name='UpdateReceptor_receptor_obj')
    Pdb2pqrWS_3.outputPorts[0].configure(datatype='receptor')
    Pdb2pqrWS_3.outputPorts[1].configure(name='UpdateReceptor_pdb2pqr_result')
    Pdb2pqrWS_3.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    Pdb2pqrWS_3.shrink()
    PrepareReceptorWS_10 = PrepareReceptor2_0.macroNetwork.nodes[3]
    PrepareReceptorOpalService_ws_nbcr_net_14 = PrepareReceptorWS_10.macroNetwork.nodes[3]
    PrepareReceptorOpalService_ws_nbcr_net_14.inputPortByName['o'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_14.inputPortByName['v'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_14.inputPortByName['localRun'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_14.inputPortByName['execPath'].widget.set(r"", run=False)
    GetURLFromList_15 = PrepareReceptorWS_10.macroNetwork.nodes[4]
    GetURLFromList_15.inputPortByName['ext'].widget.set(r"pdbqt", run=False)
    DownloadToFile_16 = PrepareReceptorWS_10.macroNetwork.nodes[5]
    DownloadToFile_16.inputPortByName['overwrite'].widget.set(1, run=False)

    ## saving connections for network PrepareReceptorWS ##
    PrepareReceptorWS_10.macroNetwork.freeze()
    PrepareReceptorWS_10.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_11 = PrepareReceptorWS_10.macroNetwork.ipNode
    input_Ports_11.outputPorts[1].configure(name='CheckFileFormat_value')
    input_Ports_11.outputPorts[2].configure(name='PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_12 = PrepareReceptorWS_10.macroNetwork.opNode
    output_Ports_12.inputPorts[1].configure(singleConnection='auto')
    output_Ports_12.inputPorts[2].configure(singleConnection='auto')
    output_Ports_12.inputPorts[1].configure(name='UpdateReceptor_receptor_prepared_obj')
    output_Ports_12.inputPorts[2].configure(name='UpdateReceptor_receptor_result')
    PrepareReceptorWS_10.inputPorts[0].configure(name='CheckFileFormat_value')
    PrepareReceptorWS_10.inputPorts[0].configure(datatype='receptor')
    PrepareReceptorWS_10.inputPorts[1].configure(name='PrepareReceptorOpalService_ws_nbcr_net_C')
    PrepareReceptorWS_10.inputPorts[1].configure(datatype='boolean')
    ## configure MacroNode input ports
    PrepareReceptorWS_10.outputPorts[0].configure(name='UpdateReceptor_receptor_prepared_obj')
    PrepareReceptorWS_10.outputPorts[0].configure(datatype='receptor_prepared')
    PrepareReceptorWS_10.outputPorts[1].configure(name='UpdateReceptor_receptor_result')
    PrepareReceptorWS_10.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    PrepareReceptorWS_10.shrink()

    ## saving connections for network PrepareReceptor2 ##
    PrepareReceptor2_0.macroNetwork.freeze()
    PrepareReceptor2_0.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_1 = PrepareReceptor2_0.macroNetwork.ipNode
    input_Ports_1.outputPorts[1].configure(name='Pdb2pqrWS_CheckFileFormat_value')
    input_Ports_1.outputPorts[2].configure(name='PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_2 = PrepareReceptor2_0.macroNetwork.opNode
    output_Ports_2.inputPorts[1].configure(singleConnection='auto')
    output_Ports_2.inputPorts[2].configure(singleConnection='auto')
    output_Ports_2.inputPorts[1].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj')
    output_Ports_2.inputPorts[2].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_result')
    PrepareReceptor2_0.inputPorts[0].configure(name='Pdb2pqrWS_CheckFileFormat_value')
    PrepareReceptor2_0.inputPorts[0].configure(datatype='receptor')
    PrepareReceptor2_0.inputPorts[1].configure(name='PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C')
    PrepareReceptor2_0.inputPorts[1].configure(datatype='boolean')
    ## configure MacroNode input ports
    PrepareReceptor2_0.outputPorts[0].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_prepared_obj')
    PrepareReceptor2_0.outputPorts[0].configure(datatype='receptor_prepared')
    PrepareReceptor2_0.outputPorts[1].configure(name='PrepareReceptorWS_UpdateReceptor_receptor_result')
    PrepareReceptor2_0.outputPorts[1].configure(datatype='string')
    ## configure MacroNode output ports
    PrepareReceptor2_0.shrink()
    apply(PrepareReceptor2_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore PrepareReceptor named PrepareReceptor2 in network masterNet"
    print_exc()
    PrepareReceptor2_0=None

try:
    ## saving node StructureBrowser ##
    from Adt.Input.StructureBrowser import StructureBrowser
    StructureBrowser_18 = StructureBrowser(constrkw={}, name='StructureBrowser', library=Adt)
    masterNet.addNode(StructureBrowser_18,52,43)
    StructureBrowser_18.inputPortByName['receptor_file'].widget.set(r"PrepareReceptor_0.1_input/2HTY_A.pdb", run=False)
    apply(StructureBrowser_18.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore StructureBrowser named StructureBrowser in network masterNet"
    print_exc()
    StructureBrowser_18=None

try:
    ## saving node Preserve charges? ##
    from Vision.StandardNodes import CheckButtonNE
    Preserve_charges__19 = CheckButtonNE(constrkw={}, name='Preserve charges?', library=stdlib)
    masterNet.addNode(Preserve_charges__19,458,43)
    Preserve_charges__19.inputPortByName['button'].widget.set(0, run=False)
    apply(Preserve_charges__19.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore CheckButtonNE named Preserve charges? in network masterNet"
    print_exc()
    Preserve_charges__19=None

try:
    ## saving node SaveReceptor ##
    from Vision.StandardNodes import Generic
    SaveReceptor_20 = Generic(constrkw={}, name='SaveReceptor', library=stdlib)
    masterNet.addNode(SaveReceptor_20,424,278)
    apply(SaveReceptor_20.addInputPort, (), {'singleConnection': True, 'name': 'r', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(SaveReceptor_20.addInputPort, (), {'singleConnection': True, 'name': 'outdir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(SaveReceptor_20.addOutputPort, (), {'name': 'outdir', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, r, outdir):
        outfile = os.path.join(outdir, os.path.basename(r))
        if (r.startswith("http://")):
            import urllib
            opener = urllib.FancyURLopener({})
            in_file = opener.open(r)
            f = open(filename, '''w''')
            f.write(in_file.read())
            f.close()
        else:
            import shutil
            shutil.copy (r, outfile)
        
	pass
## to ouput data on port outdir use
        self.outputData(outdir=outfile)



"""
    SaveReceptor_20.configure(function=code)
    apply(SaveReceptor_20.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named SaveReceptor in network masterNet"
    print_exc()
    SaveReceptor_20=None

try:
    ## saving node Output Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Output_Directory_Browser_21 = DirBrowserNE(constrkw={}, name='Output Directory Browser', library=stdlib)
    masterNet.addNode(Output_Directory_Browser_21,638,46)
    Output_Directory_Browser_21.inputPortByName['directory'].widget.set(r"PrepareReceptor_0.1_output", run=False)
    apply(Output_Directory_Browser_21.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Output Directory Browser in network masterNet"
    print_exc()
    Output_Directory_Browser_21=None

#masterNet.run()
masterNet.freeze()

## saving connections for network PrepareReceptor-0.1 ##
if StructureBrowser_18 is not None and PrepareReceptor2_0 is not None:
    try:
        masterNet.connectNodes(
            StructureBrowser_18, PrepareReceptor2_0, "receptor_obj", "Pdb2pqrWS_CheckFileFormat_value", blocking=True
            , splitratio=[0.51287662428234593, 0.74658029742646814])
    except:
        print "WARNING: failed to restore connection between StructureBrowser_18 and PrepareReceptor2_0 in network masterNet"
if Preserve_charges__19 is not None and PrepareReceptor2_0 is not None:
    try:
        masterNet.connectNodes(
            Preserve_charges__19, PrepareReceptor2_0, "value_bool", "PrepareReceptorWS_PrepareReceptorOpalService_ws_nbcr_net_C", blocking=True
            , splitratio=[0.44734707960554609, 0.37373648392115422])
    except:
        print "WARNING: failed to restore connection between Preserve_charges__19 and PrepareReceptor2_0 in network masterNet"
if PrepareReceptor2_0 is not None and SaveReceptor_20 is not None:
    try:
        masterNet.connectNodes(
            PrepareReceptor2_0, SaveReceptor_20, "PrepareReceptorWS_UpdateReceptor_receptor_result", "r", blocking=True
            , splitratio=[0.38815590219305951, 0.71363867512527479])
    except:
        print "WARNING: failed to restore connection between PrepareReceptor2_0 and SaveReceptor_20 in network masterNet"
if Output_Directory_Browser_21 is not None and SaveReceptor_20 is not None:
    try:
        masterNet.connectNodes(
            Output_Directory_Browser_21, SaveReceptor_20, "AbsPath_directory", "outdir", blocking=True
            , splitratio=[0.32372299779158487, 0.59979789316638676])
    except:
        print "WARNING: failed to restore connection between Output_Directory_Browser_21 and SaveReceptor_20 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

