########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 08 February 2006 09:22:09 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/WebServices/Examples/viperdb_net.py,v 1.2 2006/02/08 17:37:01 sargis Exp $
#
# $Id: viperdb_net.py,v 1.2 2006/02/08 17:37:01 sargis Exp $
#

from traceback import print_exc

## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

from symserv.VisionInterface.SymservNodes import symlib
masterNet.getEditor().addLibraryInstance(symlib,"symserv.VisionInterface.SymservNodes", "symlib")

from WebServices.VisionInterface.WSNodes import wslib
masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:

    ## saving node Save Lines ##
    from Vision.StandardNodes import SaveLines
    Save_Lines_0 = SaveLines(constrkw = {}, name='Save Lines', library=stdlib)
    masterNet.addNode(Save_Lines_0,25,112)
    Save_Lines_0.inputPortByName['filename'].widget.set("2plv.pdb", run=False)
except:
    print "WARNING: failed to restore SaveLines named Save Lines in network masterNet"
    print_exc()
    Save_Lines_0=None
try:

    ## saving node Pmv ##
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_1 = PmvNode(vf=masterNet.editor.vf, constrkw = {'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    masterNet.addNode(Pmv_1,231,8)
except:
    print "WARNING: failed to restore PmvNode named Pmv in network masterNet"
    print_exc()
    Pmv_1=None
try:

    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_2 = PmvChooseCommand(constrkw = {}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_2,231,92)
    apply(Choose_Cmd_2.inputPortByName['cmdName'].widget.configure, (), {'choices': ['readPDB']})
    Choose_Cmd_2.inputPortByName['cmdName'].widget.set("readPDB", run=False)
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_2=None
try:

    ## saving node Run readPDB ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_readPDB_3 = PmvRunCommand(sortedArgNames=['topCommand', 'redraw', 'setupUndo', 'log'], command=masterNet.editor.vf.readPDB, namedArgs={'topCommand': True, 'redraw': True, 'setupUndo': True, 'log': True}, posArgsNames=['filename'], constrkw = {'sortedArgNames': "['topCommand', 'redraw', 'setupUndo', 'log']", 'command': 'masterNet.editor.vf.readPDB', 'namedArgs': "{'topCommand': True, 'redraw': True, 'setupUndo': True, 'log': True}", 'posArgsNames': "['filename']"}, name='Run readPDB', library=pmvlib)
    masterNet.addNode(Run_readPDB_3,231,175)
    apply(Run_readPDB_3.addInputPort, (), {'name': 'filename', 'cast': True, 'datatype': 'string', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Run_readPDB_3.addInputPort, (), {'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 10, 'width': 10, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_readPDB_3.addInputPort, (), {'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 10, 'width': 10, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_readPDB_3.addInputPort, (), {'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 10, 'width': 10, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_readPDB_3.addInputPort, (), {'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 10, 'width': 10, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_readPDB_3.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    apply(Run_readPDB_3.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    apply(Run_readPDB_3.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    apply(Run_readPDB_3.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    code = """




def doit(self, command, filename, topCommand, redraw, setupUndo, log):
    if command is None:
        return
    if command is not self.command and command is not None:
        # remember current command
        self.command = command
        self.rename('Run '+command.name)
        
        # remove all ports beyond the command input port
        for p in self.inputPorts[1:]:
            self.deletePort(p, updateSignature=False)

        # get arguments description
        from inspect import getargspec
        args = getargspec(command.__call__.im_func)
        allNames = args[0][1:] # get rid of self
        defaultValues = args[3]
        if defaultValues is None:
            defaultValues = []
        nbNamesArgs = len(defaultValues)
        if nbNamesArgs > 0:
            self.posArgsNames = args[0][1:-nbNamesArgs]
        else:
            self.posArgsNames = args[0][1:]
        d = {}
        for name, val in zip(args[0][-nbNamesArgs:], defaultValues):
            d[name] = val
        for name, val in zip(self.defaultNamedArgs, self.defaultNamedArgsdefaults):
            d[name] = val

        self.namedArgs = d

        # create input ports for positional arguments
        self.createPortsForPositionalArgs(self.posArgsNames)

        # create widgets and ports for named arguments
        self.sortedArgNames = self.buildPortsForNamedArgs(self.namedArgs)

        # create the constructor arguments such that when the node is restored
        # from file it will have all the info it needs
        self.constrkw['command'] = 'masterNet.editor.vf.%s'%command.name
        self.constrkw['posArgsNames'] = str(self.posArgsNames)
        self.constrkw['namedArgs'] = str(self.namedArgs)
        self.constrkw['sortedArgNames'] = str(self.sortedArgNames)
        
    elif self.command is not None:
        # get all positional arguments
        posargs = []
        for pn in self.posArgsNames:
            posargs.append(locals()[pn])

        # build named arguments
        kw = {}
        for arg in self.sortedArgNames:
            kw[arg] = locals()[arg]

        # call command
        value = apply( self.command.__call__, posargs, kw )

        self.outputData(result=value)
"""
    Run_readPDB_3.configure(function=code)
except:
    print "WARNING: failed to restore PmvRunCommand named Run readPDB in network masterNet"
    print_exc()
    Run_readPDB_3=None
try:

    ## saving node Set Instances ##
    from Pmv.VisionInterface.PmvNodes import PmvSetInstanceMatrices
    Set_Instances_4 = PmvSetInstanceMatrices(constrkw = {}, name='Set Instances', library=pmvlib)
    masterNet.addNode(Set_Instances_4,233,252)
except:
    print "WARNING: failed to restore PmvSetInstanceMatrices named Set Instances in network masterNet"
    print_exc()
    Set_Instances_4=None
try:

    ## saving node Icosahedral ##
    from symserv.VisionInterface.SymservNodes import Icos1
    Icosahedral_5 = Icos1(constrkw = {}, name='Icosahedral', library=symlib)
    masterNet.addNode(Icosahedral_5,372,177)

    ## saving connections for network Icosahedral ##
    Icosahedral_5.macroNetwork.freeze()
    Icosahedral_5.macroNetwork.unfreeze()

    ## modifying MacroOutputNode dynamic ports
    output_Ports_7 = Icosahedral_5.macroNetwork.opNode
    output_Ports_7.inputPorts[1].configure(singleConnection=True)
    Icosahedral_5.shrink()
except:
    print "WARNING: failed to restore Icos1 named Icosahedral in network masterNet"
    print_exc()
    Icosahedral_5=None
try:

    ## saving node viperdb@mgldev.scripps ##
    from WebServices.VisionInterface.WSNodes import viperdbNode
    viperdb_mgldev_scripps_14 = viperdbNode(host='http://mgldev.scripps.edu/services', constrkw = {'host': "'http://mgldev.scripps.edu/services'"}, name='viperdb@mgldev.scripps', library=wslib)
    masterNet.addNode(viperdb_mgldev_scripps_14,8,6)
    viperdb_mgldev_scripps_14.inputPortByName['pdb_id'].widget.set("2plv", run=False)
except:
    print "WARNING: failed to restore viperdbNode named viperdb@mgldev.scripps in network masterNet"
    print_exc()
    viperdb_mgldev_scripps_14=None
masterNet.freeze()

## saving connections for network viperdb ##
if Pmv_1 is not None and Choose_Cmd_2 is not None:
    masterNet.connectNodes(
        Pmv_1, Choose_Cmd_2, "PMV", "viewer", blocking=True)
if Choose_Cmd_2 is not None and Run_readPDB_3 is not None:
    masterNet.connectNodes(
        Choose_Cmd_2, Run_readPDB_3, "cmd", "command", blocking=True)
if Save_Lines_0 is not None and Run_readPDB_3 is not None:
    masterNet.connectNodes(
        Save_Lines_0, Run_readPDB_3, "filename", "filename", blocking=True)
if Run_readPDB_3 is not None and Set_Instances_4 is not None:
    masterNet.connectNodes(
        Run_readPDB_3, Set_Instances_4, "result", "molecule", blocking=True)
if Icosahedral_5 is not None and Set_Instances_4 is not None:
    masterNet.connectNodes(
        Icosahedral_5, Set_Instances_4, "Merge_outMatrices", "matrices", blocking=True)
if viperdb_mgldev_scripps_14 is not None and Save_Lines_0 is not None:
    masterNet.connectNodes(
        viperdb_mgldev_scripps_14, Save_Lines_0, "output", "data", blocking=True)
masterNet.unfreeze()
