########################################################################
#
#    Vision Macro - Python source code - file generated by vision
#    Thursday 01 June 2006 15:55:49 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/python/packages/share1.5/AutoDockTools/VisionInterface/AD3Gpf.py,v 1.1 2006/06/05 22:45:41 rhuey Exp $
#
# $Id: AD3Gpf.py,v 1.1 2006/06/05 22:45:41 rhuey Exp $
#

from NetworkEditor.macros import MacroNode
class AD3Gpf(MacroNode):

    def __init__(self, constrkw={}, name='AD3Gpf', **kw):
        kw['name'] = name
        apply( MacroNode.__init__, (self,), kw)

    def beforeAddingToNetwork(self, net):
        MacroNode.beforeAddingToNetwork(self, net)
        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        net.editor.addLibraryInstance(adtlib,"AutoDockTools.VisionInterface.AdtNodes", "adtlib")

        from MolKit.VisionInterface.MolKitNodes import molkitlib
        net.editor.addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

        from Vision.StandardNodes import stdlib
        net.editor.addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")


    def afterAddingToNetwork(self):
        from NetworkEditor.macros import MacroNode
        MacroNode.afterAddingToNetwork(self)
        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        from MolKit.VisionInterface.MolKitNodes import molkitlib
        from Vision.StandardNodes import stdlib
        ## building macro network ##
        AD3Gpf_15 = self
        from traceback import print_exc

        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        self.macroNetwork.getEditor().addLibraryInstance(adtlib,"AutoDockTools.VisionInterface.AdtNodes", "adtlib")

        from MolKit.VisionInterface.MolKitNodes import molkitlib
        self.macroNetwork.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

        from Vision.StandardNodes import stdlib
        self.macroNetwork.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

        try:
            ## saving node input Ports ##
            input_Ports_16 = self.macroNetwork.ipNode
        except:
            print "WARNING: failed to restore MacroInputNode named input Ports in network self.macroNetwork"
            print_exc()
            input_Ports_16=None

        try:
            ## saving node output Ports ##
            output_Ports_17 = self.macroNetwork.opNode
        except:
            print "WARNING: failed to restore MacroOutputNode named output Ports in network self.macroNetwork"
            print_exc()
            output_Ports_17=None

        try:
            ## saving node Grid Parameter File Browser ##
            from AutoDockTools.VisionInterface.AdtNodes import GridParameterFileBrowserNE
            Grid_Parameter_File_Browser_18 = GridParameterFileBrowserNE(constrkw = {}, name='Grid Parameter File Browser', library=adtlib)
            self.macroNetwork.addNode(Grid_Parameter_File_Browser_18,310,99)
            apply(Grid_Parameter_File_Browser_18.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Grid_Parameter_File_Browser_18.outputPortByName['filename'].configure, (), {'color': 'white', 'shape': 'oval'})
            Grid_Parameter_File_Browser_18.inputPortByName['filename'].widget.set("/mgl/work4/rhuey/dev23/fri2.gpf", run=False)
        except:
            print "WARNING: failed to restore GridParameterFileBrowserNE named Grid Parameter File Browser in network self.macroNetwork"
            print_exc()
            Grid_Parameter_File_Browser_18=None

        try:
            ## saving node Read Molecule ##
            from MolKit.VisionInterface.MolKitNodes import ReadMolecule
            Read_Molecule_19 = ReadMolecule(constrkw = {}, name='Read Molecule', library=molkitlib)
            self.macroNetwork.addNode(Read_Molecule_19,156,96)
            apply(Read_Molecule_19.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Read_Molecule_19.outputPortByName['MolSets'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore ReadMolecule named Read Molecule in network self.macroNetwork"
            print_exc()
            Read_Molecule_19=None

        try:
            ## saving node Read Molecule ##
            from MolKit.VisionInterface.MolKitNodes import ReadMolecule
            Read_Molecule_20 = ReadMolecule(constrkw = {}, name='Read Molecule', library=molkitlib)
            self.macroNetwork.addNode(Read_Molecule_20,234,98)
            apply(Read_Molecule_20.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Read_Molecule_20.outputPortByName['MolSets'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore ReadMolecule named Read Molecule in network self.macroNetwork"
            print_exc()
            Read_Molecule_20=None

        try:
            ## saving node File Browser ##
            from Vision.StandardNodes import FileBrowserNE
            File_Browser_21 = FileBrowserNE(constrkw = {}, name='File Browser', library=stdlib)
            self.macroNetwork.addNode(File_Browser_21,332,163)
            apply(File_Browser_21.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(File_Browser_21.outputPortByName['filename'].configure, (), {'color': 'white', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore FileBrowserNE named File Browser in network self.macroNetwork"
            print_exc()
            File_Browser_21=None

        try:
            ## saving node Prepare AD3Gpf ##
            from AutoDockTools.VisionInterface.AdtNodes import AdtPrepareGpf3
            Prepare_AD3Gpf_22 = AdtPrepareGpf3(constrkw = {}, name='Prepare AD3Gpf', library=adtlib)
            self.macroNetwork.addNode(Prepare_AD3Gpf_22,217,216)
            apply(Prepare_AD3Gpf_22.inputPortByName['ligand_filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Gpf_22.inputPortByName['receptor_filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Gpf_22.inputPortByName['gpf_filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Gpf_22.inputPortByName['parameters'].configure, (), {'color': 'cyan', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Gpf_22.inputPortByName['outputfilename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Prepare_AD3Gpf_22.outputPortByName['ag3_parameter_file'].configure, (), {'color': 'white', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore AdtPrepareGpf3 named Prepare AD3Gpf in network self.macroNetwork"
            print_exc()
            Prepare_AD3Gpf_22=None

        self.macroNetwork.freeze()

        ## saving connections for network AD3Gpf ##
        if Read_Molecule_19 is not None and Prepare_AD3Gpf_22 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Read_Molecule_19, Prepare_AD3Gpf_22, "MolSets", "ligand_filename", blocking=True)
            except:
                print "WARNING: failed to restore connection between Read_Molecule_19 and Prepare_AD3Gpf_22 in network self.macroNetwork"
        if Read_Molecule_20 is not None and Prepare_AD3Gpf_22 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Read_Molecule_20, Prepare_AD3Gpf_22, "MolSets", "receptor_filename", blocking=True)
            except:
                print "WARNING: failed to restore connection between Read_Molecule_20 and Prepare_AD3Gpf_22 in network self.macroNetwork"
        if Grid_Parameter_File_Browser_18 is not None and Prepare_AD3Gpf_22 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Grid_Parameter_File_Browser_18, Prepare_AD3Gpf_22, "filename", "gpf_filename", blocking=True)
            except:
                print "WARNING: failed to restore connection between Grid_Parameter_File_Browser_18 and Prepare_AD3Gpf_22 in network self.macroNetwork"
        if File_Browser_21 is not None and Prepare_AD3Gpf_22 is not None:
            try:
                self.macroNetwork.connectNodes(
                    File_Browser_21, Prepare_AD3Gpf_22, "filename", "outputfilename", blocking=True)
            except:
                print "WARNING: failed to restore connection between File_Browser_21 and Prepare_AD3Gpf_22 in network self.macroNetwork"
        output_Ports_17 = self.macroNetwork.opNode
        if Prepare_AD3Gpf_22 is not None and output_Ports_17 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Prepare_AD3Gpf_22, output_Ports_17, "ag3_parameter_file", "new", blocking=True)
            except:
                print "WARNING: failed to restore connection between Prepare_AD3Gpf_22 and output_Ports_17 in network self.macroNetwork"
        self.macroNetwork.unfreeze()

        AD3Gpf_15.shrink()

        ## reset modifications ##
        AD3Gpf_15.resetTags()
        AD3Gpf_15.buildOriginalList()
