#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 18 May 2011 14:03:30 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/CADD/workflows/MDanalysis/AMDNBCR_0.2_net.py,v 1.1.2.1 2011/06/29 01:27:43 jren Exp $
#
# $Id: AMDNBCR_0.2_net.py,v 1.1.2.1 2011/06/29 01:27:43 jren Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://rocce.ucsd.edu/opal2", replace=False)
except:
    pass
try:
    ## saving node Input Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Input_Directory_Browser_0 = DirBrowserNE(constrkw={}, name='Input Directory Browser', library=stdlib)
    masterNet.addNode(Input_Directory_Browser_0,375,8)
    Input_Directory_Browser_0.inputPortByName['directory'].widget.set(r"AMDNBCR_0.2_input", run=False)
    apply(Input_Directory_Browser_0.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Input Directory Browser in network masterNet"
    print_exc()
    Input_Directory_Browser_0=None

try:
    ## saving node NumProcessors ##
    from Vision.StandardNodes import EntryNE
    NumProcessors_1 = EntryNE(constrkw={}, name='NumProcessors', library=stdlib)
    masterNet.addNode(NumProcessors_1,1043,12)
    NumProcessors_1.inputPortByName['entry'].widget.set(r"4", run=False)
    code = """def doit(self, entry):
    if len(str(entry))!=0:
        self.outputData(string=entry)

"""
    NumProcessors_1.configure(function=code)
    apply(NumProcessors_1.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore EntryNE named NumProcessors in network masterNet"
    print_exc()
    NumProcessors_1=None

try:
    ## saving node Output Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Output_Directory_Browser_2 = DirBrowserNE(constrkw={}, name='Output Directory Browser', library=stdlib)
    masterNet.addNode(Output_Directory_Browser_2,715,9)
    Output_Directory_Browser_2.inputPortByName['directory'].widget.set(r"AMDNBCR_0.2_output", run=False)
    apply(Output_Directory_Browser_2.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Output Directory Browser in network masterNet"
    print_exc()
    Output_Directory_Browser_2=None

try:
    ## saving node Config File Browser ##
    from Vision.StandardNodes import FileBrowserNE
    Config_File_Browser_3 = FileBrowserNE(constrkw={}, name='Config File Browser', library=stdlib)
    masterNet.addNode(Config_File_Browser_3,67,22)
    Config_File_Browser_3.inputPortByName['filename'].widget.set(r"AMDNBCR_0.2_input/sample-aMD.conf", run=False)
    apply(Config_File_Browser_3.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named Config File Browser in network masterNet"
    print_exc()
    Config_File_Browser_3=None

try:
    ## saving node AMDws ##
    from NetworkEditor.macros import MacroNode
    AMDws_4 = MacroNode(name='AMDws')
    masterNet.addNode(AMDws_4, 357, 184)
    output_Ports_6 = AMDws_4.macroNetwork.opNode
    apply(output_Ports_6.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_6.move(182, 394)
    from NetworkEditor.items import FunctionNode
    NAMD_rocce_ucsd_edu_7 = FunctionNode(functionOrString='NAMD_rocce_ucsd_edu', host="http://rocce.ucsd.edu/opal2", namedArgs={'tarball': '', 'namdarg': '', 'localRun': False, 'execPath': '', 'procs': ''}, constrkw={'functionOrString': "'NAMD_rocce_ucsd_edu'", 'host': '"http://rocce.ucsd.edu/opal2"', 'namedArgs': {'tarball': '', 'namdarg': '', 'localRun': False, 'execPath': '', 'procs': ''}}, name='NAMD_rocce_ucsd_edu', library=wslib)
    AMDws_4.macroNetwork.addNode(NAMD_rocce_ucsd_edu_7,198,293)
    apply(NAMD_rocce_ucsd_edu_7.inputPortByName['tarball'].configure, (), {'defaultValue': None})
    apply(NAMD_rocce_ucsd_edu_7.inputPortByName['namdarg'].configure, (), {'defaultValue': None})
    apply(NAMD_rocce_ucsd_edu_7.inputPortByName['procs'].configure, (), {'defaultValue': None})
    NAMD_rocce_ucsd_edu_7.inputPortByName['tarball'].rebindWidget()
    NAMD_rocce_ucsd_edu_7.inputPortByName['tarball'].widget.set(r"", run=False)
    NAMD_rocce_ucsd_edu_7.inputPortByName['tarball'].unbindWidget()
    NAMD_rocce_ucsd_edu_7.inputPortByName['namdarg'].rebindWidget()
    NAMD_rocce_ucsd_edu_7.inputPortByName['namdarg'].widget.set(r"", run=False)
    NAMD_rocce_ucsd_edu_7.inputPortByName['namdarg'].unbindWidget()
    NAMD_rocce_ucsd_edu_7.inputPortByName['localRun'].widget.set(0, run=False)
    NAMD_rocce_ucsd_edu_7.inputPortByName['execPath'].widget.set(r"", run=False)
    NAMD_rocce_ucsd_edu_7.inputPortByName['procs'].rebindWidget()
    NAMD_rocce_ucsd_edu_7.inputPortByName['procs'].widget.set(r"", run=False)
    NAMD_rocce_ucsd_edu_7.inputPortByName['procs'].unbindWidget()
    apply(NAMD_rocce_ucsd_edu_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import MakeZipFileNE
    Make_Zip_File_8 = MakeZipFileNE(constrkw={}, name='Make Zip File', library=stdlib)
    AMDws_4.macroNetwork.addNode(Make_Zip_File_8,44,145)
    apply(Make_Zip_File_8.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Eval
    getConfigName_9 = Eval(constrkw={}, name='getConfigName', library=stdlib)
    AMDws_4.macroNetwork.addNode(getConfigName_9,217,172)
    getConfigName_9.inputPortByName['command'].widget.set(r"os.path.basename(in1)", run=False)
    getConfigName_9.inputPortByName['importString'].widget.set(r"", run=False)
    apply(getConfigName_9.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Eval
    prepareForZip_10 = Eval(constrkw={}, name='prepareForZip', library=stdlib)
    AMDws_4.macroNetwork.addNode(prepareForZip_10,143,91)
    prepareForZip_10.inputPortByName['command'].widget.set(r"os.path.basename(in1)", run=False)
    prepareForZip_10.inputPortByName['importString'].widget.set(r"", run=False)
    apply(prepareForZip_10.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
    GetMainURLFromList_11 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
    AMDws_4.macroNetwork.addNode(GetMainURLFromList_11,199,342)
    apply(GetMainURLFromList_11.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network AMDws ##
    AMDws_4.macroNetwork.freeze()
    input_Ports_5 = AMDws_4.macroNetwork.ipNode
    if input_Ports_5 is not None and getConfigName_9 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                input_Ports_5, getConfigName_9, "new", "in1", blocking=True
                , splitratio=[0.56731089905051557, 0.69034575704309797])
        except:
            print "WARNING: failed to restore connection between input_Ports_5 and getConfigName_9 in network AMDws_4.macroNetwork"
    if input_Ports_5 is not None and prepareForZip_10 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                input_Ports_5, prepareForZip_10, "new", "in1", blocking=True
                , splitratio=[0.50135048628782752, 0.38016101490352128])
        except:
            print "WARNING: failed to restore connection between input_Ports_5 and prepareForZip_10 in network AMDws_4.macroNetwork"
    if input_Ports_5 is not None and Make_Zip_File_8 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                input_Ports_5, Make_Zip_File_8, "prepareForZip_in1", "input_directory", blocking=True
                , splitratio=[0.26026655091979006, 0.38836623894413969])
        except:
            print "WARNING: failed to restore connection between input_Ports_5 and Make_Zip_File_8 in network AMDws_4.macroNetwork"
    if prepareForZip_10 is not None and Make_Zip_File_8 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                prepareForZip_10, Make_Zip_File_8, "result", "output_name", blocking=True
                , splitratio=[0.54034866876508625, 0.61013349942874484])
        except:
            print "WARNING: failed to restore connection between prepareForZip_10 and Make_Zip_File_8 in network AMDws_4.macroNetwork"
    if Make_Zip_File_8 is not None and NAMD_rocce_ucsd_edu_7 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                Make_Zip_File_8, NAMD_rocce_ucsd_edu_7, "zipfile", "tarball", blocking=True
                , splitratio=[0.25421834768677798, 0.72322220314479146])
        except:
            print "WARNING: failed to restore connection between Make_Zip_File_8 and NAMD_rocce_ucsd_edu_7 in network AMDws_4.macroNetwork"
    if getConfigName_9 is not None and NAMD_rocce_ucsd_edu_7 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                getConfigName_9, NAMD_rocce_ucsd_edu_7, "result", "namdarg", blocking=True
                , splitratio=[0.29539778940348749, 0.48121221099858358])
        except:
            print "WARNING: failed to restore connection between getConfigName_9 and NAMD_rocce_ucsd_edu_7 in network AMDws_4.macroNetwork"
    if input_Ports_5 is not None and NAMD_rocce_ucsd_edu_7 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                input_Ports_5, NAMD_rocce_ucsd_edu_7, "new", "procs", blocking=True
                , splitratio=[0.73370540958251707, 0.40716190001312769])
        except:
            print "WARNING: failed to restore connection between input_Ports_5 and NAMD_rocce_ucsd_edu_7 in network AMDws_4.macroNetwork"
    if NAMD_rocce_ucsd_edu_7 is not None and GetMainURLFromList_11 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                NAMD_rocce_ucsd_edu_7, GetMainURLFromList_11, "result", "urls", blocking=True
                , splitratio=[0.62509867822831222, 0.37094200197260763])
        except:
            print "WARNING: failed to restore connection between NAMD_rocce_ucsd_edu_7 and GetMainURLFromList_11 in network AMDws_4.macroNetwork"
    output_Ports_6 = AMDws_4.macroNetwork.opNode
    if GetMainURLFromList_11 is not None and output_Ports_6 is not None:
        try:
            AMDws_4.macroNetwork.connectNodes(
                GetMainURLFromList_11, output_Ports_6, "newurl", "new", blocking=True
                , splitratio=[0.66338768468729703, 0.52542303488924691])
        except:
            print "WARNING: failed to restore connection between GetMainURLFromList_11 and output_Ports_6 in network AMDws_4.macroNetwork"
    AMDws_4.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_5.outputPorts[1].configure(name='eval_in1')
    input_Ports_5.outputPorts[2].configure(name='prepareForZip_in1')
    input_Ports_5.outputPorts[3].configure(name='NAMD_rocce_ucsd_edu_procs')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_6.inputPorts[1].configure(singleConnection='auto')
    output_Ports_6.inputPorts[1].configure(name='GetMainURLFromList_newurl')
    AMDws_4.inputPorts[0].configure(name='eval_in1')
    AMDws_4.inputPorts[0].configure(datatype='string')
    AMDws_4.inputPorts[1].configure(name='prepareForZip_in1')
    AMDws_4.inputPorts[1].configure(datatype='string')
    AMDws_4.inputPorts[2].configure(name='NAMD_rocce_ucsd_edu_procs')
    AMDws_4.inputPorts[2].configure(datatype='string')
    ## configure MacroNode input ports
    AMDws_4.outputPorts[0].configure(name='GetMainURLFromList_newurl')
    AMDws_4.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    AMDws_4.shrink()
    apply(AMDws_4.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named AMDws in network masterNet"
    print_exc()
    AMDws_4=None

try:
    ## saving node DownloadDir ##
    from WebServices.VisionInterface.WSNodes import DownloadSaveDirNode
    DownloadDir_12 = DownloadSaveDirNode(constrkw={}, name='DownloadDir', library=wslib)
    masterNet.addNode(DownloadDir_12,494,320)
    apply(DownloadDir_12.inputPortByName['url'].configure, (), {'defaultValue': None})
    DownloadDir_12.inputPortByName['url'].rebindWidget()
    DownloadDir_12.inputPortByName['url'].widget.set(r"", run=False)
    DownloadDir_12.inputPortByName['url'].unbindWidget()
    apply(DownloadDir_12.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DownloadSaveDirNode named DownloadDir in network masterNet"
    print_exc()
    DownloadDir_12=None

#masterNet.run()
masterNet.freeze()

## saving connections for network AMDNBCR-0.2 ##
AMDws_4 = masterNet.nodes[4]
if Config_File_Browser_3 is not None and AMDws_4 is not None:
    try:
        masterNet.connectNodes(
            Config_File_Browser_3, AMDws_4, "filename", "eval_in1", blocking=True
            , splitratio=[0.65150653312544904, 0.31836383152848224])
    except:
        print "WARNING: failed to restore connection between Config_File_Browser_3 and AMDws_4 in network masterNet"
if Input_Directory_Browser_0 is not None and AMDws_4 is not None:
    try:
        masterNet.connectNodes(
            Input_Directory_Browser_0, AMDws_4, "directory", "prepareForZip_in1", blocking=True
            , splitratio=[0.46424478122839202, 0.70216128328369165])
    except:
        print "WARNING: failed to restore connection between Input_Directory_Browser_0 and AMDws_4 in network masterNet"
if NumProcessors_1 is not None and AMDws_4 is not None:
    try:
        masterNet.connectNodes(
            NumProcessors_1, AMDws_4, "string", "NAMD_rocce_ucsd_edu_procs", blocking=True
            , splitratio=[0.22553138779262585, 0.39031385694776288])
    except:
        print "WARNING: failed to restore connection between NumProcessors_1 and AMDws_4 in network masterNet"
if Output_Directory_Browser_2 is not None and DownloadDir_12 is not None:
    try:
        masterNet.connectNodes(
            Output_Directory_Browser_2, DownloadDir_12, "directory", "path", blocking=True
            , splitratio=[0.41029417603939722, 0.32301918529073281])
    except:
        print "WARNING: failed to restore connection between Output_Directory_Browser_2 and DownloadDir_12 in network masterNet"
if AMDws_4 is not None and DownloadDir_12 is not None:
    try:
        masterNet.connectNodes(
            AMDws_4, DownloadDir_12, "GetMainURLFromList_newurl", "url", blocking=True
            , splitratio=[0.50549266266146953, 0.39728842103951723])
    except:
        print "WARNING: failed to restore connection between AMDws_4 and DownloadDir_12 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

