#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 24 February 2011 02:28:13 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/CADD/workflows/MDanalysis/GROMOSClustering_0.1_net.py,v 1.1 2011/04/15 16:03:51 nadya Exp $
#
# $Id: GROMOSClustering_0.1_net.py,v 1.1 2011/04/15 16:03:51 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from AutoDockTools.VisionInterface.Adt import Adt
from Vision.StandardNodes import stdlib
from WebServices.VisionInterface.WSNodes import wslib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(Adt,"AutoDockTools.VisionInterface.Adt", "Adt")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
except:
    pass
try:
    ## saving node GromosCluster ##
    from Adt.Macro.GromosCluster import GromosCluster
    GromosCluster_0 = GromosCluster(constrkw={}, name='GromosCluster', library=Adt)
    masterNet.addNode(GromosCluster_0,396,213)
    apply(GromosCluster_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    GROMOS_ClusterFiles_kryptonite_nbcr_net_3 = GromosCluster_0.macroNetwork.nodes[2]
    GROMOS_ClusterFiles_kryptonite_nbcr_net_3.inputPortByName['expert_options'].widget.set(r"", run=False)
    GROMOS_ClusterFiles_kryptonite_nbcr_net_3.inputPortByName['prefix'].widget.set(r"", run=False)
    GROMOS_ClusterFiles_kryptonite_nbcr_net_3.inputPortByName['default_options'].widget.set(r"-o -g -dist -ev -sz -tr -ntr -clid -cl", run=False)
    GROMOS_ClusterFiles_kryptonite_nbcr_net_3.inputPortByName['localRun'].widget.set(0, run=False)
    apply(GROMOS_ClusterFiles_kryptonite_nbcr_net_3.inputPortByName['method'].widget.configure, (), {'choices': ('gromos', 'linkage', 'jarvis-patrick', 'monte-carlo', 'diagonalization')})
    GROMOS_ClusterFiles_kryptonite_nbcr_net_3.inputPortByName['method'].widget.set(r"gromos", run=False)
    GROMOS_ClusterFiles_kryptonite_nbcr_net_3.inputPortByName['execPath'].widget.set(r"", run=False)
    Entry_6 = GromosCluster_0.macroNetwork.nodes[5]
    Entry_6.inputPortByName['entry'].widget.set(r"3", run=False)

    ## saving connections for network GromosCluster ##
    GromosCluster_0.macroNetwork.freeze()
    GromosCluster_0.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_1 = GromosCluster_0.macroNetwork.ipNode
    input_Ports_1.outputPorts[1].configure(name='GROMOS_ClusterFiles_kryptonite_nbcr_net_traj')
    input_Ports_1.outputPorts[2].configure(name='GROMOS_ClusterFiles_kryptonite_nbcr_net_active')
    input_Ports_1.outputPorts[3].configure(name='GROMOS_ClusterFiles_kryptonite_nbcr_net_rmsd')
    input_Ports_1.outputPorts[4].configure(name='DownloadSaveDir_path')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_2 = GromosCluster_0.macroNetwork.opNode
    output_Ports_2.inputPorts[1].configure(singleConnection='auto')
    output_Ports_2.inputPorts[1].configure(name='DownloadSaveDir_output')
    GromosCluster_0.inputPorts[0].configure(name='GROMOS_ClusterFiles_kryptonite_nbcr_net_traj')
    GromosCluster_0.inputPorts[0].configure(datatype='string')
    GromosCluster_0.inputPorts[1].configure(name='GROMOS_ClusterFiles_kryptonite_nbcr_net_active')
    GromosCluster_0.inputPorts[1].configure(datatype='string')
    GromosCluster_0.inputPorts[2].configure(name='GROMOS_ClusterFiles_kryptonite_nbcr_net_rmsd')
    GromosCluster_0.inputPorts[2].configure(datatype='string')
    GromosCluster_0.inputPorts[3].configure(name='DownloadSaveDir_path')
    GromosCluster_0.inputPorts[3].configure(datatype='string')
    ## configure MacroNode input ports
    GromosCluster_0.outputPorts[0].configure(name='DownloadSaveDir_output')
    GromosCluster_0.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    GromosCluster_0.shrink()
    apply(GromosCluster_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore GromosCluster named GromosCluster in network masterNet"
    print_exc()
    GromosCluster_0=None

try:
    ## saving node TrajectoryPDBFile ##
    from Vision.StandardNodes import FileBrowserNE
    TrajectoryPDBFile_7 = FileBrowserNE(constrkw={}, name='TrajectoryPDBFile', library=stdlib)
    masterNet.addNode(TrajectoryPDBFile_7,88,47)
    TrajectoryPDBFile_7.inputPortByName['filename'].widget.set(r"GROMOSClustering_0.1_input/trajectory.pdb", run=False)
    apply(TrajectoryPDBFile_7.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named TrajectoryPDBFile in network masterNet"
    print_exc()
    TrajectoryPDBFile_7=None

try:
    ## saving node ActiveResidueFile ##
    from Vision.StandardNodes import FileBrowserNE
    ActiveResidueFile_8 = FileBrowserNE(constrkw={}, name='ActiveResidueFile', library=stdlib)
    masterNet.addNode(ActiveResidueFile_8,412,46)
    ActiveResidueFile_8.inputPortByName['filename'].widget.set(r"GROMOSClustering_0.1_input/activeSiteResidue.pdb", run=False)
    apply(ActiveResidueFile_8.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named ActiveResidueFile in network masterNet"
    print_exc()
    ActiveResidueFile_8=None

try:
    ## saving node RMSD ##
    from Vision.StandardNodes import EntryNE
    RMSD_9 = EntryNE(constrkw={}, name='RMSD', library=stdlib)
    masterNet.addNode(RMSD_9,772,46)
    RMSD_9.inputPortByName['entry'].widget.set(r"0.08", run=False)
    apply(RMSD_9.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore EntryNE named RMSD in network masterNet"
    print_exc()
    RMSD_9=None

try:
    ## saving node OutputDirectory ##
    from Vision.StandardNodes import DirBrowserNE
    OutputDirectory_10 = DirBrowserNE(constrkw={}, name='OutputDirectory', library=stdlib)
    masterNet.addNode(OutputDirectory_10,1025,38)
    OutputDirectory_10.inputPortByName['directory'].widget.set(r"GROMOSClustering_0.1_output", run=False)
    apply(OutputDirectory_10.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named OutputDirectory in network masterNet"
    print_exc()
    OutputDirectory_10=None

try:
    ## saving node DPFTemplateBrowser ##
    from Adt.Input.DPFTemplateBrowser import DPFTemplateBrowser
    DPFTemplateBrowser_11 = DPFTemplateBrowser(constrkw={}, name='DPFTemplateBrowser', library=Adt)
    masterNet.addNode(DPFTemplateBrowser_11,633,265)
    DPFTemplateBrowser_11.inputPortByName['dpf_template_file'].widget.set(r"GROMOSClustering_0.1_input/2HTY_A.dpf", run=False)
    apply(DPFTemplateBrowser_11.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DPFTemplateBrowser named DPFTemplateBrowser in network masterNet"
    print_exc()
    DPFTemplateBrowser_11=None

try:
    ## saving node GPFTemplateBrowser ##
    from Adt.Input.GPFTemplateBrowser import GPFTemplateBrowser
    GPFTemplateBrowser_12 = GPFTemplateBrowser(constrkw={}, name='GPFTemplateBrowser', library=Adt)
    masterNet.addNode(GPFTemplateBrowser_12,6,255)
    GPFTemplateBrowser_12.inputPortByName['gpf_template_file'].widget.set(r"GROMOSClustering_0.1_input/2HTY_A.gpf", run=False)
    apply(GPFTemplateBrowser_12.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore GPFTemplateBrowser named GPFTemplateBrowser in network masterNet"
    print_exc()
    GPFTemplateBrowser_12=None

try:
    ## saving node MakeGpfDpfCopies ##
    from Adt.Input.MakeGpfDpfCopies import MakeGpfDpfCopies
    MakeGpfDpfCopies_13 = MakeGpfDpfCopies(constrkw={}, name='MakeGpfDpfCopies', library=Adt)
    masterNet.addNode(MakeGpfDpfCopies_13,362,466)
    apply(MakeGpfDpfCopies_13.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MakeGpfDpfCopies named MakeGpfDpfCopies in network masterNet"
    print_exc()
    MakeGpfDpfCopies_13=None

#masterNet.run()
masterNet.freeze()

## saving connections for network GROMOSClustering-0.1 ##
if TrajectoryPDBFile_7 is not None and GromosCluster_0 is not None:
    try:
        masterNet.connectNodes(
            TrajectoryPDBFile_7, GromosCluster_0, "filename", "GROMOS_ClusterFiles_kryptonite_nbcr_net_traj", blocking=True
            , splitratio=[0.40516597457034675, 0.47883762346301628])
    except:
        print "WARNING: failed to restore connection between TrajectoryPDBFile_7 and GromosCluster_0 in network masterNet"
if ActiveResidueFile_8 is not None and GromosCluster_0 is not None:
    try:
        masterNet.connectNodes(
            ActiveResidueFile_8, GromosCluster_0, "filename", "GROMOS_ClusterFiles_kryptonite_nbcr_net_active", blocking=True
            , splitratio=[0.35790962133037152, 0.58579177190104637])
    except:
        print "WARNING: failed to restore connection between ActiveResidueFile_8 and GromosCluster_0 in network masterNet"
if RMSD_9 is not None and GromosCluster_0 is not None:
    try:
        masterNet.connectNodes(
            RMSD_9, GromosCluster_0, "string", "GROMOS_ClusterFiles_kryptonite_nbcr_net_rmsd", blocking=True
            , splitratio=[0.50918524073258298, 0.2104640996462267])
    except:
        print "WARNING: failed to restore connection between RMSD_9 and GromosCluster_0 in network masterNet"
if OutputDirectory_10 is not None and GromosCluster_0 is not None:
    try:
        masterNet.connectNodes(
            OutputDirectory_10, GromosCluster_0, "directory", "DownloadSaveDir_path", blocking=True
            , splitratio=[0.65993064333774032, 0.62912512597946058])
    except:
        print "WARNING: failed to restore connection between OutputDirectory_10 and GromosCluster_0 in network masterNet"
if GPFTemplateBrowser_12 is not None and MakeGpfDpfCopies_13 is not None:
    try:
        masterNet.connectNodes(
            GPFTemplateBrowser_12, MakeGpfDpfCopies_13, "gpf_template", "gpf_file", blocking=True
            , splitratio=[0.38882320120172753, 0.24020719445005773])
    except:
        print "WARNING: failed to restore connection between GPFTemplateBrowser_12 and MakeGpfDpfCopies_13 in network masterNet"
if DPFTemplateBrowser_11 is not None and MakeGpfDpfCopies_13 is not None:
    try:
        masterNet.connectNodes(
            DPFTemplateBrowser_11, MakeGpfDpfCopies_13, "dpf_template", "dpf_file", blocking=True
            , splitratio=[0.63661487265432926, 0.20173131060868402])
    except:
        print "WARNING: failed to restore connection between DPFTemplateBrowser_11 and MakeGpfDpfCopies_13 in network masterNet"
if GromosCluster_0 is not None and MakeGpfDpfCopies_13 is not None:
    try:
        masterNet.connectNodes(
            GromosCluster_0, MakeGpfDpfCopies_13, "DownloadSaveDir_output", "struct_dir", blocking=True
            , splitratio=[0.44295112159001504, 0.54816281093721997])
    except:
        print "WARNING: failed to restore connection between GromosCluster_0 and MakeGpfDpfCopies_13 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

