########################################################################
#
#    Vision Node - Python source code - file generated by vision
#    Tuesday 27 November 2007 09:18:38 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/VisionLibraries/scipylib/signal/freqz.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#
# $Id: freqz.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#

# import node's base class node
from NetworkEditor.items import NetworkNode
class freqz(NetworkNode):
    mRequiredTypes = {}
    mRequiredSynonyms = [
    ]
    def __init__(self, constrkw = {},  name='freqz', **kw):
        kw['constrkw'] = constrkw
        kw['name'] = name
        apply( NetworkNode.__init__, (self,), kw)
        code = """def doit(self, b, a, fs):
    from scipy.signal import freqz
    from scipy import absolute as abs
    from scipy import log10, pi
    w,h=freqz(b,a)
    self.outputData(f=w/pi*(fs/2.0))
    self.outputData(H=10*log10(abs(h)))

"""
        self.configure(function=code)
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'b', 'cast': True, 'datatype': 'None', 'balloon': 'filter numerator', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'a', 'cast': True, 'datatype': 'None', 'balloon': 'filter denominator', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'fs', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green'})
        self.outputPortsDescr.append(
            {'name': 'H', 'datatype': 'None', 'balloon': 'abs(h) frequency response', 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green'})
        self.outputPortsDescr.append(
            {'name': 'f', 'datatype': 'array', 'balloon': 'abscissa', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
        self.widgetDescr['a'] = {
            'initialValue': 1.0, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'left', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'height': 20, 'labelGridCfg': {'rowspan': 1, 'column': 0, 'sticky': 'w', 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'width': 60, 'master': 'node', 'increment': 1.0, 'wheelPad': 1, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 0}, 'labelCfg': {'text': 'a'}, 'class': 'NEThumbWheel', 'oneTurn': 10.0}


    def beforeAddingToNetwork(self, net):
        try:
            ed = net.getEditor()
        except:
            import traceback; traceback.print_exc()
            print 'Warning! Could not import widgets'

