########################################################################
#
#    Vision Node - Python source code - file generated by vision
#    Thursday 08 November 2007 10:33:01 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/VisionLibraries/scipylib/signal/timeRange.py,v 1.2 2009/09/30 21:06:46 vareille Exp $
#
# $Id: timeRange.py,v 1.2 2009/09/30 21:06:46 vareille Exp $
#

# import node's base class node
from NetworkEditor.items import NetworkNode
class timeRange(NetworkNode):
    mRequiredTypes = {}
    mRequiredSynonyms = [
    ]
    def __init__(self, constrkw = {},  name='timeRange', **kw):
        kw['constrkw'] = constrkw
        kw['name'] = name
        apply( NetworkNode.__init__, (self,), kw)
        code = """def doit(self, t0, t1, fs):
    import scipy
    data=scipy.arange(t0,t1,1.0/fs)
    self.outputData(out0=data)
    self.outputData(fs=fs)
"""
        self.configure(function=code)
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 't0', 'cast': True, 'datatype': 'float', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green', 'originalDatatype': 'None'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 't1', 'cast': True, 'datatype': 'float', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green', 'originalDatatype': 'None'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'fs', 'cast': True, 'datatype': 'float', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green', 'originalDatatype': 'None'})
        self.outputPortsDescr.append(
            {'name': 'out0', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.outputPortsDescr.append(
            {'name': 'fs', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.widgetDescr['t0'] = {
            'initialValue': 0.0, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'left', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'increment':0.1, 'height': 20, 'labelGridCfg': {'rowspan': 1, 'column': 0, 'sticky': 'w', 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'width': 60, 'master': 'node', 'wheelPad': 1, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 0}, 'labelCfg': {'text': 't0'}, 'class': 'NEThumbWheel', 'oneTurn': 10.0}
        self.widgetDescr['t1'] = {
            'initialValue': 1.0, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'left', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 1}, 'increment':0.1, 'height': 20, 'labelGridCfg': {'rowspan': 1, 'column': 0, 'sticky': 'w', 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 1}, 'width': 60, 'master': 'node', 'wheelPad': 1, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 0}, 'labelCfg': {'text': 't1'}, 'class': 'NEThumbWheel', 'oneTurn': 10.0}
        self.widgetDescr['fs'] = {
            'initialValue': 100, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'left', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 2},'increment':5, 'height': 20, 'labelGridCfg': {'rowspan': 1, 'column': 0, 'sticky': 'w', 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 2}, 'width': 60, 'master': 'node', 'wheelPad': 1, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 0}, 'labelCfg': {'text': 'fs'}, 'class': 'NEThumbWheel', 'oneTurn': 50.0}


    def beforeAddingToNetwork(self, net):
        try:
            ed = net.getEditor()
        except:
            import traceback; traceback.print_exc()
            print 'Warning! Could not import widgets'

