########################################################################
#
#    Vision Node - Python source code - file generated by vision
#    Thursday 08 November 2007 10:33:01 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /mnt/raid/services/cvs/VisionLibraries/scipylib/signal/db20FFT.py,v 1.2 2009/09/30 21:06:46 vareille Exp $
#
# $Id: db20FFT.py,v 1.2 2009/09/30 21:06:46 vareille Exp $
#

# import node's base class node
from scipy import fft, arange
from scipy import absolute as abs
from scipy import log10
from NetworkEditor.items import NetworkNode
class db20FFT(NetworkNode):
    mRequiredTypes = {}
    mRequiredSynonyms = [
    ]
    def __init__(self, constrkw = {},  name='db20FFT', **kw):
        kw['constrkw'] = constrkw
        kw['name'] = name
        apply( NetworkNode.__init__, (self,), kw)
        code = """def doit(self, data, fs, nfft):
    data=20*log10(abs(fft(data,nfft)))
    freqs = arange(0,fs,fs/float(nfft))
    self.outputData(out0=data)
    self.outputData(freqs=freqs)
"""
        self.configure(function=code)
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'data', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'green'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'fs', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'green' })
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'nfft', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'circle', 'color': 'green'})
        self.outputPortsDescr.append(
            {'name': 'out0', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.outputPortsDescr.append(
            {'name': 'freqs', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.widgetDescr['nfft'] = {
            'initialValue': 512, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'left', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'increment':0.1, 'height': 20, 'labelGridCfg': {'rowspan': 1, 'column': 0, 'sticky': 'w', 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'width': 60, 'master': 'node', 'wheelPad': 1, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 0}, 'labelCfg': {'text': 'nfft'}, 'class': 'NEThumbWheel', 'oneTurn': 10.0,'min':2}


    def beforeAddingToNetwork(self, net):
        try:
            ed = net.getEditor()
        except:
            import traceback; traceback.print_exc()
            print 'Warning! Could not import widgets'

