#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 04 August 2011 15:01:55 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/CADD/workflows/visualization/visualization_0.1.1_pmvnet.py,v 1.1.2.2 2011/08/04 22:57:55 jren Exp $
#
# $Id: visualization_0.1.1_pmvnet.py,v 1.1.2.2 2011/08/04 22:57:55 jren Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
    import os
    masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node AutoDock VS Result Directory ##
    from Vision.StandardNodes import DirBrowserNE
    AutoDock_VS_Result_Directory_28 = DirBrowserNE(constrkw={}, name='AutoDock VS Result Directory', library=stdlib)
    masterNet.addNode(AutoDock_VS_Result_Directory_28,47,27)
    AutoDock_VS_Result_Directory_28.inputPortByName['directory'].widget.set(r"visualization_0.1.1_input", run=False)
    apply(AutoDock_VS_Result_Directory_28.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named AutoDock VS Result Directory in network masterNet"
    print_exc()
    AutoDock_VS_Result_Directory_28=None

try:
    ## saving node GetReceptors ##
    from Vision.StandardNodes import Generic
    GetReceptors_29 = Generic(constrkw={}, name='GetReceptors', library=stdlib)
    masterNet.addNode(GetReceptors_29,47,123)
    apply(GetReceptors_29.addInputPort, (), {'singleConnection': True, 'name': 'dir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetReceptors_29.addOutputPort, (), {'name': 'receptors', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    apply(GetReceptors_29.addOutputPort, (), {'name': 'receptor_paths', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    code = """def doit(self, dir):
    import glob, os
    match_str = '''*'''
    if dir is not None:
        cwd = os.getcwd()
        os.chdir(dir)
    try:
        pdirs = glob.glob(match_str)
        receptors = []

        for i in pdirs:
            if os.path.exists(i + os.sep + '''summarize_results.txt'''):
                receptors.append(i)

        receptor_paths = [os.path.join(dir, x) for x in receptors]

        if receptor_paths != []:
            self.outputData(receptors=receptors, receptor_paths=receptor_paths)
        else:
            receptor = glob.glob("*.gpf")[0].split('''.''')[0]
            receptors = [receptor]
            receptor_paths = [os.path.join(dir, receptor + ".pdbqt")]
            self.outputData(receptors=receptors, receptor_paths=receptor_paths)
    finally: 
        if dir is not None:
            os.chdir(cwd)



























"""
    GetReceptors_29.configure(function=code)
    apply(GetReceptors_29.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named GetReceptors in network masterNet"
    print_exc()
    GetReceptors_29=None

try:
    ## saving node ReceptorList ##
    from Vision.StandardNodes import ScrolledListNE
    ReceptorList_30 = ScrolledListNE(constrkw={}, name='ReceptorList', library=stdlib)
    masterNet.addNode(ReceptorList_30,47,189)
    apply(ReceptorList_30.inputPortByName['selection'].widget.configure, (), {'choices': ['2HTY_A', '2HU4_B']})
    ReceptorList_30.inputPortByName['selection'].widget.set(r"", run=False)
    code = """def doit(self, valueList, nameList, selection):
    widget = self.inputPorts[2].widget

    if self.firstRun is True:
        selection = None
        self.firstRun = False

    # do we run the first time, and have been restored from a network? (then
    # we have both valueList and selection specified)
    if valueList and selection and self.firstRun is True:
        self.firstRun = False
        self.objectList = valueList
        self.nameList = nameList
        data = self.getData(selection, nameList)
        if data is not None:
            self.outputData(selection=data)
        return

    # only rebuild widget if we receive a new valueList
    if self.inputPorts[0].hasNewValidData() or self.inputPorts[1].hasNewValidData():
        if valueList != self.objectList or self.nameList != nameList:
            self.objectList = valueList
            self.nameList = nameList
            if nameList:
                vList = nameList
            else:
                vList = []
                for data in valueList:
                    if type(data) == types.StringType:
                        vList.append(data)
                    else:
                        vList.append(repr(data))
            if widget is not None:
                widget.setlist(vList)
                widget.configure(choices=vList)
                widget.widget.setentry('''''')
            return

    if selection:
        data = self.getData(selection, nameList)
        if data is not None:
            self.outputData(selection=data)



"""
    ReceptorList_30.configure(function=code)
    apply(ReceptorList_30.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ScrolledListNE named ReceptorList in network masterNet"
    print_exc()
    ReceptorList_30=None

try:
    ## saving node LoadMolecule ##
    from NetworkEditor.macros import MacroNode
    LoadMolecule_31 = MacroNode(name='LoadMolecule')
    masterNet.addNode(LoadMolecule_31, 186, 608)
    output_Ports_33 = LoadMolecule_31.macroNetwork.opNode
    apply(output_Ports_33.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    getMolePath_34 = Generic(constrkw={}, name='getMolePath', library=stdlib)
    LoadMolecule_31.macroNetwork.addNode(getMolePath_34,217,82)
    apply(getMolePath_34.addInputPort, (), {'singleConnection': True, 'name': 'mol', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(getMolePath_34.addInputPort, (), {'singleConnection': True, 'name': 'mol_paths', 'cast': True, 'datatype': 'list', 'defaultValue': None, 'required': True, 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan', 'originalDatatype': 'None'})
    apply(getMolePath_34.addOutputPort, (), {'name': 'mol_path', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, mol, mol_paths):
    if len(mol_paths) == 1:
        self.outputData(mol_path=mol_paths[0])

    for i in mol_paths:
        if os.path.basename(i) == mol:
            fn = i + os.sep + mol
            pdbqt = fn + '''.pdbqt'''
            pqr = fn + '''.pqr'''
            pdb = fn + '''.pdb'''
            
            if os.path.exists(pdbqt):
                self.outputData(mol_path=pdbqt)
            elif os.path.exists(pqr):
                self.outputData(mol_path=pqr)
            elif os.path.exists(pdb):
                self.outputData(mol_path=pdb)
                
    	pass
## to ouput data on port mol_path use


















"""
    getMolePath_34.configure(function=code)
    apply(getMolePath_34.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_35 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    LoadMolecule_31.macroNetwork.addNode(Pmv_35,28,119)
    Pmv_35.inputPortByName['cmdName'].widget.set(r"readMolecule", run=False)
    Pmv_35.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_35.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    readMolecule_36 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.readMolecule, namedArgs={'parser': None}, posArgsNames=['filename'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.readMolecule', 'namedArgs': {'parser': None}, 'posArgsNames': ['filename']}, name='readMolecule', library=pmvlib)
    LoadMolecule_31.macroNetwork.addNode(readMolecule_36,112,221)
    apply(readMolecule_36.inputPortByName['filename'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(readMolecule_36.inputPortByName['parser'].configure, (), {'defaultValue': None})
    apply(readMolecule_36.configure, (), {'specialPortsVisible': True})
    readMolecule_36.inputPortByName['importString'].widget.set(r"", run=False)
    apply(readMolecule_36.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_37 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    LoadMolecule_31.macroNetwork.addNode(Pmv_37,365,85)
    Pmv_37.inputPortByName['cmdName'].widget.set(r"deleteAllMolecules", run=False)
    Pmv_37.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_37.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    deleteAllMolecules_38 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.deleteAllMolecules, constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.deleteAllMolecules'}, name='deleteAllMolecules', library=pmvlib)
    LoadMolecule_31.macroNetwork.addNode(deleteAllMolecules_38,382,153)
    deleteAllMolecules_38.inputPortByName['importString'].widget.set(r"", run=False)
    apply(deleteAllMolecules_38.configure, (), {'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_39 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    LoadMolecule_31.macroNetwork.addNode(Pmv_39,77,272)
    Pmv_39.inputPortByName['cmdName'].widget.set(r"computeMSMS", run=False)
    Pmv_39.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_39.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    computeMSMS_40 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.computeMSMS, namedArgs={'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'noHetatm': False, 'display': True, 'pRadius': 1.5}, posArgsNames=['nodes'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.computeMSMS', 'namedArgs': {'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'noHetatm': False, 'display': True, 'pRadius': 1.5}, 'posArgsNames': ['nodes']}, name='computeMSMS', library=pmvlib)
    LoadMolecule_31.macroNetwork.addNode(computeMSMS_40,319,384)
    apply(computeMSMS_40.inputPortByName['nodes'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(computeMSMS_40.inputPortByName['hdensity'].configure, (), {'defaultValue': None})
    apply(computeMSMS_40.inputPortByName['hdset'].configure, (), {'defaultValue': None})
    apply(computeMSMS_40.inputPortByName['surfName'].configure, (), {'defaultValue': None})
    apply(computeMSMS_40.inputPortByName['density'].configure, (), {'defaultValue': None})
    apply(computeMSMS_40.inputPortByName['perMol'].configure, (), {'defaultValue': None})
    apply(computeMSMS_40.inputPortByName['noHetatm'].configure, (), {'defaultValue': None})
    apply(computeMSMS_40.inputPortByName['display'].configure, (), {'defaultValue': None})
    apply(computeMSMS_40.inputPortByName['pRadius'].configure, (), {'defaultValue': None})
    apply(computeMSMS_40.configure, (), {'specialPortsVisible': True})
    computeMSMS_40.inputPortByName['importString'].widget.set(r"", run=False)
    computeMSMS_40.inputPortByName['hdensity'].widget.set(6.0, run=False)
    computeMSMS_40.inputPortByName['hdset'].widget.set(r"None", run=False)
    computeMSMS_40.inputPortByName['surfName'].widget.set(r"MSMS-MOL", run=False)
    computeMSMS_40.inputPortByName['density'].widget.set(3.0, run=False)
    computeMSMS_40.inputPortByName['perMol'].widget.set(1, run=False)
    computeMSMS_40.inputPortByName['noHetatm'].widget.set(0, run=False)
    computeMSMS_40.inputPortByName['display'].widget.set(1, run=False)
    computeMSMS_40.inputPortByName['pRadius'].widget.set(1.5, run=False)
    apply(computeMSMS_40.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})

    ## saving connections for network LoadMolecule ##
    LoadMolecule_31.macroNetwork.freeze()
    input_Ports_32 = LoadMolecule_31.macroNetwork.ipNode
    if input_Ports_32 is not None and getMolePath_34 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                input_Ports_32, getMolePath_34, "new", "mol", blocking=True
                , splitratio=[0.24980279662847732, 0.22054773831723101])
        except:
            print "WARNING: failed to restore connection between input_Ports_32 and getMolePath_34 in network LoadMolecule_31.macroNetwork"
    if input_Ports_32 is not None and getMolePath_34 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                input_Ports_32, getMolePath_34, "new", "mol_paths", blocking=True
                , splitratio=[0.60958416690230111, 0.22486163260138911])
        except:
            print "WARNING: failed to restore connection between input_Ports_32 and getMolePath_34 in network LoadMolecule_31.macroNetwork"
    if Pmv_35 is not None and readMolecule_36 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                Pmv_35, readMolecule_36, "cmd", "command", blocking=True
                , splitratio=[0.69648176561605402, 0.58749861410425019])
        except:
            print "WARNING: failed to restore connection between Pmv_35 and readMolecule_36 in network LoadMolecule_31.macroNetwork"
    if getMolePath_34 is not None and readMolecule_36 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                getMolePath_34, readMolecule_36, "mol_path", "filename", blocking=True
                , splitratio=[0.0, 0.27994494700716432])
        except:
            print "WARNING: failed to restore connection between getMolePath_34 and readMolecule_36 in network LoadMolecule_31.macroNetwork"
    if Pmv_37 is not None and deleteAllMolecules_38 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                Pmv_37, deleteAllMolecules_38, "cmd", "command", blocking=True
                , splitratio=[0.47295098765011379, 0.62794740523785708])
        except:
            print "WARNING: failed to restore connection between Pmv_37 and deleteAllMolecules_38 in network LoadMolecule_31.macroNetwork"
    if deleteAllMolecules_38 is not None and readMolecule_36 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                deleteAllMolecules_38, readMolecule_36, "result", "parser", blocking=True
                , splitratio=[0.27033886000889895, 0.20639273480186354])
        except:
            print "WARNING: failed to restore connection between deleteAllMolecules_38 and readMolecule_36 in network LoadMolecule_31.macroNetwork"
    if Pmv_39 is not None and computeMSMS_40 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                Pmv_39, computeMSMS_40, "cmd", "command", blocking=True
                , splitratio=[0.66433995763273601, 0.54329119167320339])
        except:
            print "WARNING: failed to restore connection between Pmv_39 and computeMSMS_40 in network LoadMolecule_31.macroNetwork"
    if readMolecule_36 is not None and computeMSMS_40 is not None:
        try:
            LoadMolecule_31.macroNetwork.specialConnectNodes(
                readMolecule_36, computeMSMS_40, "trigger", "runNode", blocking=True
                , splitratio=[0.64725691018348408, 0.5514758081666683])
        except:
            print "WARNING: failed to restore connection between readMolecule_36 and computeMSMS_40 in network LoadMolecule_31.macroNetwork"
    output_Ports_33 = LoadMolecule_31.macroNetwork.opNode
    if getMolePath_34 is not None and output_Ports_33 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                getMolePath_34, output_Ports_33, "mol_path", "new", blocking=True
                , splitratio=[0.5282594356295357, 0.20903895812748927])
        except:
            print "WARNING: failed to restore connection between getMolePath_34 and output_Ports_33 in network LoadMolecule_31.macroNetwork"
    if input_Ports_32 is not None and computeMSMS_40 is not None:
        try:
            LoadMolecule_31.macroNetwork.connectNodes(
                input_Ports_32, computeMSMS_40, "getMolePath_mol", "nodes", blocking=True
                , splitratio=[0.38633655118780108, 0.68223326575013044])
        except:
            print "WARNING: failed to restore connection between input_Ports_32 and computeMSMS_40 in network LoadMolecule_31.macroNetwork"
    LoadMolecule_31.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_32.outputPorts[1].configure(name='getMolePath_mol')
    input_Ports_32.outputPorts[2].configure(name='getMolePath_mol_paths')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_33.inputPorts[1].configure(singleConnection='auto')
    output_Ports_33.inputPorts[1].configure(name='getMolePath_mol_path')
    LoadMolecule_31.inputPorts[0].configure(name='getMolePath_mol')
    LoadMolecule_31.inputPorts[0].configure(datatype='string')
    LoadMolecule_31.inputPorts[1].configure(name='getMolePath_mol_paths')
    LoadMolecule_31.inputPorts[1].configure(datatype='list')
    ## configure MacroNode input ports
    LoadMolecule_31.outputPorts[0].configure(name='getMolePath_mol_path')
    LoadMolecule_31.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    LoadMolecule_31.shrink()
    apply(LoadMolecule_31.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named LoadMolecule in network masterNet"
    print_exc()
    LoadMolecule_31=None

try:
    ## saving node GetLigands ##
    from Vision.StandardNodes import Generic
    GetLigands_41 = Generic(constrkw={}, name='GetLigands', library=stdlib)
    masterNet.addNode(GetLigands_41,332,135)
    apply(GetLigands_41.addInputPort, (), {'singleConnection': True, 'name': 'rps', 'cast': True, 'datatype': 'list', 'defaultValue': None, 'required': True, 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan', 'originalDatatype': 'None'})
    apply(GetLigands_41.addInputPort, (), {'singleConnection': True, 'name': 'r', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetLigands_41.addOutputPort, (), {'name': 'ligands', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    code = """def doit(self, rps, r):
        import glob
        
        ligandlist = []

        try:
            for i in rps:
                ld = os.path.basename(i)

                if ld == r:
                    liganddir = i
                    break

            lf = liganddir + os.sep + '''summarize_results.txt'''

            f = open(lf)
            f.readline()

            for i in f.readlines():
                ligand = os.path.basename(str(i).split(''',''')[0])
                ligandlist.append(ligand)
                    
            f.close()
        except:
            receptor_path = rps[0]
            d = os.path.dirname(receptor_path)
            rn = os.path.basename(receptor_path)
            cwd = os.getcwd()
            os.chdir(d)
            pdbqts = glob.glob("*.pdbqt")
            os.chdir(cwd)

            for i in pdbqts:
                if i != rn:
                    ligand = i.split('''.''')[0]
                    break
                
            os.chdir(cwd)
            ligandlist.append(ligand)

        
	pass
## to ouput data on port ligands use
        self.outputData(ligands=ligandlist)








































"""
    GetLigands_41.configure(function=code)
    apply(GetLigands_41.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named GetLigands in network masterNet"
    print_exc()
    GetLigands_41=None

try:
    ## saving node LigandList ##
    from Vision.StandardNodes import ScrolledListNE
    LigandList_42 = ScrolledListNE(constrkw={}, name='LigandList', library=stdlib)
    masterNet.addNode(LigandList_42,332,190)
    apply(LigandList_42.inputPortByName['selection'].widget.configure, (), {'choices': ['diversity0004', 'diversity0005', 'diversity0003', 'diversity0001', 'diversity0002', 'diversity0006']})
    LigandList_42.inputPortByName['selection'].widget.set(r"diversity0003", run=False)
    code = """def doit(self, valueList, nameList, selection):
    widget = self.inputPorts[2].widget

    if self.firstRun is True:
        seleciton = None
        self.firstRun = False

    # do we run the first time, and have been restored from a network? (then
    # we have both valueList and selection specified)
    if valueList and selection and self.firstRun is True:
        self.firstRun = False
        self.objectList = valueList
        self.nameList = nameList
        data = self.getData(selection, nameList)
        if data is not None:
            self.outputData(selection=data)
        return

    # only rebuild widget if we receive a new valueList
    if self.inputPorts[0].hasNewValidData() or self.inputPorts[1].hasNewValidData():
        if valueList != self.objectList or self.nameList != nameList:
            self.objectList = valueList
            self.nameList = nameList
            if nameList:
                vList = nameList
            else:
                vList = []
                for data in valueList:
                    if type(data) == types.StringType:
                        vList.append(data)
                    else:
                        vList.append(repr(data))
            if widget is not None:
                widget.setlist(vList)
                widget.configure(choices=vList)
                widget.widget.setentry('''''')
            return

    if selection:
        data = self.getData(selection, nameList)
        if data is not None:
            self.outputData(selection=data)

"""
    LigandList_42.configure(function=code)
    apply(LigandList_42.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ScrolledListNE named LigandList in network masterNet"
    print_exc()
    LigandList_42=None

try:
    ## saving node showConformations ##
    from NetworkEditor.macros import MacroNode
    showConformations_43 = MacroNode(name='showConformations')
    masterNet.addNode(showConformations_43, 445, 605)
    output_Ports_45 = showConformations_43.macroNetwork.opNode
    apply(output_Ports_45.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_45.move(216, 474)
    from Vision.StandardNodes import Eval
    GetDLG_46 = Eval(constrkw={}, name='GetDLG', library=stdlib)
    showConformations_43.macroNetwork.addNode(GetDLG_46,279,87)
    apply(GetDLG_46.inputPortByName['in1'].configure, (), {'datatype': 'string', 'defaultValue': None, 'required': True, 'name': 'r', 'originalDatatype': 'None'})
    apply(GetDLG_46.addInputPort, (), {'singleConnection': True, 'name': 'l', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    GetDLG_46.inputPortByName['command'].widget.set(r"os.path.dirname(r)+os.sep+l+os.sep+l+'.dlg'", run=False)
    GetDLG_46.inputPortByName['importString'].widget.set(r"", run=False)
    code = """def doit(self, command, importString, r, l):
        import glob

        d = os.path.dirname(r)
        cwd = os.getcwd()
        os.chdir(d)
        dlg = glob.glob('''*.dlg''')
        os.chdir(cwd)

        if len(dlg) == 1:
            gdlg = os.path.join(d, dlg[0])
            self.outputData(result=gdlg)
        else:
            gdlg = os.path.dirname(r)+os.sep+l+os.sep+l+'''.dlg'''
            self.outputData(result=gdlg)










"""
    GetDLG_46.configure(function=code)
    apply(GetDLG_46.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_47 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    showConformations_43.macroNetwork.addNode(Pmv_47,104,190)
    Pmv_47.inputPortByName['cmdName'].widget.set(r"AD41analyze_readDLG", run=False)
    Pmv_47.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_47.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    AD41analyze_readDLG_48 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.AD41analyze_readDLG, namedArgs={'ask': 1, 'addToPrevious': 0}, posArgsNames=['dlgFile'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.AD41analyze_readDLG', 'namedArgs': {'ask': 1, 'addToPrevious': 0}, 'posArgsNames': ['dlgFile']}, name='AD41analyze_readDLG', library=pmvlib)
    showConformations_43.macroNetwork.addNode(AD41analyze_readDLG_48,195,271)
    apply(AD41analyze_readDLG_48.inputPortByName['dlgFile'].configure, (), {'defaultValue': None})
    apply(AD41analyze_readDLG_48.inputPortByName['ask'].configure, (), {'defaultValue': None})
    apply(AD41analyze_readDLG_48.inputPortByName['addToPrevious'].configure, (), {'defaultValue': None})
    apply(AD41analyze_readDLG_48.configure, (), {'specialPortsVisible': True})
    AD41analyze_readDLG_48.inputPortByName['importString'].widget.set(r"", run=False)
    AD41analyze_readDLG_48.inputPortByName['ask'].widget.set(1, run=False)
    AD41analyze_readDLG_48.inputPortByName['addToPrevious'].widget.set(0, run=False)
    apply(AD41analyze_readDLG_48.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_49 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    showConformations_43.macroNetwork.addNode(Pmv_49,106,322)
    apply(Pmv_49.configure, (), {'specialPortsVisible': True})
    Pmv_49.inputPortByName['cmdName'].widget.set(r"AD41analyze_showStates", run=False)
    Pmv_49.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_49.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    AD41analyze_showStates_50 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.AD41analyze_showStates, namedArgs={'log': 1}, posArgsNames=['mol'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.AD41analyze_showStates', 'namedArgs': {'log': 1}, 'posArgsNames': ['mol']}, name='AD41analyze_showStates', library=pmvlib)
    showConformations_43.macroNetwork.addNode(AD41analyze_showStates_50,331,400)
    apply(AD41analyze_showStates_50.inputPortByName['mol'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(AD41analyze_showStates_50.inputPortByName['log'].configure, (), {'defaultValue': None})
    AD41analyze_showStates_50.inputPortByName['importString'].widget.set(r"", run=False)
    AD41analyze_showStates_50.inputPortByName['log'].widget.set(1, run=False)
    apply(AD41analyze_showStates_50.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    GetMolList_51 = Generic(constrkw={}, name='GetMolList', library=stdlib)
    showConformations_43.macroNetwork.addNode(GetMolList_51,475,238)
    apply(GetMolList_51.addInputPort, (), {'singleConnection': True, 'name': 'Pmv', 'cast': True, 'datatype': 'PmvInstance', 'defaultValue': None, 'required': True, 'height': 12, 'width': 12, 'shape': 'circle', 'color': '#7A7AFF', 'originalDatatype': 'None'})
    apply(GetMolList_51.addInputPort, (), {'singleConnection': True, 'name': 'in1', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetMolList_51.addInputPort, (), {'singleConnection': True, 'name': 'in2', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetMolList_51.addOutputPort, (), {'name': 'out0', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    code = """def doit(self, Pmv, in1, in2):
        assert Pmv is not None
        receptor = os.path.basename(in1)
        receptor = receptor.split('''.''')[0]

        all = map(lambda x: x.name, Pmv.Mols)
         
        mols = list()

        for i in all:
            if i != in2 and i != receptor:
                mols.append(i)

        for i in Pmv.Mols:
            if i.name != in2 and i.name != receptor:
                i.spw.Close_cb()

        Pmv.showMolecules(mols, negate=True, log=0)

	pass
        self.outputData(out0=mols)







































"""
    GetMolList_51.configure(function=code)
    apply(GetMolList_51.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_52 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    showConformations_43.macroNetwork.addNode(Pmv_52,475,22)
    apply(Pmv_52.inputPortByName['cmdName'].configure, (), {'defaultValue': None})
    apply(Pmv_52.inputPortByName['molecules'].configure, (), {'defaultValue': None})
    Pmv_52.inputPortByName['cmdName'].widget.set(r"", run=False)
    Pmv_52.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_52.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Iterate
    iterate_53 = Iterate(constrkw={}, name='iterate', library=stdlib)
    showConformations_43.macroNetwork.addNode(iterate_53,475,294)
    iterate_53.inputPortByName['stopOnFailure'].widget.set(0, run=False)
    apply(iterate_53.configure, (), {'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_54 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    showConformations_43.macroNetwork.addNode(Pmv_54,723,308)
    apply(Pmv_54.inputPortByName['molecules'].configure, (), {'defaultValue': None})
    Pmv_54.inputPortByName['cmdName'].widget.set(r"deleteMol", run=False)
    apply(Pmv_54.inputPortByName['molecules'].widget.configure, (), {'initialValue': ''})
    Pmv_54.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_54.configure, (), {'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    deleteMol_55 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.deleteMol, posArgsNames=['nodes'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.deleteMol', 'posArgsNames': ['nodes']}, name='deleteMol', library=pmvlib)
    showConformations_43.macroNetwork.addNode(deleteMol_55,740,519)
    apply(deleteMol_55.inputPortByName['nodes'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    deleteMol_55.inputPortByName['importString'].widget.set(r"", run=False)
    apply(deleteMol_55.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network showConformations ##
    showConformations_43.macroNetwork.freeze()
    input_Ports_44 = showConformations_43.macroNetwork.ipNode
    if input_Ports_44 is not None and GetDLG_46 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                input_Ports_44, GetDLG_46, "new", "r", blocking=True
                , splitratio=[0.26234506821098308, 0.6656624353667191])
        except:
            print "WARNING: failed to restore connection between input_Ports_44 and GetDLG_46 in network showConformations_43.macroNetwork"
    if input_Ports_44 is not None and GetDLG_46 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                input_Ports_44, GetDLG_46, "new", "l", blocking=True
                , splitratio=[0.53453878173699376, 0.4159357464430653])
        except:
            print "WARNING: failed to restore connection between input_Ports_44 and GetDLG_46 in network showConformations_43.macroNetwork"
    if Pmv_47 is not None and AD41analyze_readDLG_48 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                Pmv_47, AD41analyze_readDLG_48, "cmd", "command", blocking=True
                , splitratio=[0.57491641052651632, 0.3442523394673046])
        except:
            print "WARNING: failed to restore connection between Pmv_47 and AD41analyze_readDLG_48 in network showConformations_43.macroNetwork"
    if GetDLG_46 is not None and AD41analyze_readDLG_48 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                GetDLG_46, AD41analyze_readDLG_48, "result", "dlgFile", blocking=True
                , splitratio=[0.47662859017673675, 0.50339935651828926])
        except:
            print "WARNING: failed to restore connection between GetDLG_46 and AD41analyze_readDLG_48 in network showConformations_43.macroNetwork"
    if Pmv_49 is not None and AD41analyze_showStates_50 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                Pmv_49, AD41analyze_showStates_50, "cmd", "command", blocking=True
                , splitratio=[0.64967078868628358, 0.64428057462546762])
        except:
            print "WARNING: failed to restore connection between Pmv_49 and AD41analyze_showStates_50 in network showConformations_43.macroNetwork"
    if input_Ports_44 is not None and AD41analyze_showStates_50 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                input_Ports_44, AD41analyze_showStates_50, "GetDLG_l", "mol", blocking=True
                , splitratio=[0.59773853174410363, 0.54712794118729791])
        except:
            print "WARNING: failed to restore connection between input_Ports_44 and AD41analyze_showStates_50 in network showConformations_43.macroNetwork"
    if AD41analyze_readDLG_48 is not None and Pmv_49 is not None:
        try:
            showConformations_43.macroNetwork.specialConnectNodes(
                AD41analyze_readDLG_48, Pmv_49, "trigger", "runNode", blocking=True
                , splitratio=[0.65295701563963271, 0.25994567324342494])
        except:
            print "WARNING: failed to restore connection between AD41analyze_readDLG_48 and Pmv_49 in network showConformations_43.macroNetwork"
    if Pmv_52 is not None and GetMolList_51 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                Pmv_52, GetMolList_51, "PMV", "Pmv", blocking=True
                , splitratio=[0.22281755983671137, 0.33186887241855467])
        except:
            print "WARNING: failed to restore connection between Pmv_52 and GetMolList_51 in network showConformations_43.macroNetwork"
    if input_Ports_44 is not None and GetMolList_51 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                input_Ports_44, GetMolList_51, "GetDLG_r", "in1", blocking=True
                , splitratio=[0.36237916545154802, 0.31658155256651488])
        except:
            print "WARNING: failed to restore connection between input_Ports_44 and GetMolList_51 in network showConformations_43.macroNetwork"
    if input_Ports_44 is not None and GetMolList_51 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                input_Ports_44, GetMolList_51, "GetDLG_l", "in2", blocking=True
                , splitratio=[0.255800713950466, 0.58101478394391592])
        except:
            print "WARNING: failed to restore connection between input_Ports_44 and GetMolList_51 in network showConformations_43.macroNetwork"
    if GetMolList_51 is not None and iterate_53 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                GetMolList_51, iterate_53, "out0", "listToLoopOver", blocking=True
                , splitratio=[0.44949206687942495, 0.36654806863201056])
        except:
            print "WARNING: failed to restore connection between GetMolList_51 and iterate_53 in network showConformations_43.macroNetwork"
    if Pmv_54 is not None and deleteMol_55 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                Pmv_54, deleteMol_55, "cmd", "command", blocking=True
                , splitratio=[0.4998784570684916, 0.65389681202102112])
        except:
            print "WARNING: failed to restore connection between Pmv_54 and deleteMol_55 in network showConformations_43.macroNetwork"
    if iterate_53 is not None and deleteMol_55 is not None:
        try:
            showConformations_43.macroNetwork.connectNodes(
                iterate_53, deleteMol_55, "oneItem", "nodes", blocking=True
                , splitratio=[0.44123508306032516, 0.65896171775828805])
        except:
            print "WARNING: failed to restore connection between iterate_53 and deleteMol_55 in network showConformations_43.macroNetwork"
    showConformations_43.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_44.outputPorts[1].configure(name='GetDLG_r')
    input_Ports_44.outputPorts[2].configure(name='GetDLG_l')
    showConformations_43.inputPorts[0].configure(name='GetDLG_r')
    showConformations_43.inputPorts[0].configure(datatype='string')
    showConformations_43.inputPorts[1].configure(name='GetDLG_l')
    showConformations_43.inputPorts[1].configure(datatype='string')
    ## configure MacroNode input ports
    ## configure MacroNode output ports
    showConformations_43.shrink()
    apply(showConformations_43.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named showConformations in network masterNet"
    print_exc()
    showConformations_43=None

#masterNet.run()
masterNet.freeze()

## saving connections for network visualization-0.1.2 ##
if AutoDock_VS_Result_Directory_28 is not None and GetReceptors_29 is not None:
    try:
        masterNet.connectNodes(
            AutoDock_VS_Result_Directory_28, GetReceptors_29, "AbsPath_directory", "dir", blocking=True
            , splitratio=[0.55778921299744577, 0.56280875000248676])
    except:
        print "WARNING: failed to restore connection between AutoDock_VS_Result_Directory_28 and GetReceptors_29 in network masterNet"
if GetReceptors_29 is not None and ReceptorList_30 is not None:
    try:
        masterNet.connectNodes(
            GetReceptors_29, ReceptorList_30, "receptors", "valueList", blocking=True
            , splitratio=[0.49417000742132478, 0.47069046596772096])
    except:
        print "WARNING: failed to restore connection between GetReceptors_29 and ReceptorList_30 in network masterNet"
LoadMolecule_31 = masterNet.nodes[3]
if ReceptorList_30 is not None and LoadMolecule_31 is not None:
    try:
        masterNet.connectNodes(
            ReceptorList_30, LoadMolecule_31, "selection", "getMolePath_mol", blocking=True
            , splitratio=[0.58076619839464139, 0.55084429716865135])
    except:
        print "WARNING: failed to restore connection between ReceptorList_30 and LoadMolecule_31 in network masterNet"
if GetReceptors_29 is not None and LoadMolecule_31 is not None:
    try:
        masterNet.connectNodes(
            GetReceptors_29, LoadMolecule_31, "receptor_paths", "getMolePath_mol_paths", blocking=True
            , splitratio=[0.26226541430302935, 0.64839302256375586])
    except:
        print "WARNING: failed to restore connection between GetReceptors_29 and LoadMolecule_31 in network masterNet"
if GetReceptors_29 is not None and GetLigands_41 is not None:
    try:
        masterNet.connectNodes(
            GetReceptors_29, GetLigands_41, "receptor_paths", "rps", blocking=True
            , splitratio=[0.65123470982731246, 0.32544270134226649])
    except:
        print "WARNING: failed to restore connection between GetReceptors_29 and GetLigands_41 in network masterNet"
if ReceptorList_30 is not None and GetLigands_41 is not None:
    try:
        masterNet.connectNodes(
            ReceptorList_30, GetLigands_41, "selection", "r", blocking=True
            , splitratio=[0.42878253007466194, 0.72341691404242114])
    except:
        print "WARNING: failed to restore connection between ReceptorList_30 and GetLigands_41 in network masterNet"
if GetLigands_41 is not None and LigandList_42 is not None:
    try:
        masterNet.connectNodes(
            GetLigands_41, LigandList_42, "ligands", "valueList", blocking=True
            , splitratio=[0.63046613222846459, 0.43881484615970567])
    except:
        print "WARNING: failed to restore connection between GetLigands_41 and LigandList_42 in network masterNet"
showConformations_43 = masterNet.nodes[6]
if LoadMolecule_31 is not None and showConformations_43 is not None:
    try:
        masterNet.connectNodes(
            LoadMolecule_31, showConformations_43, "getMolePath_mol_path", "GetDLG_r", blocking=True
            , splitratio=[0.33003249460940892, 0.589279306283232])
    except:
        print "WARNING: failed to restore connection between LoadMolecule_31 and showConformations_43 in network masterNet"
if LigandList_42 is not None and showConformations_43 is not None:
    try:
        masterNet.connectNodes(
            LigandList_42, showConformations_43, "selection", "GetDLG_l", blocking=True
            , splitratio=[0.53554392069653656, 0.40654195768645573])
    except:
        print "WARNING: failed to restore connection between LigandList_42 and showConformations_43 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

